<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html lang="en">
<head>
    <title id='Description'>jqxChart Pie Series Legend Example</title>
    <link rel="stylesheet" href="js2/jqx.base.css" type="text/css" />
    <script type="text/javascript" src="js2/jquery-1.10.2.min.js"></script>
    <script type="text/javascript" src="js2/jqxcore.js"></script>
    <script type="text/javascript" src="js2/jqxchart.js"></script>
    <script type="text/javascript" src="js2/jqxdata.js"></script>

     <!-- MODELO PIZZA -->
    <script type="text/javascript">
        $(document).ready(function () {
            // prepare chart data as an array
            var source =
            {
                datatype: "csv",
                datafields: [
                    { name: 'Browser' },
                    { name: 'Share' }
                ],
                url: 'mobile_browsers_share_dec2011.txt'
            };
            var dataAdapter = new $.jqx.dataAdapter(source, { async: false, autoBind: true, loadError: function (xhr, status, error) { alert('Error loading "' + source.url + '" : ' + error); } });
            // prepare jqxChart settings
            var settings = {
                title: false,
                description: false,
                enableAnimations: true,
                showLegend: true,
                legendLayout: { left: 500, top: 140, width: 300, height: 200, flow: 'vertical' },
                padding: { left: 5, top: 5, right: 5, bottom: 5 },
                titlePadding: { left: 0, top: 0, right: 0, bottom: 10 },
                source: dataAdapter,
                colorScheme: 'scheme03',
                seriesGroups:
                    [
                        {
                            type: 'pie',
                            showLabels: true,
                            series:
                                [
                                    { 
                                        dataField: 'Share',
                                        displayText: 'Browser',
                                        labelRadius: 120,
                                        initialAngle: 15,
                                        radius: 95,
                                        centerOffset: 0,
                                        formatFunction: function (value) {
                                            if (isNaN(value))
                                                return value;
                                            return parseFloat(value) + '%';
                                        },
                                    }
                                ]
                        }
                    ]
            };
            // setup the chart
            $('#jqxChart').jqxChart(settings);
        });
    </script>

    <!-- MODELO ROSCA -->

    <script type="text/javascript">
        $(document).ready(function () {
            // prepare chart data as an array
            var source =
            {
                datatype: "csv",
                datafields: [
                    { name: 'Browser' },
                    { name: 'Share' }
                ],
                url: 'mobile_browsers_share_dec2011.txt'
            };
            var dataAdapter = new $.jqx.dataAdapter(source, { async: false, autoBind: true, loadError: function (xhr, status, error) { alert('Error loading "' + source.url + '" : ' + error); } });
            // prepare jqxChart settings
            var settings = {
                title: "Desktop browsers share in Dec 2011",
                description: "(source: wikipedia.org)",
                enableAnimations: true,
                showLegend: false,
                legendPosition: { left: 520, top: 140, width: 100, height: 100 },
                padding: { left: 5, top: 5, right: 5, bottom: 5 },
                titlePadding: { left: 0, top: 0, right: 0, bottom: 10 },
                source: dataAdapter,
                colorScheme: 'scheme02',
                seriesGroups:
                    [
                        {
                            type: 'donut',
                            showLabels: true,
                            series:
                                [
                                    {
                                        dataField: 'Share',
                                        displayText: 'Browser',
                                        labelRadius: 100,
                                        initialAngle: 15,
                                        radius: 130,
                                        innerRadius: 50,
                                        centerOffset: 0,
                                        formatSettings: { sufix: '%', decimalPlaces: 1 }
                                    }
                                ]
                        }
                    ]
            };
            // setup the chart
            $('#jqxChart2').jqxChart(settings);
        });
    </script>

    <!-- MODELO BARRAS HORIZONTAIS -->

    <script type="text/javascript">
        $(document).ready(function () {
            // prepare chart data
            var sampleData = [
                { Country: 'China', Population: 1347350000, Percent: 19.18},
                { Country: 'India', Population: 1210193422, Percent: 17.22},
                { Country: 'USA', Population: 313912000, Percent: 4.47},
                { Country: 'Indonesia', Population: 237641326, Percent: 3.38},
                { Country: 'Brazil', Population: 192376496, Percent: 2.74}];
            // prepare jqxChart settings
            var settings = {
                title: "Top 5 most populated countries",
                description: "Statistics for 2011",
                showLegend: true,
                enableAnimations: true,
                padding: { left: 20, top: 5, right: 20, bottom: 5 },
                titlePadding: { left: 90, top: 0, right: 0, bottom: 10 },
                source: sampleData,
                categoryAxis:
                    {
                        dataField: 'Country',
                        showGridLines: true,
                        flip: false
                    },
                colorScheme: 'scheme03',
                seriesGroups:
                    [
                        {
                            type: 'column',
                            orientation: 'horizontal',
                            columnsGapPercent: 100,
                            toolTipFormatSettings: { thousandsSeparator: ',' },
                            valueAxis:
                            {
                                flip: true,
                                unitInterval: 100000000,
                                maxValue: 1500000000,
                                displayValueAxis: true,
                                description: '',
                                formatFunction: function (value) {
                                    return parseInt(value / 1000000);
                                }
                            },
                            series: [
                                    { dataField: 'Population', displayText: 'Population (millions)' }
                                ]
                        }
                    ]
            };
            // setup the chart
            $('#jqxChart3').jqxChart(settings);
        });
    </script>

    <script type="text/javascript">
        $(document).ready(function () {
            // prepare chart data as an array
            var sampleData = [
                    { Day: 'Monday', Running: 30, Swimming: 0, Cycling: 25 },
                    { Day: 'Tuesday', Running: 25, Swimming: 25, Cycling: 0 },
                    { Day: 'Wednesday', Running: 30, Swimming: 0, Cycling: 25 },
                    { Day: 'Thursday', Running: 35, Swimming: 25, Cycling: 45 },
                    { Day: 'Friday', Running: 0, Swimming: 20, Cycling: 25 },
                    { Day: 'Saturday', Running: 30, Swimming: 0, Cycling: 30 },
                    { Day: 'Sunday', Running: 60, Swimming: 45, Cycling: 0 }
                ];
            // prepare jqxChart settings
            var settings = {
                title: "Fitness & exercise weekly scorecard",
                description: "Time spent in vigorous exercise by activity",
                enableAnimations: true,
                showLegend: true,
                padding: { left: 5, top: 5, right: 5, bottom: 5 },
                titlePadding: { left: 90, top: 0, right: 0, bottom: 10 },
                source: sampleData,
                categoryAxis:
                    {
                        text: 'Category Axis',
                        textRotationAngle: 0,
                        dataField: 'Day',
                        showTickMarks: true,
                        tickMarksInterval: 1,
                        tickMarksColor: '#888888',
                        unitInterval: 1,
                        showGridLines: false,
                        gridLinesInterval: 1,
                        gridLinesColor: '#888888',
                        axisSize: 'auto'
                    },
                colorScheme: 'scheme06',
                seriesGroups:
                    [
                        {
                            type: 'stackedcolumn',
                            columnsGapPercent: 100,
                            seriesGapPercent: 5,
                            valueAxis:
                            {
                                unitInterval: 10,
                                minValue: 0,
                                maxValue: 100,
                                displayValueAxis: true,
                                description: 'Time in minutes',
                                axisSize: 'auto',
                                tickMarksColor: '#888888'
                            },
                            series: [
                                   // { dataField: 'Running', displayText: 'Running' },
                                   // { dataField: 'Swimming', displayText: 'Swimming' },
                                    { dataField: 'Cycling', displayText: 'Cycling' }
                                ]
                        }
                    ]
            };
            // setup the chart
            $('#jqxChart4').jqxChart(settings);
        });
    </script>
    <script type="text/javascript">
        $(document).ready(function () {
            var sampleData = [{ a: 0.35, b: 14.5, c:11.3 }];
            var settings = {
                title: "Logarithmic Scale Axis Example",
                description: "Sample logarithmic scale axis with base 2",
                padding: { left: 5, top: 5, right: 5, bottom: 5 },
                titlePadding: { left: 0, top: 0, right: 0, bottom: 10 },
                source: sampleData,
                enableAnimations: true,
                categoryAxis:
                        {
                            dataField: '',
                            description: '',
                            showGridLines: true,
                            showTickMarks: true
                        },
                seriesGroups:
                        [
                            {
                            type: 'column',
                            valueAxis: {
                                description: 'Value',
                                logarithmicScale: true,
                                logarithmicScaleBase: 2,
                                unitInterval: 1,
                                tickMarksInterval: 1,
                                gridLinesInterval: 1,
                                formatSettings: { decimalPlaces: 3 },
                                horizontalTextAlignment: 'right'
                            },
                            series: [
                                        { dataField: 'a', displayText: 'A' },
                                         { dataField: 'b', displayText: 'B' },
                                        { dataField: 'c', displayText: 'C' }
                                    ]
                            }
                        ]
            };
            $('#chartContainer').jqxChart(settings);
        });
</script>
</head>
<body class='default'>
    <div id='host' style="margin: 0 auto; width: 699px; height: 400px;">
        <div id='jqxChart' style="width: 680px; height: 400px; position: relative; left: 0px; top: 0px;"></div>
        <div id='jqxChart2' style="width: 680px; height: 400px; position: relative; left: 0px; top: 0px;"></div>
        <div id='jqxChart3' style="width: 680px; height: 400px; position: relative; left: 0px; top: 0px;"></div>
         <div id='jqxChart4' style="width: 680px; height: 400px; position: relative; left: 0px; top: 0px;"></div>
         <div id='chartContainer' style="width: 680px; height: 400px; position: relative; left: 0px; top: 0px;"></div>
    </div>
</body>
</html>