<?php
header("Access-Control-Allow-Origin: *");
header('Content-Type: text/html; charset=utf-8');

$data = file_get_contents("php://input");
$objData = json_decode($data);
$id = $objData->id;
$cancelados = $objData->cancelados;
$concluidos = $objData->concluidos;
$total = $objData->total;
$participantes = $objData->participantes;
$acompanhante = $objData->acompanhante;
$atributos_participantes = $objData->atributos_participantes;
$enderecos = $objData->endereco;
$mini_exame = $objData->mini_exame;
$trdap_teste_a = $objData->trdap_teste_a;
$trdap_teste_b = $objData->trdap_teste_b;
$trdap_teste_c = $objData->trdap_teste_c;
$resultado_trdap = $objData->resultado_trdap;
$reconhecimento_proverbios = $objData->reconhecimento_proverbios;

include('classes_app/classe_querys.php');
$id = $objData->id;
$conexao = new Query();
$conexao->logar();
if(count($participantes) > 0){
	foreach ($participantes as $participante) {
		$exists = $conexao->buscarParticipanteID($participante->id, $id);
		$id_participante = $participante->id;
		unset($participante->id);
		unset($participante->atualizacao);
		$dados = (array)$participante;
		if($exists){
			$return = $conexao->editar('participantes', $dados, $id_participante);
			if($return != '00'){
				echo json_encode('Erro na atualização do participante '.$dados['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('participantes', $dados);
			if($return != '00'){
				echo json_encode('Erro na inclusão do participante '.$dados['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}

if(count($acompanhante) > 0){
	foreach ($acompanhante as $acompanhante) {
		$id_acompanhante = $acompanhante->id;
		$exists = $conexao->getAcompanhantePorId($id_acompanhante, $acompanhante->id_participante);
		unset($acompanhante->id);
		unset($acompanhante->atualizacao);
		$dados = (array)$acompanhante;
		if($exists){
			$return = $conexao->editar('acompanhante', $dados, $id_acompanhante);
			if($return != '00'){
				echo json_encode('Erro na atualização do acompanhante '.$dados['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('acompanhante', $dados);
			if($return != '00'){
				echo json_encode('Erro na inclusão do acompanhante '.$dados['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if(count($atributos_participantes) > 0){
	foreach ($atributos_participantes as $atributos_participantes) {
		$id_atributos_participantes = $atributos_participantes->id;
		$exists = $conexao->getAtributosParticipantesPorId($id_atributos_participantes, $atributos_participantes->id_participante);
		unset($atributos_participantes->id);
		unset($atributos_participantes->atualizacao);
		$dados = (array)$atributos_participantes;
		if($exists){
			$return = $conexao->editar('atributos_participantes', $dados, $id_atributos_participantes);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($atributos_participantes->id_participante, $id);
				echo json_encode('Erro na atualização dos atributos do participante do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('atributos_participantes', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($atributos_participantes->id_participante, $id);
				echo json_encode('Erro na inclusão do atributos do participantes '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if(count($endereco) > 0){
	foreach ($endereco as $endereco) {
		$id_endereco = $endereco->id;
		$exists = $conexao->getEnderecoParticipante($id_endereco, $endereco->id_participante);
		unset($endereco->id);
		unset($endereco->atualizacao);
		$dados = (array)$endereco;
		if($exists){
			$return = $conexao->editar('endereco', $dados, $id_endereco);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($endereco->id_participante, $id);
				echo json_encode('Erro na atualização do endereço do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('endereco', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($endereco->id_participante, $id);
				echo json_encode('Erro na inclusão do endereços '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if(count($enderecos) > 0){
	foreach ($enderecos as $endereco) {
		$id_endereco = $endereco->id;
		$exists = $conexao->getEnderecoParticipanteId($id_endereco, $endereco->id_participante);
		unset($endereco->id);
		unset($endereco->atualizacao);
		$dados = (array)$endereco;
		if($exists){
			$return = $conexao->editar('endereco', $dados, $id_endereco);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($endereco->id_participante, $id);
				echo json_encode('Erro na atualização do endereço do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('endereco', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($endereco->id_participante, $id);
				echo json_encode('Erro na inclusão do endereços '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if(count($mini_exame) > 0){
	foreach ($mini_exame as $mini_exame) {
		$id_mini_exame = $mini_exame->id;
		$exists = $conexao->buscaPorCodigo('mini_exame', $mini_exame->codigo);
		unset($mini_exame->id);
		unset($mini_exame->atualizacao);
		$dados = (array)$mini_exame;
		if($exists){
			$return = $conexao->editar('mini_exame', $dados, $id_mini_exame);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($mini_exame->id_participante, $id);
				echo json_encode('Erro na atualização do Mini Exame do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('mini_exame', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($mini_exame->id_participante, $id);
				echo json_encode('Erro na inclusão do Mini Exame '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if(count($trdap_teste_a) > 0){
	foreach ($trdap_teste_a as $trdap_teste_a) {
		$id_trdap_teste_a = $trdap_teste_a->id;
		$exists = $conexao->buscaPorCodigo('trdap_teste_a', $trdap_teste_a->codigo);
		unset($trdap_teste_a->id);
		unset($trdap_teste_a->atualizacao);
		$dados = (array)$trdap_teste_a;
		if($exists){
			$return = $conexao->editar('trdap_teste_a', $dados, $id_trdap_teste_a);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($trdap_teste_a->id_participante, $id);
				echo json_encode('Erro na atualização do TRDAP etapa A do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('trdap_teste_a', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($trdap_teste_a->id_participante, $id);
				echo json_encode('Erro na inclusão do TRDAP etapa A '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if(count($trdap_teste_b) > 0){
	foreach ($trdap_teste_b as $trdap_teste_b) {
		$id_trdap_teste_b = $trdap_teste_b->id;
		$exists = $conexao->buscaPorCodigo('trdap_teste_b', $trdap_teste_b->codigo);
		unset($trdap_teste_b->id);
		unset($trdap_teste_b->atualizacao);
		$dados = (array)$trdap_teste_b;
		if($exists){
			$return = $conexao->editar('trdap_teste_b', $dados, $id_trdap_teste_b);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($trdap_teste_b->id_participante, $id);
				echo json_encode('Erro na atualização do TRDAP etapa B do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('trdap_teste_b', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($trdap_teste_b->id_participante, $id);
				echo json_encode('Erro na inclusão do TRDAP etapa B '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if(count($trdap_teste_c) > 0){
	foreach ($trdap_teste_c as $trdap_teste_c) {
		$id_trdap_teste_c = $trdap_teste_c->id;
		$exists = $conexao->buscaPorCodigo('trdap_teste_c', $trdap_teste_c->codigo);
		unset($trdap_teste_c->id);
		unset($trdap_teste_c->atualizacao);
		$dados = (array)$trdap_teste_c;
		if($exists){
			$return = $conexao->editar('trdap_teste_c', $dados, $id_trdap_teste_c);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($trdap_teste_c->id_participante, $id);
				echo json_encode('Erro na atualização do TRDAP etapa C do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('trdap_teste_c', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($trdap_teste_c->id_participante, $id);
				echo json_encode('Erro na inclusão do TRDAP etapa C '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}

$sumTrdap = 0;
if(count($resultado_trdap) > 0){
	foreach ($resultado_trdap as $resultado_trdap) {
		$id_resultado_trdap = $resultado_trdap->id;
		$exists = $conexao->buscaPorCodigo('resultado_trdap', $resultado_trdap->codigo);
		unset($resultado_trdap->id);
		unset($resultado_trdap->atualizacao);
		$dados = (array)$resultado_trdap;
		if($exists){
			$return = $conexao->editar('resultado_trdap', $dados, $id_resultado_trdap);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($resultado_trdap->id_participante, $id);
				echo json_encode('Erro na atualização do resultado do TRDAP do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$sumTrdap++;
			$return = $conexao->inserir('resultado_trdap', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($resultado_trdap->id_participante, $id);
				echo json_encode('Erro na inclusão do resultado do TRDAP '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if(count($reconhecimento_proverbios) > 0){
	foreach ($reconhecimento_proverbios as $reconhecimento_proverbios) {
		$id_reconhecimento_proverbios = $reconhecimento_proverbios->id;
		$exists = $conexao->buscaPorCodigo('reconhecimento_proverbios', $reconhecimento_proverbios->codigo);
		unset($reconhecimento_proverbios->id);
		unset($reconhecimento_proverbios->atualizacao);
		$dados = (array)$reconhecimento_proverbios;
		if($exists){
			$return = $conexao->editar('reconhecimento_proverbios', $dados, $id_reconhecimento_proverbios);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($reconhecimento_proverbios->id_participante, $id);
				echo json_encode('Erro na atualização do resultado do reconhecimento de provérbios do participante '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		} else {
			$return = $conexao->inserir('reconhecimento_proverbios', $dados);
			if($return != '00'){
				$participante_error = $conexao->buscarParticipanteID($reconhecimento_proverbios->id_participante, $id);
				echo json_encode('Erro na inclusão do resultado do reconhecimento de provérbios '.$participante_error['nome']."\nFavor entrar em contato com administrador");
				exit();
			}
		}
	}
}


if($sumTrdap > 0){
	$procuraNumTeste = $conexao->procurarId('usuario',$id);
	$num_testes = $procuraNumTeste[0]['num_testes'] - $sumTrdap + 1;
	if($num_testes < 1){
		$num_testes = 1;
	}
	$return = $conexao->decrementarTeste($id, $num_testes);
	if(!$return){
		echo json_encode('Erro na atualização do total de testes');

	}
}

echo true;