angular.module('app.services', [])

.factory('BlankFactory', [function(){

}])

.service("Data", function($http){
	//recuperação de dados

	this.dateDiff = function (date1, date2) {
		var theevent = new Date(date1);
		now = new Date(date2);
		var sec_num = (theevent - now) / 1000;
		var days    = Math.floor(sec_num / (3600 * 24));
		var hours   = Math.floor((sec_num - (days * (3600 * 24)))/3600);
		var minutes = Math.floor((sec_num - (days * (3600 * 24)) - (hours * 3600)) / 60);
		var seconds = Math.floor(sec_num - (days * (3600 * 24)) - (hours * 3600) - (minutes * 60));

		if (hours   < 10) {hours   = "0"+hours;}
		if (minutes < 10) {minutes = "0"+minutes;}
		if (seconds < 10) {seconds = "0"+seconds;}

		return  hours+':'+minutes+':'+seconds;
	}

	this.getNow = function() {
		now = new Date();
		year = "" + now.getFullYear();
		month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
	}



	this.getData = function(params){
		return $http({
			method: "POST",
			url: "http://www.roquejunior.com/clientes/mauricea/trdap/getUserData.php",
			// url: "http://192.168.43.1/mauricea/trdap/getUserData.php",
			data: params,
			headers : {
				'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF-8'
			}
		});
	};
	//recuperação de credencial
	this.loginData = function(credential){
		return $http({
			method: "POST",
			url: "http://www.roquejunior.com/clientes/mauricea/trdap/login_app.php",
			// url: "http://192.168.43.1/mauricea/trdap/login_app.php",
			data: credential,
			headers : {
				'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF-8'
			}
		});
	};

	this.getDatabase = function(){
		id = localStorage.getItem('id');
		id = id.replace('"', '');
		id = id.replace('"', '');
		db = window.openDatabase("trdap__"+id+".db", '1', 'trdap', "2000");
		return db;
	}

	this.getParticipantes = function($){
		localStorage.removeItem('arrParticipantes');
		var query = "SELECT * FROM participantes ORDER BY data_cadastro DESC",
			db = this.getDatabase(),
			participantes = [];
		db.transaction(function(transaction) {
		transaction.executeSql(query, [], function (tx, results) {
			var len = results.rows.length, i;
			for (i = 0; i < len; i++){
				participantes.push(results.rows.item(i));
			}
		}, null);
		},function(tx, resultSet) {
		}, function(tx, error) {
		});
		localStorage.setItem('arrParticipantes', JSON.stringify(participantes));
		return participantes;
	}

	this.getParticipantesPorId = function(id){
		var query = "SELECT * FROM participantes WHERE id = "+id;
		db = this.getDatabase();
		db.transaction(function(transaction) {
		transaction.executeSql(query, [], function (tx, results) {
			var len = results.rows.length;
			if(len > 0){
				return results.rows.item(0);
			} else {
				return false;
			}
		}, null);
		});
	}

	this.getTrdapA = function(codigo){
		var query = "SELECT * FROM trdap_teste_a WHERE codigo = '"+codigo+"'";
		db = this.getDatabase();
		db.transaction(function(transaction) {
		transaction.executeSql(query, [], function (tx, results) {
			var len = results.rows.length;
			if(len > 0){
				return results.rows.item(0);
			} else {
				return false;
			}
		}, null);
		});
	}

	this.getTrdapB = function(codigo){
		var query = "SELECT * FROM trdap_teste_b WHERE codigo = "+codigo;
		db = this.getDatabase();
		db.transaction(function(transaction) {
		transaction.executeSql(query, [], function (tx, results) {
			var len = results.rows.length;
			if(len > 0){
				return results.rows.item(0);
			} else {
				return false;
			}
		}, null);
		});
	}

	this.getTrdapC = function(codigo){
		var query = "SELECT * FROM trdap_teste_c WHERE codigo = "+codigo;
		db = this.getDatabase();
		db.transaction(function(transaction) {
		transaction.executeSql(query, [], function (tx, results) {
			var len = results.rows.length;
			if(len > 0){
				return results.rows.item(0);
			} else {
				return false;
			}
		}, null);
		});
	}

	this.getAtributosParticipantesPorId = function(id){
		var query_atributos_participantes = "SELECT * FROM atributos_participantes WHERE id_participante = "+id;
		db = this.getDatabase();
		db.transaction(function(transaction_atributos_participantes) {
		transaction_atributos_participantes.executeSql(query_atributos_participantes, [], function (tx_atributos_participantes, results_atributos_participantes) {
			var len = results_atributos_participantes.rows.length;
			if (len > 0){
				return results_atributos_participantes.rows.item(0);
			}
		}, null);
		});
		return false;
	}

	this.addParticipante = function(data, user){
		var participante = {},
			date = Math.floor(Date.now() / 1000);
		participante[date] = {
								data_cadastro: Date.now(),
								data_nascimento: data.data_nascimento || '',
								email: data.email || '',
								estado_civil: data.estado_civil || '',
								fone_celular: data.celular || '',
								fone_fixo: data.telefone || '',
								id: date || '',
								id_pesquisador: 0,
								id_usuario: user.id,
								idade: data.idade || '',
								local_atend: data.local_atend || '',
								nome: data.nome || '',
								profissao: data.profissao || '',
								status: 1,
							 }
	}

	this.populeDatabase = function(info, id, cordovaSQLite){
								var qtdParticipantes,
									qtdAcompanhante;
								db.transaction(function(tx) {
									tx.executeSql('INSERT INTO usuario ( id, data, nome, login, senha, email, fone, rua, bairro, cidade, estado, pais, cep, numero, complemento, profissao, status, id_usuario, nivel, num_testes ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
												[id, info.user[0].data, info.user[0].nome, info.user[0].login, info.user[0].senha, info.user[0].email, info.user[0].fone, info.user[0].rua, info.user[0].bairro, info.user[0].cidade, info.user[0].estado, info.user[0].pais, info.user[0].cep, info.user[0].numero, info.user[0].complemento, info.user[0].profissao, info.user[0].status, info.user[0].id_usuario, info.user[0].nivel, info.user[0].num_testes], 
												function(tx, resultSet) {
									}, function(tx, error) {
									});
									
									qtdParticipantes = info.participantes.length;
									participantes = info.participantes;
									for (var i = 0; i < qtdParticipantes; i++) {
										tx.executeSql('INSERT INTO participantes ( id, id_usuario, id_pesquisador, nome, data_nascimento, idade, estado_civil, profissao, fone_fixo, fone_celular, email, local_atend, status, data_cadastro)  VALUES (? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,?) ',
													[participantes[i].id, participantes[i].id_usuario, participantes[i].id_pesquisador, participantes[i].nome, participantes[i].data_nascimento, participantes[i].idade, participantes[i].estado_civil, participantes[i].profissao, participantes[i].fone_fixo, participantes[i].fone_celular, participantes[i].email, participantes[i].local_atend, participantes[i].status, participantes[i].data_cadastro], 
										function(tx, resultSet) {
										}, function(tx, error) {
										});

										qtdAcompanhante = participantes[i].acompanhante.length;
										acompanhantes = participantes[i].acompanhante;
										for (var ac = 0; ac < qtdAcompanhante; ac++) {
											tx.executeSql('INSERT INTO acompanhante (id , nome , telefone , id_participante) VALUES(? ,? ,? ,?)',
														[acompanhantes[ac].id, acompanhantes[ac].nome, acompanhantes[ac].telefone, acompanhantes[ac].id_participante], 
														function(tx, resultSet) {
											}, function(tx, error) {
											});
										}

										qtdAtributosAcompanhante = participantes[i].atributos_participantes.length;
										atributos_participantes = participantes[i].atributos_participantes;
										for (var aa = 0; aa < qtdAtributosAcompanhante; aa++) {
											tx.executeSql('INSERT INTO atributos_participantes ( id, id_participante, cursos, conveniencia, terapias, habito_leitura, habito_escrita, participacoes, atividade_social, atividade_fisica, saude, problema_memoria, int_cotidiano, mora, escolaridade, renda_mensal, demencia_diagnotic, dominancia, religiao) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',
														[atributos_participantes[aa].id,atributos_participantes[aa].id_participante,atributos_participantes[aa].cursos,atributos_participantes[aa].conveniencia,atributos_participantes[aa].terapias,atributos_participantes[aa].habito_leitura,atributos_participantes[aa].habito_escrita,atributos_participantes[aa].participacoes,atributos_participantes[aa].atividade_social,atributos_participantes[aa].atividade_fisica,atributos_participantes[aa].saude,atributos_participantes[aa].problema_memoria,atributos_participantes[aa].int_cotidiano,atributos_participantes[aa].mora,atributos_participantes[aa].escolaridade,atributos_participantes[aa].renda_mensal,atributos_participantes[aa].demencia_diagnotic,atributos_participantes[aa].dominancia,atributos_participantes[aa].religiao], 
														function(tx, resultSet) {
											}, function(tx, error) {
											});
										}

										qtdMiniExames = participantes[i].mini_exames.length;
										mini_exames = participantes[i].mini_exames;
										for (var me = 0; me < qtdMiniExames; me++) {
											tx.executeSql('INSERT INTO mini_exame (id, id_participante, codigo, data, orientacao_temporal, orientacao_espacial, memoria_imediata, atencao_calculo, memoria_evocacao, linguagem, total, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
														[mini_exames[me].id, mini_exames[me].id_participante, mini_exames[me].codigo, mini_exames[me].data, mini_exames[me].orientacao_temporal, mini_exames[me].orientacao_espacial, mini_exames[me].memoria_imediata, mini_exames[me].atencao_calculo, mini_exames[me].memoria_evocacao, mini_exames[me].linguagem, mini_exames[me].total, mini_exames[me].status], 
														function(tx, resultSet) {
											}, function(tx, error) {
											});
										}

										qtdReconhecimentoProverbios = participantes[i].reconhecimento_proverbios.length;
										reconhecimento_proverbios = participantes[i].reconhecimento_proverbios;
										for (var rp = 0; rp < qtdReconhecimentoProverbios; rp++) {
											tx.executeSql('INSERT INTO reconhecimento_proverbios (id, id_participante, codigo, reconhecimento1, reconhecimento2, reconhecimento3, reconhecimento4, reconhecimento5, reconhecimento6, data, total, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
														[reconhecimento_proverbios[rp].id, reconhecimento_proverbios[rp].id_participante, reconhecimento_proverbios[rp].codigo, reconhecimento_proverbios[rp].reconhecimento1, reconhecimento_proverbios[rp].reconhecimento2, reconhecimento_proverbios[rp].reconhecimento3, reconhecimento_proverbios[rp].reconhecimento4, reconhecimento_proverbios[rp].reconhecimento5, reconhecimento_proverbios[rp].reconhecimento6, reconhecimento_proverbios[rp].data, reconhecimento_proverbios[rp].total, reconhecimento_proverbios[rp].status] ,
														function(tx, resultSet) {
											}, function(tx, error) {
											});
										}

										qtdResultadoTrdap = participantes[i].resultado_trdap.length;
										resultado_trdap = participantes[i].resultado_trdap;
										
										for (var rt = 0; rt < qtdResultadoTrdap; rt++) {
											tx.executeSql('INSERT INTO resultado_trdap (id, id_participante, data_inicio, data_fim, codigo, status, total, edita) \
															VALUES \
															(?, ?, ?, ?, ?, ?, ?, ?)',
														[resultado_trdap[rt].id, resultado_trdap[rt].id_participante, resultado_trdap[rt].data_inicio, resultado_trdap[rt].data_fim, resultado_trdap[rt].codigo, resultado_trdap[rt].status, resultado_trdap[rt].total, resultado_trdap[rt].edita] ,
														function(tx, resultSet) {
											}, function(tx, error) {
											});
										}

										qtdTrdapTesteA = participantes[i].trdap_teste_a.length;
										trdap_teste_a = participantes[i].trdap_teste_a;
										for (var tta = 0; tta < qtdTrdapTesteA; tta++) {
											tx.executeSql('INSERT INTO trdap_teste_a (id, id_participante, obs, data, codigo, a_ordem1, a_ordem2, a_ordem3, b_ordem1, b_ordem2, b_ordem3, c_ordem1, c_ordem2, c_ordem3, a_ponto1, a_ponto2, a_ponto3, b_ponto1, b_ponto2, b_ponto3, c_ponto1, c_ponto2, c_ponto3, total, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
														[trdap_teste_a[tta].id, trdap_teste_a[tta].id_participante, trdap_teste_a[tta].obs, trdap_teste_a[tta].data, trdap_teste_a[tta].codigo, trdap_teste_a[tta].a_ordem1, trdap_teste_a[tta].a_ordem2, trdap_teste_a[tta].a_ordem3, trdap_teste_a[tta].b_ordem1, trdap_teste_a[tta].b_ordem2, trdap_teste_a[tta].b_ordem3, trdap_teste_a[tta].c_ordem1, trdap_teste_a[tta].c_ordem2, trdap_teste_a[tta].c_ordem3, trdap_teste_a[tta].a_ponto1, trdap_teste_a[tta].a_ponto2, trdap_teste_a[tta].a_ponto3, trdap_teste_a[tta].b_ponto1, trdap_teste_a[tta].b_ponto2, trdap_teste_a[tta].b_ponto3, trdap_teste_a[tta].c_ponto1, trdap_teste_a[tta].c_ponto2, trdap_teste_a[tta].c_ponto3, trdap_teste_a[tta].total, trdap_teste_a[tta].status] ,
														function(tx, resultSet) {
											}, function(tx, error) {
											});
										}

										qtdTrdapTesteB = participantes[i].trdap_teste_b.length;
										trdap_teste_b = participantes[i].trdap_teste_b;
										for (var ttb = 0; ttb < qtdTrdapTesteB; ttb++) {
											tx.executeSql('INSERT INTO trdap_teste_b (id, id_participante, codigo, data, obs1, obs2, obs3, ponto1, ponto2, ponto3, total, obs4, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
														[trdap_teste_b[ttb].id, trdap_teste_b[ttb].id_participante, trdap_teste_b[ttb].codigo, trdap_teste_b[ttb].data, trdap_teste_b[ttb].obs1, trdap_teste_b[ttb].obs2, trdap_teste_b[ttb].obs3, trdap_teste_b[ttb].ponto1, trdap_teste_b[ttb].ponto2, trdap_teste_b[ttb].ponto3, trdap_teste_b[ttb].total, trdap_teste_b[ttb].obs4, trdap_teste_b[ttb].status] ,
														function(tx, resultSet) {
											}, function(tx, error) {
											});
										}

										qtdTrdapTesteC = participantes[i].trdap_teste_c.length;
										trdap_teste_c = participantes[i].trdap_teste_c;
										for (var ttc = 0; ttc < qtdTrdapTesteC; ttc++) {
										  tx.executeSql('INSERT INTO trdap_teste_c (id, id_participante, codigo, data, ordem1, ordem2, ordem3, ponto1, ponto2, ponto3, total, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
												[trdap_teste_c[ttc].id, trdap_teste_c[ttc].id_participante, trdap_teste_c[ttc].codigo, trdap_teste_c[ttc].data, trdap_teste_c[ttc].ordem1, trdap_teste_c[ttc].ordem2, trdap_teste_c[ttc].ordem3, trdap_teste_c[ttc].ponto1, trdap_teste_c[ttc].ponto2, trdap_teste_c[ttc].ponto3, trdap_teste_c[ttc].total, trdap_teste_c[ttc].status] ,
												function(tx, resultSet) {
										  }, function(tx, error) {
										  });
										}
									}
								}, function(error) {
								}, function() {
									
								});

	},
	//cadastro
	this.setData = function(user){
		return $http({
			method: "POST",
			url: "http://www.roquejunior.com/clientes/mauricea/trdap/apiCadastro.php",
			data: user,
			headers : {
				'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF-8'
			}
		});
	};
	this.delData = function(id) {
		return $http ({
			method: "POST",
			url: "http://www.roquejunior.com/clientes/mauricea/trdap/apiDeleta.php",
			data: id,
			headers : {
				'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF-8'
			}
		});
	};

	this.formatData = function(date)
	{
		return date;
	}

	this.add_trdap_teste_a = function(instance, data)
	{
		var db = this.getDatabase();
		var query = 'INSERT INTO trdap_teste_a (a_ordem1, a_ordem2, a_ordem3, a_ponto1, a_ponto2, a_ponto3, b_ordem1, b_ordem2, b_ordem3, b_ponto1, b_ponto2, b_ponto3, c_ordem1, c_ordem2, c_ordem3, c_ponto1, c_ponto2, c_ponto3, codigo, data, id_participante, obs, status, total, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [data.a_ordem1, data.a_ordem2, data.a_ordem3, data.a_ponto1, data.a_ponto2, data.a_ponto3, data.b_ordem1, data.b_ordem2, data.b_ordem3, data.b_ponto1, data.b_ponto2, data.b_ponto3, data.c_ordem1, data.c_ordem2, data.c_ordem3, data.c_ponto1, data.c_ponto2, data.c_ponto3, data.codigo, data.data, data.id_participante, data.obs, data.status, data.total, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}

	this.update_trdap_teste_a = function(instance, data)
	{
		var db = this.getDatabase();
		var query = "UPDATE trdap_teste_a SET a_ordem1 = ?, a_ordem2 = ?, a_ordem3 = ?, a_ponto1 = ?, a_ponto2 = ?, a_ponto3 = ?, b_ordem1 = ?, b_ordem2 = ?, b_ordem3 = ?, b_ponto1 = ?, b_ponto2 = ?, b_ponto3 = ?, c_ordem1 = ?, c_ordem2 = ?, c_ordem3 = ?, c_ponto1 = ?, c_ponto2 = ?, c_ponto3 = ?, codigo = ?, data = ?, id_participante = ?, obs = ?, status = ?, total = ?, atualizacao = ? WHERE codigo = '"+data.codigo+"'";
		instance.execute(db, query, [data.a_ordem1, data.a_ordem2, data.a_ordem3, data.a_ponto1, data.a_ponto2, data.a_ponto3, data.b_ordem1, data.b_ordem2, data.b_ordem3, data.b_ponto1, data.b_ponto2, data.b_ponto3, data.c_ordem1, data.c_ordem2, data.c_ordem3, data.c_ponto1, data.c_ponto2, data.c_ponto3, data.codigo, data.data, data.id_participante, data.obs, data.status, data.total, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}

	this.add_trdap_teste_b = function(instance, data)
	{
		var db = this.getDatabase();
		query = 'INSERT INTO trdap_teste_b (codigo, data, id_participante, obs1, obs2, obs3, obs4, ponto1, ponto2, ponto3, status, total, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [data.codigo, data.data, data.id_participante, data.obs1, data.obs2, data.obs3, data.obs4, data.ponto1, data.ponto2, data.ponto3, data.status, data.total, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}

	this.update_trdap_teste_b = function(instance, data)
	{
		var db = this.getDatabase();
		query = "UPDATE trdap_teste_b SET codigo = ?, data = ?, id_participante = ?, obs1 = ?, obs2 = ?, obs3 = ?, obs4 = ?, ponto1 = ?, ponto2 = ?, ponto3 = ?, status = ?, total = ?, atualizacao = ? WHERE codigo '"+data.codigo+"'";
		instance.execute(db, query, [data.codigo, data.data, data.id_participante, data.obs1, data.obs2, data.obs3, data.obs4, data.ponto1, data.ponto2, data.ponto3, data.status, data.total, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}

	this.add_trdap_teste_c = function(instance, data)
	{
		var db = this.getDatabase();
		query = 'INSERT INTO trdap_teste_c (codigo, data, id_participante, ordem1, ordem2, ordem3, ponto1, ponto2, ponto3, status, total, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [data.codigo, data.data, data.id_participante, data.ordem1, data.ordem2, data.ordem3, data.ponto1, data.ponto2, data.ponto3, data.status, data.total, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}
	
	this.update_trdap_teste_c = function(instance, data)
	{
		var db = this.getDatabase();
		query = "UPDATE trdap_teste_c SET codigo = ?, data = ?, id_participante = ?, ordem1 = ?, ordem2 = ?, ordem3 = ?, ponto1 = ?, ponto2 = ?, ponto3 = ?, status = ?, total = ?, atualizacao = ? WHERE codigo = '"+data.codigo+"'";
		instance.execute(db, query, [data.codigo, data.data, data.id_participante, data.ordem1, data.ordem2, data.ordem3, data.ponto1, data.ponto2, data.ponto3, data.status, data.total, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}

	this.add_mini_exame = function(instance, data_mini_exame)
	{
		var db = this.getDatabase();
		query = 'INSERT INTO mini_exame (id_participante, codigo, data, orientacao_temporal, orientacao_espacial, memoria_imediata, atencao_calculo, memoria_evocacao, linguagem, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [data_mini_exame.id_participante, data_mini_exame.codigo, data_mini_exame.data, data_mini_exame.orientacao_temporal, data_mini_exame.orientacao_espacial, data_mini_exame.memoria_imediata, data_mini_exame.atencao_calculo, data_mini_exame.memoria_evocacao, data_mini_exame.linguagem, data_mini_exame.total, data_mini_exame.status, data_mini_exame.atualizacao])
		.then(function(result) {
		}, function(error) {
 		});
	}
	
	this.update_mini_exame = function(instance, data_mini_exame)
	{
		var db = this.getDatabase();
		query = "UPDATE mini_exame SET id_participante = ?, data = ?, orientacao_temporal = ?, orientacao_espacial = ?, memoria_imediata = ?, atencao_calculo = ?, memoria_evocacao = ?, linguagem = ?, total = ?, status = ?, atualizacao = ? WHERE codigo = '"+data.codigo+"'";
		instance.execute(db, query, [data_mini_exame.id_participante, data_mini_exame.data, data_mini_exame.orientacao_temporal, data_mini_exame.orientacao_espacial, data_mini_exame.memoria_imediata, data_mini_exame.atencao_calculo, data_mini_exame.memoria_evocacao, data_mini_exame.linguagem, data_mini_exame.total, data_mini_exame.status, data_mini_exame.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}

	this.add_proverbio = function(instance, data)
	{
		var db = this.getDatabase();
		query = 'INSERT INTO reconhecimento_proverbios (id_participante, codigo, reconhecimento1, reconhecimento2, reconhecimento3, reconhecimento4, reconhecimento5, reconhecimento6, data, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [data.id_participante, data.codigo, data.reconhecimento1, data.reconhecimento2, data.reconhecimento3, data.reconhecimento4, data.reconhecimento5, data.reconhecimento6, data.data, data.total, data.status, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}
	
	this.update_proverbio = function(instance, data)
	{
		console.log([data.id_participante, data.reconhecimento1, data.reconhecimento2, data.reconhecimento3, data.reconhecimento4, data.reconhecimento5, data.reconhecimento6, data.data, data.status, data.atualizacao]);
		var db = this.getDatabase();
		query = "UPDATE reconhecimento_proverbios SET id_participante = ?, reconhecimento1 = ?, reconhecimento2 = ?, reconhecimento3 = ?, reconhecimento4 = ?, reconhecimento5 = ?, reconhecimento6 = ?, total = ?, status = ?, atualizacao = ? WHERE codigo = '"+data.codigo+"'";
		a = "UPDATE reconhecimento_proverbios SET id_participante = '"+data.id_participante+"', reconhecimento1 = '"+data.reconhecimento1+"', reconhecimento2 = '"+data.reconhecimento2+"', reconhecimento3 = '"+data.reconhecimento3+"', reconhecimento4 = '"+data.reconhecimento4+"', reconhecimento5 = '"+data.reconhecimento5+"', reconhecimento6 = '"+data.reconhecimento6+"', total = '"+data.total+"', status = '"+data.status+"', atualizacao = '"+data.atualizacao+"' WHERE codigo = '"+data.codigo+"'";
		console.log(a);
		instance.execute(db, query, [data.id_participante, data.reconhecimento1, data.reconhecimento2, data.reconhecimento3, data.reconhecimento4, data.reconhecimento5, data.reconhecimento6, data.data, data.status, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}

	this.add_resultado_trdap = function(instance, data)
	{
		var db = this.getDatabase();
		query = 'INSERT INTO resultado_trdap (id_participante, codigo, data_inicio, data_fim, status, total, edita, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [data.id_participante, data.codigo, data.data_inicio, data.data_fim, data.status, data.total, data.edita, data.atualizacao])
		.then(function(result) {
		}, function(error) {
		});
	}
	
	this.update_resultado_trdap = function(instance, data)
	{
		var db = this.getDatabase();
		query = "UPDATE resultado_trdap SET data_fim = ? WHERE codigo = '"+data.codigo+"'";
		instance.execute(db, query, [data.data_fim])
		.then(function(result) {
		}, function(error) {
		});
	}

	this.sync_data = function(params)
	{
		var headers = {
				'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
				'Accept': 'application/json'
			};
		return $http({
			method: "POST",
			url: "http://www.roquejunior.com/clientes/mauricea/trdap/sync.php",
			data: params,
			headers : headers
		});
	}

	this.cancelar = function(codigo, id_participante, instance, data_inicio)
	{
		var date = new Date();
		var query = "DELETE FROM trdap_teste_a WHERE codigo = '"+codigo+"'";
		instance.execute(db, query);

		var query = "DELETE FROM trdap_teste_b WHERE codigo = '"+codigo+"'";
		instance.execute(db, query);

		var query = "DELETE FROM trdap_teste_c WHERE codigo = '"+codigo+"'";
		instance.execute(db, query);

		var query = "DELETE FROM mini_exame WHERE codigo = '"+codigo+"'";
		instance.execute(db, query);

		var query = "DELETE FROM reconhecimento_proverbios WHERE codigo = '"+codigo+"'";
		instance.execute(db, query);

		var query = "DELETE FROM resultado_trdap WHERE codigo = '"+codigo+"'";
		instance.execute(db, query);

		data = [];
		data.a_ordem1 = 0;
		data.a_ordem2 = 0;
		data.a_ordem3 = 0;
		data.a_ponto1 = 0;
		data.a_ponto2 = 0;
		data.a_ponto3 = 0;
		data.b_ordem1 = 0;
		data.b_ordem2 = 0;
		data.b_ordem3 = 0;
		data.b_ponto1 = 0;
		data.b_ponto2 = 0;
		data.b_ponto3 = 0;
		data.c_ordem1 = 0;
		data.c_ordem2 = 0;
		data.c_ordem3 = 0;
		data.c_ponto1 = 0;
		data.c_ponto2 = 0;
		data.c_ponto3 = 0;
		data.codigo = codigo;
		data.data = data_inicio;
		data.id_participante = id_participante;
		data.obs = 0;
		data.status = 0;
		data.total = 0;
		this.add_trdap_teste_a(instance, data);

		query = 'INSERT INTO trdap_teste_a (id_participante, obs, data, codigo, a_ordem1, a_ordem2, a_ordem3, b_ordem1, b_ordem2, b_ordem3, c_ordem1, c_ordem2, c_ordem3, a_ponto1, a_ponto2, a_ponto3, b_ponto1, b_ponto2, b_ponto3, c_ponto1, c_ponto2, c_ponto3, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [id_participante, '', data_inicio, codigo, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, data_inicio])
		.then(function(result) {
		}, function(error) {
		});
		query = 'INSERT INTO trdap_teste_b (codigo, data, id_participante, obs1, obs2, obs3, obs4, ponto1, ponto2, ponto3, status, total, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [codigo, data_inicio, id_participante, '', '', '', '', 0, 0, 0, 0, 0, data_inicio])
		.then(function(result) {
		}, function(error) {
		});
		query = 'INSERT INTO trdap_teste_c (codigo, data, id_participante, ordem1, ordem2, ordem3, ponto1, ponto2, ponto3, status, total, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [codigo, data_inicio, id_participante, 0, 0, 0, 0, 0, 0, 0, 0, data_inicio])
		.then(function(result) {;
		}, function(error) {
		});
		query = 'INSERT INTO mini_exame (id_participante, codigo, data, orientacao_temporal, orientacao_espacial, memoria_imediata, atencao_calculo, memoria_evocacao, linguagem, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [id_participante, codigo, data_inicio, 0, 0, 0, 0, 0, 0, 0, 0, data_inicio])
		.then(function(result) {;
		}, function(error) {
		});
		query = 'INSERT INTO reconhecimento_proverbios (id_participante, codigo, reconhecimento1, reconhecimento2, reconhecimento3, reconhecimento4, reconhecimento5, reconhecimento6, data, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [id_participante, codigo, 0, 0, 0, 0, 0, 0, data_inicio, 0, 0, data_inicio])
		.then(function(result) {;
		}, function(error) {
		});
		query = 'INSERT INTO resultado_trdap (id_participante, data_inicio, data_fim, codigo, status, total, edita, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		instance.execute(db, query, [id_participante, data_inicio, data_inicio, codigo, 0, 0, 0, data_inicio])
		.then(function(result) {;
		}, function(error) {
		});
	}
});