var tRDAPCtrl = angular.module('tRDAPCtrl', ['ngCordova', 'ngMask']);
   
tRDAPCtrl.controller('tRDAPCtrl', ['$scope', '$stateParams', '$state', '$cordovaSQLite', 'Data', '$ionicLoading', '$timeout', '$ionicScrollDelegate', '$location', '$ionicNavBarDelegate',  // The following is the constructor function for this page's controller. See https://docs.angularjs.org/guide/controller
// You can include any angular dependencies as parameters for this function
// TIP: Access Route Parameters for your page via $stateParams.parameterName
function ($scope, $stateParams, $state, $cordovaSQLite, Data, $ionicLoading, $timeout, $ionicScrollDelegate, $location, $ionicNavBarDelegate) {
	$scope.$root.tabsHidden = "tabs-hide";
	$scope.$root.hideEdit = "false";
	$scope.hideButton = "ng-hide";
	$scope.hideResult = "ng-hide";
	$scope.hideCancel = "";
	var id = localStorage.getItem('id'),
		inicio = Date.now(),
		data_inicio = Data.getNow(),
		codigo = 'ap_'+_.random(0, 1000000);
	if(id == undefined){
		$state.go('login');
		return false;
	}

	$scope.ordem = [
		{ 'id' : 0 },
		{ 'id' : 1 },
		{ 'id' : 2 },
		{ 'id' : 3 },
	];

	$scope.pontos = [
		{ 'id' : 0 },
		{ 'id' : 1 },
		{ 'id' : 2 },
	];

	$scope.trdapbItens = [
		{ 'id' : 0 },
		{ 'id' : 1 },
	];

	db = Data.getDatabase();
	$scope.trdapa = [];
	$scope.trdapb = [];
	$scope.trdapc = [];
	$scope.trdapa.status = 1;
	$scope.id = $scope.trdapa_a = $scope.trdapa_b = $scope.trdapa_c = '0';
	$scope.total_part_1 = $scope.total_part_2 = $scope.total_part_3 = $scope.sumTotal = 0;

	$scope.participante = [];
	$scope.atributos_participantes = [];
	$scope.usuarios = [];

	var info = localStorage.getItem('info'),
		info = JSON.parse(info);
	info.total = parseInt(info.total) - 1;
	info.user[0].num_testes = info.total;
	localStorage.setItem('info', JSON.stringify(info));
	
	var query = "SELECT * FROM participantes WHERE id = "+$stateParams.id;
	db.transaction(function(transaction) {
		transaction.executeSql(query, [], function (tx, results) {
		var len = results.rows.length;
		$scope.participante.push(results.rows[0]);
		$scope.participante = $scope.participante[0];
	}, null);
	});

	var query_atributos_participantes = "SELECT escolaridade, demencia_diagnotic FROM atributos_participantes WHERE id_participante = "+$stateParams.id;

	db.transaction(function(transaction_atributos_participantes) {
		transaction_atributos_participantes.executeSql(query_atributos_participantes, [], function (tx_atributos_participantes, results_atributos_participantes) {
		var len = results_atributos_participantes.rows.length;
		for (i = 0; i < len; i++){
			$scope.atributos_participantes.push(results_atributos_participantes.rows.item(i));
			$scope.atributos_participantes = $scope.atributos_participantes[i];
		}
	}, null);
	});

	$scope.id = 0;
	var selecione = '-';

	$scope.trdapa.a_ponto1 = selecione;
	$scope.trdapa.a_ponto2 = selecione;
	$scope.trdapa.a_ponto3 = selecione;
	$scope.trdapa.b_ponto1 = selecione;
	$scope.trdapa.b_ponto2 = selecione;
	$scope.trdapa.b_ponto3 = selecione;
	$scope.trdapa.c_ponto1 = selecione;
	$scope.trdapa.c_ponto2 = selecione;
	$scope.trdapa.c_ponto3 = selecione;
	$scope.trdapa.a_ordem1 = selecione;
	$scope.trdapa.a_ordem2 = selecione;
	$scope.trdapa.a_ordem3 = selecione;
	$scope.trdapa.b_ordem1 = selecione;
	$scope.trdapa.b_ordem2 = selecione;
	$scope.trdapa.b_ordem3 = selecione;
	$scope.trdapa.c_ordem1 = selecione;
	$scope.trdapa.c_ordem2 = selecione;
	$scope.trdapa.c_ordem3 = selecione;
	$scope.trdapb.ponto1 = $scope.trdapb.ponto2 = $scope.trdapb.ponto3 = selecione;
	$scope.trdapc.ordem1 = $scope.trdapc.ordem2 = $scope.trdapc.ordem3 = selecione;
	$scope.trdapc.ponto1 = $scope.trdapc.ponto2 = $scope.trdapc.ponto3 = selecione;

	$scope.exibirMesagemBlocoA = 'ng-hide';
	$scope.exibirMesagemBlocoB = 'ng-hide';
	$scope.exibirMesagemBlocoC = 'ng-hide';

	if($stateParams.t == ''){
		$ionicNavBarDelegate.showBackButton(false);
		$scope.showSumTotal1 = '';
		$scope.showSumTotal2 = 'ng-hide';
		var query = "UPDATE usuario SET num_testes = num_testes - 1";
		$cordovaSQLite.execute(db, query)
		.then(function(result) {
		}, function(error) {
		});
		$scope.hideResult = $scope.hideButton = "ng-hide";
		$scope.sumTotal = $total_part_1_edit = total_part_2_edit = total_part_3_edit = 0;
	} else {
		$ionicNavBarDelegate.showBackButton(true);
		$scope.showSumTotal1 = 'ng-hide';
		$scope.showSumTotal2 = '';
		$scope.$root.tabsHidden = "";
		$scope.$root.hideEdit = "false";
		$scope.hideResult = "";
		$scope.hideCancel = "";
		$scope.id = codigo = $stateParams.t;
		var total_part_1 = total_part_2 = total_part_3 = 0,
			query_trdapA = "SELECT * FROM trdap_teste_a WHERE codigo = '"+$stateParams.t+"'";
		db.transaction(function(transaction_trdapA) {
		transaction_trdapA.executeSql(query_trdapA, [], function (tx_trdapA, results_trdapA) {
			var len = results_trdapA.rows.length;
			// $scope.trdapa = [];
			for (i = 0; i < len; i++){
				$scope.trdapa.push(results_trdapA.rows.item(i));
				$scope.trdapa = $scope.trdapa[i];
				total_part_1 += $scope.trdapa.a_ponto1 + $scope.trdapa.a_ponto2 + $scope.trdapa.a_ponto3;
				total_part_1 += $scope.trdapa.b_ponto1 + $scope.trdapa.b_ponto2 + $scope.trdapa.b_ponto3;
				total_part_1 += $scope.trdapa.c_ponto1 + $scope.trdapa.c_ponto2 + $scope.trdapa.c_ponto3;
				total_part_1 = total_part_1 / 3;
				$scope.total_part_1 = $scope.total_part_1_edit = parseFloat(total_part_1.toFixed(2));
				$scope.box_trdapa = $scope.total_part_1;
				$scope.trdapa.obs1 = $scope.trdapa.obs;
			}
		}, null);
		});
		var query_trdapb = "SELECT * FROM trdap_teste_b WHERE codigo = '"+$stateParams.t+"'";
		db.transaction(function(transaction_trdapb) {
		transaction_trdapb.executeSql(query_trdapb, [], function (tx_trdapb, results_trdapb) {
			var len = results_trdapb.rows.length;
			$scope.trdapb = [];
			for (i = 0; i < len; i++){
				$scope.trdapb.push(results_trdapb.rows.item(i));
				$scope.trdapb = $scope.trdapb[i];
				total_part_2 = $scope.trdapb.ponto1 + $scope.trdapb.ponto2 + $scope.trdapb.ponto3;
				$scope.total_part_2 = $scope.total_part_2_edit = parseFloat(total_part_2.toFixed(2));
				$scope.box_trdapb = $scope.total_part_2;
			}
		}, null);
		});
		var query_trdapc = "SELECT * FROM trdap_teste_c WHERE codigo = '"+$stateParams.t+"'";
		db.transaction(function(transaction_trdapc) {
		transaction_trdapc.executeSql(query_trdapc, [], function (tx_trdapc, results_trdapc) {
			var len = results_trdapc.rows.length;
			for (i = 0; i < len; i++){
				$scope.trdapc.push(results_trdapc.rows.item(i));
				$scope.trdapc = $scope.trdapc[i];
				total_part_3 = $scope.trdapc.ponto1 + $scope.trdapc.ponto2 + $scope.trdapc.ponto3;
				$scope.total_part_3 = $scope.total_part_3_edit = parseFloat(total_part_3.toFixed(2));
				$scope.box_trdapc = $scope.total_part_3;
			}
		}, null);
		});

		var sumTotal = parseFloat($scope.total_part_1) + parseFloat($scope.total_part_2) + parseFloat($scope.total_part_3);
		if($scope.atributos_participantes.escolaridade <= 7){
			if (sumTotal < 6.49) {
				$scope.resultado = "Com suspeita de déficit cognitivo!";
				$scope.color = "red";
			} else {
				$scope.resultado = "Sem suspeita de déficit cognitivo!";
				$scope.color = "green";
			}
		} else {
			if (sumTotal < 8.66) {
				$scope.resultado = "Com suspeita de déficit cognitivo!";
				$scope.color = "red";
			} else {
				$scope.resultado = "Sem suspeita de déficit cognitivo!";
				$scope.color = "green";
			}
		}
		$scope.sumTotal = sumTotal;

	}
	
	$scope.calcTRDAPa = function(data){
		var keys = Object.keys(data),
			total_part_1 = $scope.total_part_1 = 0,
			keysForSum = ['a_ponto1', 'a_ponto2', 'a_ponto3',
						  'b_ponto1', 'b_ponto2', 'b_ponto3',
						  'c_ponto1', 'c_ponto2', 'c_ponto3'],
			existsZero = false;
			$scope.box_trdapa = '';
			_.each(keys, function(value, key, list){
				var has = _.indexOf(keysForSum, value);
				if(has != -1){
					value = data[value];
					total_part_1 += parseInt(value);
					if(value == selecione){
						existsZero = true;
						return false;
					}
				}
			});
			if(!existsZero){
				total_part_1 = total_part_1 / 3;
				$scope.total_part_1 = total_part_1.toFixed(2);
				$scope.box_trdapa = total_part_1;
				if(!$stateParams.t == ''){
					$scope.sumTotal = parseFloat($scope.total_part_1) + parseFloat($scope.total_part_2) + parseFloat($scope.total_part_3);
				}
			} else {
				$scope.box_trdapa = '';
			}
	}

	$scope.calcTRDAPb = function(data){
		var keys = Object.keys(data),
			total_part_2 = 0,
			keysForSum = ['ponto1', 'ponto2', 'ponto3'],
			existsZero = false;
		$scope.box_trdapb = '';
		if(keys.length >= 6){
			var sum = 0
			_.each(keys, function(value, key, list){
				var has = _.indexOf(keysForSum, value);
				if(has != -1){
					value = data[value];
					if(value == selecione){
						existsZero = true;
						return false;
					}
					total_part_2 += parseInt(value)
				}
			});
			if(!existsZero){
				$scope.total_part_2 = total_part_2.toFixed(2);
				$scope.box_trdapb = total_part_2;
				if(!$stateParams.t == ''){
					$scope.sumTotal = parseFloat($scope.total_part_1) + parseFloat($scope.total_part_2) + parseFloat($scope.total_part_3);
				}
			} else {
				$scope.box_trdapb = '';
			}
		}
	}

	$scope.calcTRDAPc = function(data){
		var keys = Object.keys(data),
			total_part_3 = 0,
			keysForSum = ['ponto1', 'ponto2', 'ponto3'],
			existsZero = false;
		$scope.box_trdapc = '';
		if(keys.length >= 6){
			var sum = 0
			_.each(keys, function(value, key, list){
				var has = _.indexOf(keysForSum, value);
				value = data[value];
				if(has != -1){
					if(value == selecione){
						existsZero = true;
						return false;
					}
					total_part_3 += parseInt(value)
				}
			});
			if(!existsZero){
				$scope.total_part_3 = total_part_3.toFixed(2);
				$scope.box_trdapc = total_part_3;
				if(!$stateParams.t == ''){
					$scope.sumTotal = parseFloat($scope.total_part_1) + parseFloat($scope.total_part_2) + parseFloat($scope.total_part_3);
				}
			} else {
				$scope.box_trdapc = '';
			}
		}
	}

	$scope.addTRDAP = function(trdapa, trdapb, trdapc, id){
		var keys_trdapa = (trdapa != undefined ? Object.keys(trdapa) : {}),
			keys_trdapb = (trdapb != undefined ? Object.keys(trdapb) : {}),
			keys_trdapc = (trdapc != undefined ? Object.keys(trdapc) : {}),
			keysTrdapA = ['a_ponto1', 'a_ponto2', 'a_ponto3',
				  		  'b_ponto1', 'b_ponto2', 'b_ponto3',
				  		  'c_ponto1', 'c_ponto2', 'c_ponto3',
				  		  'a_ordem1', 'a_ordem2', 'a_ordem3',
				  		  'b_ordem1', 'b_ordem2', 'b_ordem3',
				  		  'c_ordem1', 'c_ordem2', 'c_ordem3'],
			keysTrdapB = ['obs1', 'obs4', 'obs3', 'ponto1', 'ponto2', 'ponto3'],
			keysTrdapC = ['ponto1', 'ponto2', 'ponto3',
						  'ordem1', 'ordem2', 'ordem3'],
			enviaDados = true;
		_.each(keys_trdapa, function(value, key, list){
			var has = _.indexOf(keysTrdapA, value);
			value = trdapa[value];
			if(has != -1){
				if(value == selecione){
					enviaDados = false;
					$scope.exibirMesagemBlocoA = '';
					return false;
				}
			}
		});
		_.each(keys_trdapb, function(value, key, list){
			var has = _.indexOf(keysTrdapB, value);
			value = trdapb[value];
			if(has != -1){
				if(value == selecione){
					enviaDados = false;
					$scope.exibirMesagemBlocoB = '';
					return false;
				}
			}
		});
		_.each(keys_trdapc, function(value, key, list){
			var has = _.indexOf(keysTrdapC, value);
			value = trdapc[value];
			if(has != -1){
				if(value == selecione){
					enviaDados = false;
					$scope.exibirMesagemBlocoC = '';
					return false;
				}
			}
		});

		if(enviaDados){
			$scope.exibirMesagemBlocoA = 'ng-hide';
			$scope.exibirMesagemBlocoB = 'ng-hide';
			$scope.exibirMesagemBlocoC = 'ng-hide';
			$scope.showSumTotal1 = '';
			$scope.showSumTotal2 = 'ng-hide';
			$scope.hideResult = "";
			if($scope.atributos_participantes.escolaridade == ''){
				$scope.resultado = "Não é possivel avaliar o resultado, pois não foi definido a escolaridade para este participante!";
				$scope.color = "red";
			} else {
				var sumTotal = parseFloat($scope.total_part_1) + parseFloat($scope.total_part_2) + parseFloat($scope.total_part_3);
				if($scope.atributos_participantes.escolaridade <= 7){
					if (sumTotal < 6.49) {
						$scope.resultado = "Com suspeita de déficit cognitivo!";
						$scope.color = "red";
					} else {
						$scope.resultado = "Sem suspeita de déficit cognitivo!";
						$scope.color = "green";
					}
				} else {
					if (sumTotal < 8.66) {
						$scope.resultado = "Com suspeita de déficit cognitivo!";
						$scope.color = "red";
					} else {
						$scope.resultado = "Sem suspeita de déficit cognitivo!";
						$scope.color = "green";
					}
				}
			}
			var fim = Date.now() - inicio,
				data_fim = Data.getNow();
			$scope.codigo = codigo;
			if($stateParams.t == ''){
				localStorage.setItem('codigo', codigo);
				localStorage.setItem('inicio', data_inicio);
				localStorage.setItem('total_a', $scope.total_part_1);
				localStorage.setItem('total_b', $scope.total_part_2);
				localStorage.setItem('total_c', $scope.total_part_3);
				$scope.hideButton = "";
				if($stateParams.t != ''){
					$scope.hideButton = "ng-hide";
				}
			}
			$scope.sumTotal = sumTotal;
			trdapa.data = trdapb.data = trdapc.data = data_inicio;
			trdapa.codigo = trdapb.codigo = trdapc.codigo = codigo;
			trdapa.total = $scope.total_part_1;
			trdapa.id_participante = $stateParams.id;
			trdapa.obs = trdapa.obs1 || '';
			if($stateParams.t == ''){
				trdapa.status = 1;
			} else {
				trdapa.status = 0;
			}
			trdapb.total = $scope.total_part_2;
			if($stateParams.t == ''){
				trdapb.status = 1;
			} else {
				trdapb.status = 0;
			}
			trdapb.id_participante = $stateParams.id;
			trdapb.obs4 = trdapb.obs4 || '';
			trdapc.total = $scope.total_part_3;
			if($stateParams.t == ''){
				trdapc.status = 1;
			} else {
				trdapc.status = 0;
			}
			trdapc.id_participante = $stateParams.id;

			// delete trdapa.obsa;
			if($scope.id == 0){
				trdapa.atualizacao = getToday();
				trdapb.atualizacao = getToday();
				trdapc.atualizacao = getToday();
				Data.add_trdap_teste_a($cordovaSQLite, trdapa);
				Data.add_trdap_teste_b($cordovaSQLite, trdapb);
				Data.add_trdap_teste_c($cordovaSQLite, trdapc);
				$scope.id = codigo;
			} else {
				trdapa.atualizacao = getToday();
				trdapb.atualizacao = getToday();
				trdapc.atualizacao = getToday();
				Data.update_trdap_teste_a($cordovaSQLite, trdapa);
				Data.update_trdap_teste_b($cordovaSQLite, trdapb);
				Data.update_trdap_teste_c($cordovaSQLite, trdapc);
			}
			if($stateParams.t != ''){

			}
		} else {
			console.log('asd');
		}
	}

	$scope.miniExame = function()
	{
		if($stateParams.t == ''){
			$state.go('tabsController.miniExame', {'id' : $stateParams.id});
        	// this.tRDAP.reset();
			$scope.trdapa.a_ponto1 = selecione;
			$scope.trdapa.a_ponto2 = selecione;
			$scope.trdapa.a_ponto3 = selecione;
			$scope.trdapa.b_ponto1 = selecione;
			$scope.trdapa.b_ponto2 = selecione;
			$scope.trdapa.b_ponto3 = selecione;
			$scope.trdapa.c_ponto1 = selecione;
			$scope.trdapa.c_ponto2 = selecione;
			$scope.trdapa.c_ponto3 = selecione;
			$scope.trdapa.a_ordem1 = selecione;
			$scope.trdapa.a_ordem2 = selecione;
			$scope.trdapa.a_ordem3 = selecione;
			$scope.trdapa.b_ordem1 = selecione;
			$scope.trdapa.b_ordem2 = selecione;
			$scope.trdapa.b_ordem3 = selecione;
			$scope.trdapa.c_ordem1 = selecione;
			$scope.trdapa.c_ordem2 = selecione;
			$scope.trdapa.c_ordem3 = selecione;
			$scope.trdapb.ponto1 = $scope.trdapb.ponto2 = $scope.trdapb.ponto3 = selecione;
			$scope.trdapc.ordem1 = $scope.trdapc.ordem2 = $scope.trdapc.ordem3 = selecione;
			$scope.trdapc.ponto1 = $scope.trdapc.ponto2 = $scope.trdapc.ponto3 = selecione;
			$scope.trdapa.obs3 = $scope.trdapb.obs1 = $scope.trdapb.obs1 = $scope.trdapb.obs2 = $scope.trdapb.obs3 = $scope.trdapb.obs4 = '';
			$scope.showSumTotal1 = '';
			$scope.showSumTotal2 = 'ng-hide';
			$scope.hideResult = $scope.hideButton = "ng-hide";
			$scope.sumTotal = $total_part_1_edit = total_part_2_edit = total_part_3_edit = 0;

		// } else {
		// 	$state.go('tabsController.miniExame', {'id' : $stateParams.id, 't' : $stateParams.t });
		}
	}

	$scope.cancelar = function()
	{
		if($stateParams.t != ''){
			$state.go('tabsController.atendimentos', {'id' : $stateParams.id});
		} else {
			if(confirm("Se cancelar o teste será movido para Atendimentos cancelados ! \n Deseja cancelar o teste ?")){
				Data.cancelar(codigo, $stateParams.id, $cordovaSQLite, data_inicio);
				total = localStorage.getItem('total');
				total = parseInt(total) - 1;
				localStorage.setItem('total', total);
				cancelados = localStorage.getItem('cancelados');
				cancelados = parseInt(cancelados) + 1;
				localStorage.setItem('cancelados', cancelados);
				localStorage.removeItem('codigo');
				localStorage.removeItem('inicio');
				localStorage.removeItem('total_a');
				localStorage.removeItem('total_b');
				localStorage.removeItem('total_c');

				$timeout(function() {
					$state.go('tabsController.participantes', { 'p': $stateParams.id, 'test': false });
				}, 1000);
			}
		}
	}

	$scope.sub = function(element, item, min) {
	  if(element[item] == selecione){
	  	element[item] = 0;
	  } else {
	  	element[item]--;
	  }
	  if(element[item] < min){
	  	element[item] = selecione;
	  }
	}

	$scope.add = function(element, item, max) {
	  if(element[item] == selecione){
	  	element[item] = 0;
	  } else {
	  	element[item]++;
	  }
	  if(element[item] > max){
	  	element[item] = max;
	  }
	}

	$scope.scrollMe = function(anchor) {  
    	$location.hash(anchor);
        $ionicScrollDelegate.anchorScroll();
    };	
}]);