var adicionarParticipanteCtrl = angular.module('adicionarParticipanteCtrl', ['ngCordova', 'ngMask', 'ngPatternRestrict', 'ui.utils.masks']);

adicionarParticipanteCtrl.controller('adicionarParticipanteCtrl', ['$scope', '$stateParams', '$state', '$cordovaSQLite', 'Data', '$ionicLoading', '$timeout', '$ionicPopup', '$location', '$ionicScrollDelegate', 'ionicDatePicker', // The following is the constructor function for this page's controller. See https://docs.angularjs.org/guide/controller
// You can include any angular dependencies as parameters for this function
// TIP: Access Route Parameters for your page via $stateParams.parameterName
function ($scope, $stateParams, $state, $cordovaSQLite, Data, $ionicLoading, $timeout, $ionicPopup, $location, $ionicScrollDelegate, ionicDatePicker) {
	var id = localStorage.getItem('id');
	if(id == undefined){
		$state.go('login');
		return false;
	}

	$scope.titulo = 'Cadastro de Participante';

	$scope.$root.tabsHidden = "";
	$scope.$root.hideEdit = "false";
	$scope.hideButtonTeste = "ng-hide";
	$scope.hideButtonSalvar = "";

	$scope.mora_list = [
		{ 'id' : 'Sozinho' },
		{ 'id' : 'Filhos' },
		{ 'id' : 'Instituição' },
		{ 'id' : 'Companheiro' },
		{ 'id' : 'Outros' },
	];

	$scope.sim_nao = [
		{ 'id' : '0', 'value' : 'Não' },
		{ 'id' : '1', 'value' : 'Sim' },
	];

	$scope.escolaridade_lista = [
		{ 'id' : '0', 'value' : '(0) Anos' },
		{ 'id' : '1', 'value' : '(1) Anos' },
		{ 'id' : '2', 'value' : '(2) Anos' },
		{ 'id' : '3', 'value' : '(3) Anos' },
		{ 'id' : '4', 'value' : '(4) Anos' },
		{ 'id' : '5', 'value' : '(5) Anos' },
		{ 'id' : '6', 'value' : '(6) Anos' },
		{ 'id' : '7', 'value' : '(7) Anos' },
		{ 'id' : '8', 'value' : '(8) Anos' },
		{ 'id' : '9', 'value' : '(9) Anos' },
		{ 'id' : '10', 'value' : '(10) Anos' },
		{ 'id' : '11', 'value' : '(11) Anos' },
		{ 'id' : '12', 'value' : '(12) Anos' },
		{ 'id' : '+12', 'value' : '(+12) Anos' },
	];

	$scope.estado = [
		{ 'id' : 'AC', 'value' : 'Acre'},
		{ 'id' : 'AL', 'value' : 'Alagoas'},
		{ 'id' : 'AP', 'value' : 'Amapá'},
		{ 'id' : 'AM', 'value' : 'Amazonas'},
		{ 'id' : 'BA', 'value' : 'Bahia'},
		{ 'id' : 'CE', 'value' : 'Ceará'},
		{ 'id' : 'DF', 'value' : 'Distrito'},
		{ 'id' : 'ES', 'value' : 'Espírito'},
		{ 'id' : 'GO', 'value' : 'Goiás'},
		{ 'id' : 'MA', 'value' : 'Maranhão'},
		{ 'id' : 'MT', 'value' : 'Mato'},
		{ 'id' : 'MS', 'value' : 'Mato'},
		{ 'id' : 'MG', 'value' : 'Minas'},
		{ 'id' : 'PA', 'value' : 'Pará'},
		{ 'id' : 'PB', 'value' : 'Paraíba'},
		{ 'id' : 'PR', 'value' : 'Paraná'},
		{ 'id' : 'PE', 'value' : 'Pernambuco'},
		{ 'id' : 'PI', 'value' : 'Piauí'},
		{ 'id' : 'RJ', 'value' : 'Rio'},
		{ 'id' : 'RN', 'value' : 'Rio'},
		{ 'id' : 'RS', 'value' : 'Rio'},
		{ 'id' : 'RD', 'value' : 'Rondônia'},
		{ 'id' : 'RR', 'value' : 'Roraima'},
		{ 'id' : 'SC', 'value' : 'Santa'},
		{ 'id' : 'AP', 'value' : 'São'},
		{ 'id' : 'SE', 'value' : 'Sergipe'},
		{ 'id' : 'TO', 'value' : 'Tocantins'},
	];

	$scope.renda_mensal = [
		{ 'id' : '1', 'value' : 'Menor que 1 salário mínimo' },
		{ 'id' : '2', 'value' : '1 salário mínimo' },
		{ 'id' : '3', 'value' : '1 e 2 salários' },
		{ 'id' : '4', 'value' : 'Mais de 3 salários mínimos' },
	];

	$scope.estado_civil = [
		{ 'id' : 'Solteiro', 'value' : 'Solteiro' },
		{ 'id' : 'Casado', 'value' : 'Casado' },
		{ 'id' : 'Viúvo', 'value' : 'Viúvo' },
		{ 'id' : 'Divorciado / Separa', 'value' : 'Divorciado / Separa' },
	];

	$scope.dominancia = [
		{ 'id' : 'Destro', 'value' : 'Destro' },
		{ 'id' : 'Sinistro', 'value' : 'Sinistro' },
	];

	$scope.saude = [
		{ 'id' : '1', 'value' : 'Boa' },
		{ 'id' : '2', 'value' : 'Regular' },
		{ 'id' : '3', 'value' : 'Ruim' },
	];

	$scope.participante = [];
	$scope.participante.mora = '';
	$scope.participante.escolaridade = '';
	$scope.participante.estado_civil = '';
	$scope.participante.estado = '';
	$scope.participante.renda_mensal = '';
	$scope.participante.dominancia = '';
	$scope.participante.demencia_diagnotic = '';
	$scope.participante.habito_leitura = '';
	$scope.participante.habito_escrita = '';
	$scope.participante.atividade_social = '';
	$scope.participante.saude = '';
	$scope.participante.problema_memoria = '';
	$scope.participante.int_cotidiano = '';

	$scope.openDatePickerOne = function (val) {
      var ipObj1 = {
        callback: function (val) {  //Mandatory
        	var dateSelected = new Date(val),
        		dateSelected = dateSelected.toLocaleDateString('pt-BR');
			$scope.participante.data_nascimento = dateSelected;
        },
        inputDate: new Date(),
        mondayFirst: true,
        disableWeekdays: [],
        closeOnSelect: false,
        templateType: 'popup'
      };
      ionicDatePicker.openDatePicker(ipObj1);
    };

	function toDate(dateStr) {
	    const [day, month, year] = dateStr.split("/")
	    return new Date(day, month - 1, year)
	}

	$scope.addParticipant = function(data, acao)
	{
		$ionicLoading.show({
			template: '<ion-spinner icon="bubbles"></ion-spinner><br />Salvando Participante',
		});
		var user = localStorage.getItem('id'),
		user_id = JSON.parse(user);
		var id = Math.floor(Date.now() / 1000),
			date = new Date(),
			date = date.getFullYear()+'-'+date.getMonth()+'-'+date.getDate(),
			novo_participante = {},
			db = Data.getDatabase();
		acompanhante = {
						'nome': data['nomeAcompanhante'] || '',
						'telefone': data['telAcompanhante' || '']
						};
		atributos_participantes = {
			'atividade_fisica': data['atividade_fisica'] || '',
			'atividade_social': data['atividade_social'] || '',
			'conveniencia': data['conveniencia'] ? 1 : 0,
			'cursos': data['cursos'] ? 1 : 0,
			'demencia_diagnotic': data['demencia_diagnotic'] || '',
			'dominancia': data['dominancia'] || '',
			'escolaridade': data['escolaridade'] || '',
			'habito_escrita': data['habito_escrita'] || '',
			'habito_leitura': data['habito_leitura'] || '',
			'habito_escrita': data['habito_escrita'] || '',
			'int_cotidiano': data['int_cotidiano'] || '',
			'mora': data['mora'] || '',
			'participacoes': data['participacoes'] || '',
			'problema_memoria': data['problema_memoria'] || '',
			'religiao': data['religiao'] || '',
			'renda_mensal': data['renda_mensal'] || '',
			'saude': data['saude'] || '',
			'terapias': data['terapias'] ? 1 : 0
		}
		novo_participante['data_cadastro'] = date;
		var data_nascimento = data['data_nascimento'] || '';
		if(data_nascimento != ''){
			data_nascimento = moment(data_nascimento).format('YYYY-MM-DD');
		}
		novo_participante['id'] = id;
		novo_participante['data_nascimento'] = data_nascimento;
		novo_participante['email'] = data['email'] || '';
		novo_participante['estado_civil'] = data['estado_civil'] || '';
		novo_participante['fone_celular'] = data['celular'] || '';
		novo_participante['fone_fixo'] = data['telefone'] || '';
		novo_participante['id'] = id;
		novo_participante['id_pesquisador'] = 0;
		novo_participante['idade'] = data['idade'] || '';
		novo_participante['local_atend'] = data['local_atend'] || '';
		novo_participante['nome'] = data['nome'] || '';
		novo_participante['profissao'] = data['profissao'] || '';
		novo_participante['status'] = 0;
		$scope.participante = [];
		
		db = Data.getDatabase();
		db.transaction(function(tx)
		{
			var msg,
				continuar = true,
				last_insert_id = 0,
				last_insert_id_endereco = 0,
				last_insert_id_acompanhante = 0,
				last_insert_id_atributo = 0;
			queryParticipante = 'INSERT INTO participantes ( id, id_usuario, id_pesquisador, nome, data_nascimento, idade, estado_civil, profissao, fone_fixo, fone_celular, email, local_atend, status, data_cadastro, atualizacao)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ';
			dataInsertParticipante = [id, user_id, 0, novo_participante['nome'], novo_participante['data_nascimento'], novo_participante['idade'], novo_participante['estado_civil'], novo_participante['profissao'], novo_participante['fone_fixo'], novo_participante['fone_celular'], novo_participante['email'], novo_participante['local_atend'], 1, date, getToday()];
			$cordovaSQLite.execute(db, queryParticipante, dataInsertParticipante)
			.then(function(result) {
				last_insert_id = result.insertId;
				localStorage.setItem('participante'+last_insert_id, JSON.stringify(novo_participante));
				msg = 'Cadastro efetuado com sucesso.';
			}, function(error) {
				msg = 'Falha ao cadastrar participante.';
				continuar = false;
			});
			$timeout(function(){

				query_endereco = 'INSERT INTO endereco (id_participante, cep, rua, numero, complemento, bairro, cidade, estado, pais, atualizacao) VALUES (?,?,?,?,?,?,?,?,?,?)';
				data_Insert_endereco = [last_insert_id, (data['cep'] || ''), (data['rua'] || ''), (data['numero'] || ''), (data['complemento'] || ''), (data['bairro'] || ''), (data['cidade'] || ''), (data['estado'] || ''), (data['pais'] || ''), getToday()];
				$cordovaSQLite.execute(db, query_endereco, data_Insert_endereco).then(function(result_endereco) {
					last_insert_id_endereco = result_endereco.insertId;
					var data_endereco = {'cep': data['cep'], 'rua': data['rua'], 'numero': data['numero'], 'complemento': data['complemento'], 'bairro': data['bairro'], 'cidade': data['cidade'], 'estado': data['estado'], 'pais': data['pais']};
					localStorage.setItem('endereco'+last_insert_id, JSON.stringify(data_endereco));
				}, function(error) {
				});
				
				query_acompanhante = 'INSERT INTO acompanhante (nome , telefone , id_participante, atualizacao) VALUES(? ,? ,?, ?)';
				data_Insert_acompanhante = [(acompanhante.nome || ''), (acompanhante.telefone || ''), last_insert_id, getToday()];
				$cordovaSQLite.execute(db, query_acompanhante, data_Insert_acompanhante).then(function(result_acompanhante) {
					last_insert_id_acompanhante = result_acompanhante.insertId;
					localStorage.setItem('acompanhante'+last_insert_id, JSON.stringify(acompanhante));
				}, function(error) {
				});

				query_atributo = 'INSERT INTO atributos_participantes ( id_participante, cursos, conveniencia, terapias, habito_leitura, habito_escrita, participacoes, atividade_social, atividade_fisica, saude, problema_memoria, int_cotidiano, mora, escolaridade, renda_mensal, demencia_diagnotic, dominancia, religiao, atualizacao) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
				data_Insert_atributo = [last_insert_id,(atributos_participantes.cursos || ''),(atributos_participantes.conveniencia || ''),(atributos_participantes.terapias || ''),(atributos_participantes.habito_leitura || ''),(atributos_participantes.habito_escrita || ''),(atributos_participantes.participacoes || ''),(atributos_participantes.atividade_social || ''),(atributos_participantes.atividade_fisica || ''),(atributos_participantes.saude || ''),(atributos_participantes.problema_memoria || ''),(atributos_participantes.int_cotidiano || ''),(atributos_participantes.mora || ''),(atributos_participantes.escolaridade || ''),(atributos_participantes.renda_mensal || ''),(atributos_participantes.demencia_diagnotic || ''),(atributos_participantes.dominancia || ''),(atributos_participantes.religiao || ''), getToday()];
				$cordovaSQLite.execute(db, query_atributo, data_Insert_atributo).then(function(result_atributo) {
					last_insert_id_atributo = result_atributo.insertId;
					localStorage.setItem('atributos_participantes'+last_insert_id, JSON.stringify(atributos_participantes));
				}, function(error) {
				});
		    	$location.hash('inputNome');
		        $ionicScrollDelegate.anchorScroll();

		        var arrParticipantes = localStorage.getItem('arrParticipantes'),
		        	arrParticipantes = JSON.parse(arrParticipantes),
		        	arrParticipantesNovo = {'id': last_insert_id, 'nome' : novo_participante['nome']}
		        	arrParticipantes.push(arrParticipantesNovo);

				localStorage.removeItem('arrParticipantes');
		        localStorage.setItem('arrParticipantes', JSON.stringify(arrParticipantes));

				$ionicPopup.alert({
		          title: 'Participante',
		          content: 'Cadastro efetuado com sucesso.'
		        })
		        .then(function(result) {
		        	$ionicLoading.show({
						template: '<ion-spinner icon="bubbles"></ion-spinner><br />Carregando Participante',
					});
			        if(result) {
						$timeout(function(){
							if(acao == 'salvar'){;
								$state.go('tabsController.participantes', { 'p': last_insert_id, 'test': false });
							} else {
						    	$state.go('tabsController.participantes', { 'p': last_insert_id, 'test': true });
							}
						    $ionicLoading.hide();
						},1000);
			        }
		        });
	        },1000);
		});
		$ionicLoading.hide();
	};

}]);
   
adicionarParticipanteCtrl.controller('editarParticipanteCtrl', ['$scope', '$stateParams', '$state', '$cordovaSQLite', 'Data', '$ionicLoading', '$timeout', '$ionicPopup', // The following is the constructor function for this page's controller. See https://docs.angularjs.org/guide/controller
// You can include any angular dependencies as parameters for this function
// TIP: Access Route Parameters for your page via $stateParams.parameterName
function ($scope, $stateParams, $state, $cordovaSQLite, Data, $ionicLoading, $timeout, $ionicPopup) {
	$scope.$root.tabsHidden = "";
	$scope.$root.hideEdit = true;
	var id = localStorage.getItem('id');
	if(id == undefined){
		$state.go('login');
		return false;
	}

	$scope.titulo = 'Alterar dados do Participante';

	$scope.participante = [];
	var endereco_participante = [],
		atributos_participantes = [],
		acompanhante = [];
	db = Data.getDatabase();

	$scope.mora_list = [
		{ 'id' : 'Sozinho' },
		{ 'id' : 'Filhos' },
		{ 'id' : 'Instituição' },
		{ 'id' : 'Companheiro' },
		{ 'id' : 'Outros' },
	];

	$scope.sim_nao = [
		{ 'id' : '0', 'value' : 'Não' },
		{ 'id' : '1', 'value' : 'Sim' },
	];

	$scope.escolaridade_lista = [
		{ 'id' : '0', 'value' : '(0) Anos' },
		{ 'id' : '1', 'value' : '(1) Anos' },
		{ 'id' : '2', 'value' : '(2) Anos' },
		{ 'id' : '3', 'value' : '(3) Anos' },
		{ 'id' : '4', 'value' : '(4) Anos' },
		{ 'id' : '5', 'value' : '(5) Anos' },
		{ 'id' : '6', 'value' : '(6) Anos' },
		{ 'id' : '7', 'value' : '(7) Anos' },
		{ 'id' : '8', 'value' : '(8) Anos' },
		{ 'id' : '9', 'value' : '(9) Anos' },
		{ 'id' : '10', 'value' : '(10) Anos' },
		{ 'id' : '11', 'value' : '(11) Anos' },
		{ 'id' : '12', 'value' : '(12) Anos' },
		{ 'id' : '+12', 'value' : '(+12) Anos' },
	];

	$scope.estado = [
		{ 'id' : 'AC', 'value' : 'Acre'},
		{ 'id' : 'AL', 'value' : 'Alagoas'},
		{ 'id' : 'AP', 'value' : 'Amapá'},
		{ 'id' : 'AM', 'value' : 'Amazonas'},
		{ 'id' : 'BA', 'value' : 'Bahia'},
		{ 'id' : 'CE', 'value' : 'Ceará'},
		{ 'id' : 'DF', 'value' : 'Distrito'},
		{ 'id' : 'ES', 'value' : 'Espírito'},
		{ 'id' : 'GO', 'value' : 'Goiás'},
		{ 'id' : 'MA', 'value' : 'Maranhão'},
		{ 'id' : 'MT', 'value' : 'Mato'},
		{ 'id' : 'MS', 'value' : 'Mato'},
		{ 'id' : 'MG', 'value' : 'Minas'},
		{ 'id' : 'PA', 'value' : 'Pará'},
		{ 'id' : 'PB', 'value' : 'Paraíba'},
		{ 'id' : 'PR', 'value' : 'Paraná'},
		{ 'id' : 'PE', 'value' : 'Pernambuco'},
		{ 'id' : 'PI', 'value' : 'Piauí'},
		{ 'id' : 'RJ', 'value' : 'Rio'},
		{ 'id' : 'RN', 'value' : 'Rio'},
		{ 'id' : 'RS', 'value' : 'Rio'},
		{ 'id' : 'RD', 'value' : 'Rondônia'},
		{ 'id' : 'RR', 'value' : 'Roraima'},
		{ 'id' : 'SC', 'value' : 'Santa'},
		{ 'id' : 'AP', 'value' : 'São'},
		{ 'id' : 'SE', 'value' : 'Sergipe'},
		{ 'id' : 'TO', 'value' : 'Tocantins'},
	];

	$scope.renda_mensal = [
		{ 'id' : '1', 'value' : 'Menor que 1 salário mínimo' },
		{ 'id' : '2', 'value' : '1 salário mínimo' },
		{ 'id' : '3', 'value' : '1 e 2 salários' },
		{ 'id' : '4', 'value' : 'Mais de 3 salários mínimos' },
	];

	$scope.estado_civil = [
		{ 'id' : 'Solteiro', 'value' : 'Solteiro' },
		{ 'id' : 'Casado', 'value' : 'Casado' },
		{ 'id' : 'Viúvo', 'value' : 'Viúvo' },
		{ 'id' : 'Divorciado / Separa', 'value' : 'Divorciado / Separa' },
	];

	$scope.dominancia = [
		{ 'id' : 'Destro', 'value' : 'Destro' },
		{ 'id' : 'Sinistro', 'value' : 'Sinistro' },
	];

	$scope.saude = [
		{ 'id' : '1', 'value' : 'Boa' },
		{ 'id' : '2', 'value' : 'Regular' },
		{ 'id' : '3', 'value' : 'Ruim' },
	];

	var query = "SELECT * FROM participantes WHERE id = "+$stateParams.id;
	db.transaction(function(transaction) {
	transaction.executeSql(query, [], function (tx, results) {
		var len = results.rows.length;
		$scope.participante.push(results.rows.item(0));
		$scope.participante = $scope.participante[0];
		$scope.participante.celular = $scope.participante.fone_celular;
		$scope.participante.telefone = $scope.participante.fone_fixo;
		var data_nascimento = $scope.participante.data_nascimento;
		if(data_nascimento != ''){
			data_nascimento = data_nascimento.split('-');
			$scope.participante.data_nascimento = data_nascimento[2]+'/'+data_nascimento[1]+'/'+data_nascimento[0];
		}
	}, null);
	});
	var query_atributos_participantes = "SELECT * FROM atributos_participantes WHERE id_participante = "+$stateParams.id;
	db.transaction(function(transaction_atributos_participantes) {
	transaction_atributos_participantes.executeSql(query_atributos_participantes, [], function (tx_atributos_participantes, results_atributos_participantes) {
		var len = results_atributos_participantes.rows.length;
		atributos_participantes.push(results_atributos_participantes.rows[0]);
		atributos_participantes = atributos_participantes[0];
		$scope.participante.atividade_fisica = atributos_participantes.atividade_fisica;
		$scope.participante.atividade_social = atributos_participantes.atividade_social;
		$scope.participante.atualizacao = atributos_participantes.atualizacao;
		$scope.participante.conveniencia = atributos_participantes.conveniencia == 1 ? true : false;
		$scope.participante.cursos = atributos_participantes.cursos == 1 ? true : false;
		$scope.participante.demencia_diagnotic = atributos_participantes.demencia_diagnotic;
		$scope.participante.dominancia = atributos_participantes.dominancia;
		$scope.participante.escolaridade = atributos_participantes.escolaridade;
		$scope.participante.habito_escrita = atributos_participantes.habito_escrita;
		$scope.participante.habito_leitura = atributos_participantes.habito_leitura;
		$scope.participante.int_cotidiano = atributos_participantes.int_cotidiano;
		$scope.participante.mora = atributos_participantes.mora;
		$scope.participante.problema_memoria = atributos_participantes.problema_memoria;
		$scope.participante.religiao = atributos_participantes.religiao;
		$scope.participante.renda_mensal = atributos_participantes.renda_mensal;
		$scope.participante.saude = atributos_participantes.saude;
		$scope.participante.terapias = atributos_participantes.terapias == 1 ? true : false;
		$scope.participante.participacoes = atributos_participantes.participacoes;
	}, null);
	});

	var query_endereco = "SELECT * FROM endereco WHERE id_participante = "+$stateParams.id;
	db.transaction(function(transaction_endereco) {
	transaction_endereco.executeSql(query_endereco, [], function (tx_endereco, results_endereco) {
		var len = results_endereco.rows.length;
		endereco_participante.push(results_endereco.rows[0]);
		endereco_participante = endereco_participante[0];
		$scope.participante.bairro = endereco_participante.bairro;
		$scope.participante.cep = endereco_participante.cep;
		$scope.participante.cidade = endereco_participante.cidade;
		$scope.participante.complemento = endereco_participante.complemento;
		$scope.participante.estado = endereco_participante.estado;
		$scope.participante.id = endereco_participante.id;
		$scope.participante.id_participante = endereco_participante.id_participante;
		$scope.participante.numero = endereco_participante.numero;
		$scope.participante.pais = endereco_participante.pais;
		$scope.participante.rua = endereco_participante.rua;
	}, null);
	});

	var query_acompanhante = "SELECT * FROM acompanhante WHERE id_participante = "+$stateParams.id;
	db.transaction(function(transaction_acompanhante) {
	transaction_acompanhante.executeSql(query_acompanhante, [], function (tx_acompanhante, results_acompanhante) {
		var len = results_acompanhante.rows.length;
		acompanhante = results_acompanhante.rows[0];
		$scope.participante.nomeAcompanhante = acompanhante.nome;
		$scope.participante.telAcompanhante = acompanhante.telefone;
	}, null);
	});
	if($stateParams.redirect == 'true'){
		$state.go('tabsController.tRDAP', {'id': $stateParams.id});
	}

	$scope.editParticipant = function(data)
	{
		$ionicLoading.show({
			template: '<ion-spinner icon="bubbles"></ion-spinner><br />Salvando Participante',
		});
		var user = localStorage.getItem('id'),
		user_id = JSON.parse(user);
		var id = Math.floor(Date.now() / 1000),
			date = new Date(),
			date = date.getFullYear()+'-'+date.getMonth()+'-'+date.getDate(),
			novo_participante = {},
			db = Data.getDatabase();
		acompanhante = {
						'nome': data['nomeAcompanhante'] || '',
						'telefone': data['telAcompanhante' || '']
						};
		atributos_participantes = {
			'atividade_fisica': data['atividade_fisica'] || '',
			'atividade_social': data['atividade_social'] || '',
			'conveniencia': data['conveniencia'] ? 1 : 0,
			'cursos': data['cursos'] ? 1 : 0,
			'demencia_diagnotic': data['demencia_diagnotic'] || '',
			'dominancia': data['dominancia'] || '',
			'escolaridade': data['escolaridade'] || '',
			'habito_escrita': data['habito_escrita'] || '',
			'habito_leitura': data['habito_leitura'] || '',
			'habito_escrita': data['habito_escrita'] || '',
			'int_cotidiano': data['int_cotidiano'] || '',
			'mora': data['mora'] || '',
			'participacoes': data['participacoes'] || '',
			'problema_memoria': data['problema_memoria'] || '',
			'religiao': data['religiao'] || '',
			'renda_mensal': data['renda_mensal'] || '',
			'saude': data['saude'] || '',
			'terapias': data['terapias'] ? 1 : 0
		}
		novo_participante['data_cadastro'] = date;
		var data_nascimento = data['data_nascimento'] || '';
		if(data_nascimento != ''){
			data_nascimento = moment(data_nascimento).format('YYYY-MM-DD');
		}
		novo_participante['id'] = id;
		novo_participante['data_nascimento'] = data_nascimento;
		novo_participante['email'] = data['email'] || '';
		novo_participante['estado_civil'] = data['estado_civil'] || '';
		novo_participante['fone_celular'] = data['celular'] || '';
		novo_participante['fone_fixo'] = data['telefone'] || '';
		novo_participante['id'] = id;
		novo_participante['id_pesquisador'] = 0;
		novo_participante['idade'] = data['idade'] || '';
		novo_participante['local_atend'] = data['local_atend'] || '';
		novo_participante['nome'] = data['nome'] || '';
		novo_participante['profissao'] = data['profissao'] || '';
		novo_participante['status'] = 0;
		
		db = Data.getDatabase();
		db.transaction(function(tx)
		{
			var msg,
				continuar = true;
			queryParticipante = 'UPDATE participantes SET nome = ?, data_nascimento = ?, idade = ?, estado_civil = ?, profissao = ?, fone_fixo = ?, fone_celular = ?, email = ?, local_atend = ?, status = ?, atualizacao = ? WHERE id = ' + $stateParams.id;
			dataInsertParticipante = [novo_participante['nome'], novo_participante['data_nascimento'], novo_participante['idade'], novo_participante['estado_civil'], novo_participante['profissao'], novo_participante['fone_fixo'], novo_participante['fone_celular'], novo_participante['email'], novo_participante['local_atend'], novo_participante['status'], getToday()];
			$cordovaSQLite.execute(db, queryParticipante, dataInsertParticipante)
			.then(function(result) {
				msg = 'Cadastro atualizado com sucesso.';
			}, function(error) {
				msg = 'Falha ao atualizar participante.';
				continuar = false;
			});

			query = 'UPDATE endereco SET cep = ?, rua = ?, numero = ?, complemento = ?, bairro = ?, cidade = ?, estado = ?, pais = ?, atualizacao = ? WHERE id_participante = ' + $stateParams.id;
			data_Insert = [(data['cep'] || ''), (data['rua'] || ''), (data['numero'] || ''), (data['complemento'] || ''), (data['bairro'] || ''), (data['cidade'] || ''), (data['estado'] || ''), (data['pais'] || ''), getToday()];
			$cordovaSQLite.execute(db, query, data_Insert); 
			query = 'UPDATE acompanhante SET nome = ? , telefone = ? , atualizacao = ? WHERE id_participante = ' + $stateParams.id;
			data_Insert = [(acompanhante.nome || ''), (acompanhante.telefone || ''), getToday()];
			$cordovaSQLite.execute(db, query, data_Insert); 
			query = 'UPDATE atributos_participantes SET cursos = ?, conveniencia = ?, terapias = ?, habito_leitura = ?, habito_escrita = ?, participacoes = ?, atividade_social = ?, atividade_fisica = ?, saude = ?, problema_memoria = ?, int_cotidiano = ?, mora = ?, escolaridade = ?, renda_mensal = ?, demencia_diagnotic = ?, dominancia = ?, religiao = ?, atualizacao = ? WHERE id_participante = '+ $stateParams.id;
			data_Insert = [(atributos_participantes.cursos || ''),(atributos_participantes.conveniencia || ''),(atributos_participantes.terapias || ''),(atributos_participantes.habito_leitura || ''),(atributos_participantes.habito_escrita || ''),(atributos_participantes.participacoes || ''),(atributos_participantes.atividade_social || ''),(atributos_participantes.atividade_fisica || ''),(atributos_participantes.saude || ''),(atributos_participantes.problema_memoria || ''),(atributos_participantes.int_cotidiano || ''),(atributos_participantes.mora || ''),(atributos_participantes.escolaridade || ''),(atributos_participantes.renda_mensal || ''),(atributos_participantes.demencia_diagnotic || ''),(atributos_participantes.dominancia || ''),(atributos_participantes.religiao || ''), getToday()];
			$cordovaSQLite.execute(db, query, data_Insert);

			$ionicPopup.alert({
	          title: 'Participante',
	          content: 'Cadastro atualizado com sucesso.'
	        })
	        .then(function(result) {
	          if(result) {
				redir = $timeout(function() {
					db = Data.getDatabase();
					$state.go('tabsController.participantes');
				}, 1000);
				$ionicLoading.hide();
	          }
	        });
			try {
				$scope.adicionarParticipante.$setPristine();       
			} catch (e) {
				$scope.errorMessage = e.message;
			}   
			$ionicLoading.hide();
		});
	};
	$scope.teste = function()
	{
		$state.go('tabsController.participantes', { 'p': $stateParams.id, 'test': true });
	}
	$scope.cancelar = function()
	{
		$state.go('tabsController.participantes');
	}
}]);
  
adicionarParticipanteCtrl.controller('visualizarParticipanteCtrl', ['$scope', '$stateParams', '$state', '$cordovaSQLite', 'Data', '$ionicLoading', '$timeout',// The following is the constructor function for this page's controller. See https://docs.angularjs.org/guide/controller
// You can include any angular dependencies as parameters for this function
// TIP: Access Route Parameters for your page via $stateParams.parameterName
function ($scope, $stateParams, $state, $cordovaSQLite, Data, $ionicLoading, $timeout) {
	$scope.$root.tabsHidden = "";
	$scope.$root.hideEdit = "false";
	var id = localStorage.getItem('id');
	if(id == undefined){
		$state.go('login');
		return false;
	}
	var id = $stateParams.id;

	$scope.voltar = function()
	{
		$state.go('tabsController.atendimentos', {'id': id});
	}

	$scope.$on("$ionicView.beforeEnter", function(event, data){
		$scope.refreshItens();
	});

	$scope.refreshItens = function() {
		$scope.info_participante = [];
		$scope.endereco_participante = [];
		$scope.atributos_participantes = [];
		$scope.acompanhante = [];
		db = Data.getDatabase();
		var query = "SELECT * FROM participantes WHERE id = "+$stateParams.id;
		db.transaction(function(transaction) {
		transaction.executeSql(query, [], function (tx, results) {
			var len = results.rows.length;
			$scope.info_participante.push(results.rows.item(0));
			$scope.info_participante = $scope.info_participante[0];
		}, null);
		});

		var query_atributos_participantes = "SELECT * FROM atributos_participantes WHERE id_participante = "+$stateParams.id;
		db.transaction(function(transaction_atributos_participantes) {
		transaction_atributos_participantes.executeSql(query_atributos_participantes, [], function (tx_atributos_participantes, results_atributos_participantes) {
			var len = results_atributos_participantes.rows.length;
			$scope.atributos_participantes.push(results_atributos_participantes.rows.item(0));
			$scope.atributos_participantes = $scope.atributos_participantes[0];
		}, null);
		});

		var query_endereco = "SELECT * FROM endereco WHERE id_participante = "+$stateParams.id;
		db.transaction(function(transaction_endereco) {
		transaction_endereco.executeSql(query_endereco, [], function (tx_endereco, results_endereco) {
			var len = results_endereco.rows.length,
				endereco_participante = [];
			endereco_participante.push(results_endereco.rows.item(0));
			endereco_participante = endereco_participante[0];
			$scope.info_participante.bairro = endereco_participante.bairro;
			$scope.info_participante.cep = endereco_participante.cep;
			$scope.info_participante.cidade = endereco_participante.cidade;
			$scope.info_participante.complemento = endereco_participante.complemento;
			$scope.info_participante.estado = endereco_participante.estado;
			$scope.info_participante.id = endereco_participante.id;
			$scope.info_participante.id_participante = endereco_participante.id_participante;
			$scope.info_participante.numero = endereco_participante.numero;
			$scope.info_participante.pais = endereco_participante.pais;
			$scope.info_participante.rua = endereco_participante.rua;
		}, null);
		});

		var query_acompanhante = "SELECT * FROM acompanhante WHERE id_participante = "+$stateParams.id;
		db.transaction(function(transaction_acompanhante) {
		transaction_acompanhante.executeSql(query_acompanhante, [], function (tx_acompanhante, results_acompanhante) {
			var len = results_acompanhante.rows.length,
				acompanhante = [];
			acompanhante.push(results_acompanhante.rows.item(0));
			acompanhante = acompanhante[0];
			$scope.info_participante.nomeAcompanhante = acompanhante.nome;
			$scope.info_participante.telAcompanhante = acompanhante.telefone;
		}, null);
		});

	}


}]);

adicionarParticipanteCtrl.controller('blank', ['$scope', '$ionicPlatform', '$stateParams', '$state',
function ($scope, $ionicPlatform, $stateParams, $state) {
	$state.go('tabsController.participantes');
}]);


adicionarParticipanteCtrl.factory('listaParticipantes', function($cordovaSQLite){
    var arr = [];
    return {
        getData:function(){
            var query = "SELECT * FROM participantes ORDER BY id";
            return $cordovaSQLite.execute(db, query, []).then(function(res){
                arr = res.rows;
                return arr;
            }, function(err){
                console.error(err);
            });
        }
    }
});

adicionarParticipanteCtrl.controller('participantesCtrl', ['$scope', '$ionicPlatform', '$stateParams', '$state', '$cordovaSQLite', 'Data', '$ionicLoading', '$ionicHistory', '$timeout', '$ionicPopup', 'listaParticipantes', // The following is the constructor function for this page's controller. See https://docs.angularjs.org/guide/controller
// You can include any angular dependencies as parameters for this function
// TIP: Access Route Parameters for your page via $stateParams.parameterName
function ($scope, $ionicPlatform, $stateParams, $state, $cordovaSQLite, Data, $ionicLoading, $ionicHistory, $timeout, $ionicPopup, listaParticipantes) {
	
	$scope.$root.tabsHidden = "";
	$scope.$root.hideEdit = "true";
	var id = localStorage.getItem('id'),
		sync = localStorage.getItem('sync');
	if(id == undefined){
		$state.go('login');
		return false;
	}console.log($stateParams.p);
	console.log($stateParams.test);
	if($stateParams.p || $stateParams.test){
		// $state.go('tabsController.atendimentos', { 'id': $stateParams.p, 'test': $stateParams.test });
		console.log('aki');
		return false;
	}
	db = Data.getDatabase();
	$scope.participantes = [];
	$ionicPlatform.onHardwareBackButton(function() {
	     event.preventDefault();
	     event.stopPropagation();
	});
	arrParticipantes = [];
	$scope.$on("$ionicView.beforeEnter", function(event, data){
		$scope.refreshItens();
		$scope.participantes = arrParticipantes;
	});

	$scope.refreshItens = function() {
		arrParticipantes = [];
		var data = listaParticipantes.getData().then(function(res){
	        for (var i = 0; i < res.length; i++) {
	        	arrParticipantes.push(res[i]);
	        }
	        $scope.participantes = arrParticipantes;
	    });

	}

	$scope.sync = function()
	{
		if(!navigator.onLine){
			$ionicPopup.alert({
	          title: 'Sem conexão com a internet',
	          content: 'Desculpe, nenhuma conexão com a Internet foi detectada. Reconecte-se e tente novamente.'
	        });
			return false;
		}

		$ionicLoading.show({
			template: '<ion-spinner icon="bubbles"></ion-spinner><br />Aguarde, sincronizados as informações.<br />Isso pode demorar um pouco',
		});

		var sync = localStorage.getItem('sync'),
			participantes = [],
			acompanhante = [],
			atributos_participantes = [],
			endereco = [],
			mini_exame = [],
			trdap_teste_a = [],
			trdap_teste_b = [],
			trdap_teste_c = [],
			resultado_trdap = [],
			reconhecimento_proverbios = [];
		

		var query_participantes = "SELECT * FROM participantes WHERE atualizacao > '"+sync+"'";
		db.transaction(function(transaction_participantes) {
		transaction_participantes.executeSql(query_participantes, [], function (tx, results_participantes) {
			var len = results_participantes.rows.length, i;
			for (i = 0; i < len; i++){
				participantes.push(results_participantes.rows.item(i));
			}
		}, null);
		});
		
		var query_acompanhante = "SELECT * FROM acompanhante WHERE atualizacao > '"+sync+"'";
		db.transaction(function(transaction_acompanhante) {
		transaction_acompanhante.executeSql(query_acompanhante, [], function (tx, results_acompanhante) {
			var len = results_acompanhante.rows.length, i;
			for (i = 0; i < len; i++){
				acompanhante.push(results_acompanhante.rows.item(i));
			}
		}, null);
		});

		var query_atributos_participantes = "SELECT * FROM atributos_participantes WHERE atualizacao > '"+sync+"'";
		db.transaction(function(transaction_atributos_participantes) {
		transaction_atributos_participantes.executeSql(query_atributos_participantes, [], function (tx, results_atributos_participantes) {
			var len = results_atributos_participantes.rows.length, i;
			for (i = 0; i < len; i++){
				atributos_participantes.push(results_atributos_participantes.rows.item(i));
			}
		}, null);
		});

		var query_endereco = "SELECT * FROM endereco where atualizacao > '"+sync+"'";
		db.transaction(function(transaction_endereco) {
		transaction_endereco.executeSql(query_endereco, [], function (tx, results_endereco) {
			var len = results_endereco.rows.length, i;
			for (i = 0; i < len; i++){
				endereco.push(results_endereco.rows.item(i));
			}
		}, null);
		});

		var query_mini_exame = "SELECT mini_exame.* FROM mini_exame, resultado_trdap WHERE mini_exame.codigo = resultado_trdap.codigo AND mini_exame.atualizacao > '"+sync+"'";
		db.transaction(function(transaction_mini_exame) {
		transaction_mini_exame.executeSql(query_mini_exame, [], function (tx, results_mini_exame) {
			var len = results_mini_exame.rows.length, i;
			for (i = 0; i < len; i++){
				mini_exame.push(results_mini_exame.rows.item(i));
			}
		}, null);
		});

		var query_trdap_teste_a = "SELECT trdap_teste_a.* FROM trdap_teste_a, resultado_trdap WHERE trdap_teste_a.codigo = resultado_trdap.codigo AND trdap_teste_a.atualizacao > '"+sync+"'";
		db.transaction(function(transaction_trdap_teste_a) {
		transaction_trdap_teste_a.executeSql(query_trdap_teste_a, [], function (tx, results_trdap_teste_a) {
			var len = results_trdap_teste_a.rows.length, i;
			for (i = 0; i < len; i++){
				trdap_teste_a.push(results_trdap_teste_a.rows.item(i));
			}
		}, null);
		});

		var query_trdap_teste_b = "SELECT trdap_teste_b.* FROM trdap_teste_b, resultado_trdap WHERE trdap_teste_b.codigo = resultado_trdap.codigo AND trdap_teste_b.atualizacao > '"+sync+"'";
		db.transaction(function(transaction_trdap_teste_b) {
		transaction_trdap_teste_b.executeSql(query_trdap_teste_b, [], function (tx, results_trdap_teste_b) {
			var len = results_trdap_teste_b.rows.length, i;
			for (i = 0; i < len; i++){
				trdap_teste_b.push(results_trdap_teste_b.rows.item(i));
			}
		}, null);
		});

		var query_trdap_teste_c = "SELECT trdap_teste_c.* FROM trdap_teste_c, resultado_trdap WHERE trdap_teste_c.codigo = resultado_trdap.codigo AND trdap_teste_c.atualizacao > '"+sync+"'";
		db.transaction(function(transaction_trdap_teste_c) {
		transaction_trdap_teste_c.executeSql(query_trdap_teste_c, [], function (tx, results_trdap_teste_c) {
			var len = results_trdap_teste_c.rows.length, i;
			for (i = 0; i < len; i++){
				trdap_teste_c.push(results_trdap_teste_c.rows.item(i));
			}
		}, null);
		});

		var query_resultado_trdap = "SELECT * FROM resultado_trdap where atualizacao > '"+sync+"'";
		db.transaction(function(transaction_resultado_trdap) {
		transaction_resultado_trdap.executeSql(query_resultado_trdap, [], function (tx, results_resultado_trdap) {
			var len = results_resultado_trdap.rows.length, i;
			for (i = 0; i < len; i++){
				resultado_trdap.push(results_resultado_trdap.rows.item(i));
			}
		}, null);
		});

		var query_reconhecimento_proverbios = "SELECT * FROM reconhecimento_proverbios where atualizacao > '"+sync+"'";
		db.transaction(function(transaction_reconhecimento_proverbios) {
		transaction_reconhecimento_proverbios.executeSql(query_reconhecimento_proverbios, [], function (tx, results_reconhecimento_proverbios) {
			var len = results_reconhecimento_proverbios.rows.length, i;
			for (i = 0; i < len; i++){
				reconhecimento_proverbios.push(results_reconhecimento_proverbios.rows.item(i));
			}
		}, null);
		});
		var info = localStorage.getItem('info'),
			info = JSON.parse(info);
		var info_update = {};
		info_update.id = info.user[0].id;
		info_update.cancelados = info.cancelados;
		info_update.concluidos = info.concluidos;
		info_update.total = info.total;
		info_update.participantes = participantes;
		info_update.acompanhante = acompanhante;
		info_update.atributos_participantes = atributos_participantes;
		info_update.endereco = endereco;
		info_update.mini_exame = mini_exame;
		info_update.trdap_teste_a = trdap_teste_a;
		info_update.trdap_teste_b = trdap_teste_b;
		info_update.trdap_teste_c = trdap_teste_c;
		info_update.reconhecimento_proverbios = reconhecimento_proverbios;
		info_update.resultado_trdap = resultado_trdap;
		redir = $timeout(function() {
			Data.sync_data(info_update).success(function(data)
				{
					if(data == true){
						/*
							ISSO PRECISA SER MELHORADO É UMA CÓPIA DO CONTROLLER LOGIN
							PRECISA FAZER UMA MÉTODO SÓ PARA PODER MELHORAR
						 */
						var user_sync = {};
						user_sync.id = info.user[0].id;
						user_sync.login = info.user[0].login;
						user_sync.password = info.user[0].senha;
						var query = "DROP TABLE IF EXISTS acompanhante;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS atributos_participantes;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS endereco;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS mini_exame;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS participantes;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS reconhecimento_proverbios;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS resultado_trdap;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS trdap_teste_a;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS trdap_teste_b;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS trdap_teste_c;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS usuario";
						$cordovaSQLite.execute(db, query);
						
						var query = "CREATE TABLE IF NOT EXISTS acompanhante (id integer primary key, nome text, telefone text, id_participante integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS atributos_participantes (id integer primary key, id_participante integer, cursos integer, conveniencia integer, terapias integer, habito_leitura integer, habito_escrita integer, participacoes text, atividade_social integer, atividade_fisica integer, saude text, problema_memoria integer, int_cotidiano integer, mora text, escolaridade text, renda_mensal integer, demencia_diagnotic integer, dominancia text, religiao text, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS endereco (id integer primary key, id_participante integer, cep text, rua text, numero text, complemento text, bairro text, cidade text, estado text, pais text, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS mini_exame (id integer primary key, id_participante integer, codigo text, data date, orientacao_temporal integer, orientacao_espacial integer, memoria_imediata integer, atencao_calculo integer, memoria_evocacao integer, linguagem integer, total REAL, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS participantes (id integer primary key, id_usuario integer , id_pesquisador integer , nome text , data_nascimento date , idade integer , estado_civil text , profissao text , fone_fixo text , fone_celular text , email text , local_atend text , status integer , data_cadastro date, atualizacao date );"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS reconhecimento_proverbios (id integer primary key, id_participante integer, codigo text, reconhecimento1 integer, reconhecimento2 integer, reconhecimento3 integer, reconhecimento4 integer, reconhecimento5 integer, reconhecimento6 integer, data date, total REAL, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS resultado_trdap (id integer primary key, id_participante integer, data_inicio datetime, data_fim datetime, codigo text, status integer, total REAL, edita integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS trdap_teste_a (id integer primary key, id_participante integer, obs text, data date, codigo text, a_ordem1 integer, a_ordem2 integer, a_ordem3 integer, b_ordem1 integer, b_ordem2 integer, b_ordem3 integer, c_ordem1 integer, c_ordem2 integer, c_ordem3 integer, a_ponto1 integer, a_ponto2 integer, a_ponto3 integer, b_ponto1 integer, b_ponto2 integer, b_ponto3 integer, c_ponto1 integer, c_ponto2 integer, c_ponto3 integer, total REAL, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS trdap_teste_b (id integer primary key, id_participante integer, codigo text, data date, obs1 text, obs2 text, obs3 text, ponto1 integer, ponto2 integer, ponto3 integer, total REAL, obs4 text, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS trdap_teste_c (id integer primary key, id_participante integer, codigo text, data date, ordem1 integer, ordem2 integer, ordem3 integer, ponto1 integer, ponto2 integer, ponto3 integer, total REAL, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS usuario (id integer primary key, data datetime , nome text , login text , senha text , email text , fone text , rua text , bairro text , cidade text , estado text , pais text , cep text , numero text , complemento text , profissao text , status integer , id_usuario integer , nivel integer , num_testes integer , atualizacao date);";
						$cordovaSQLite.execute(db, query);
						
						db.transaction(function(tx)
						{
							dataPupulate = Data.getData(user_sync).success(function(info)
							{
								var atualizacao = getToday();
								localStorage.setItem('info', JSON.stringify(info));
								var query = "DELETE FROM usuario";
								$cordovaSQLite.execute(db, query);
								var query = 'INSERT INTO usuario ( id, data, nome, login, senha, email, fone, rua, bairro, cidade, estado, pais, cep, numero, complemento, profissao, status, id_usuario, nivel, num_testes, atualizacao ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
									data_Insert = [(info.user[0].id || ''), (info.user[0].data || ''), (info.user[0].nome || ''), (info.user[0].login || ''), (info.user[0].senha || ''), (info.user[0].email || ''), (info.user[0].fone || ''), (info.user[0].rua || ''), (info.user[0].bairro || ''), (info.user[0].cidade || ''), (info.user[0].estado || ''), (info.user[0].pais || ''), (info.user[0].cep || ''), (info.user[0].numero || ''), (info.user[0].complemento || ''), (info.user[0].profissao || ''), (info.user[0].status || ''), (info.user[0].id_usuario || ''), (info.user[0].nivel || ''), (info.user[0].num_testes || ''), atualizacao];
								$cordovaSQLite.execute(db, query, data_Insert)
								.then(function(result) {
								}, function(error) {
								}); 
								participantes = info.participantes;
								participantesKeys = Object.keys(participantes),
								qtdParticipantes = participantesKeys.length;
								arrParticipantes = [];
								arrResultado = [];
								arrAcompanhante = [];
								arrAtributosParticipantes = [];
								arrEndereco = [];
								var query = "DELETE FROM participantes";
								$cordovaSQLite.execute(db, query);
								for (var i = 0; i < qtdParticipantes; i++) {
									query = 'INSERT INTO participantes ( id, id_usuario, id_pesquisador, nome, data_nascimento, idade, estado_civil, profissao, fone_fixo, fone_celular, email, local_atend, status, data_cadastro, atualizacao)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ';
									dataInsertParticipante = [participantes[participantesKeys[i]].id, (participantes[participantesKeys[i]].id_usuario || ''), (participantes[participantesKeys[i]].id_pesquisador || ''), (participantes[participantesKeys[i]].nome || ''), (participantes[participantesKeys[i]].data_nascimento || ''), (participantes[participantesKeys[i]].idade || ''), (participantes[participantesKeys[i]].estado_civil || ''), (participantes[participantesKeys[i]].profissao || ''), (participantes[participantesKeys[i]].fone_fixo || ''), (participantes[participantesKeys[i]].fone_celular || ''), (participantes[participantesKeys[i]].email || ''), (participantes[participantesKeys[i]].local_atend || ''), (participantes[participantesKeys[i]].status || ''), (participantes[participantesKeys[i]].data_cadastro || ''), atualizacao];
									$cordovaSQLite.execute(db, query, dataInsertParticipante); 
									arrParticipantes[participantes[participantesKeys[i]].id] = {'id': participantes[participantesKeys[i]].id, 'nome' : participantes[participantesKeys[i]].nome};
									acompanhante = participantes[participantesKeys[i]].acompanhante;
									acompanhanteKeys = Object.keys(acompanhante),
									qtdAcompanhante = acompanhanteKeys.length;

									$cordovaSQLite.execute(db, query);
									if(qtdAcompanhante > 0){
										for (var ac = 0; ac < qtdAcompanhante; ac++) {
											query = 'INSERT INTO acompanhante (id , nome , telefone , id_participante, atualizacao) VALUES(? ,? ,? ,?, ?)';
											data_Insert = [(acompanhante[acompanhanteKeys[ac]].id || ''), (acompanhante[acompanhanteKeys[ac]].nome || ''), (acompanhante[acompanhanteKeys[ac]].telefone || ''), (acompanhante[acompanhanteKeys[ac]].id_participante || ''), atualizacao];
											arrAcompanhante[acompanhante[acompanhanteKeys[ac]].id] = {'id' : acompanhante[acompanhanteKeys[ac]].id , 'nome' : acompanhante[acompanhanteKeys[ac]].nome , 'telefone' : acompanhante[acompanhanteKeys[ac]].telefone , 'id_participante' : acompanhante[acompanhanteKeys[ac]].id_participante};
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);
									atributos_participantes = participantes[participantesKeys[i]].atributos_participantes;
									keysAtributosAcompanhante = Object.keys(atributos_participantes);
									qtdAtributosAcompanhante = keysAtributosAcompanhante.length;
									if(qtdAtributosAcompanhante > 0){
										for (var aa = 0; aa < qtdAtributosAcompanhante; aa++) {
											query = 'INSERT INTO atributos_participantes ( id, id_participante, cursos, conveniencia, terapias, habito_leitura, habito_escrita, participacoes, atividade_social, atividade_fisica, saude, problema_memoria, int_cotidiano, mora, escolaridade, renda_mensal, demencia_diagnotic, dominancia, religiao, atualizacao) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
											data_Insert = [(atributos_participantes[keysAtributosAcompanhante[aa]].id || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].id_participante || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].cursos || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].conveniencia || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].terapias || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].habito_leitura || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].habito_escrita || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].participacoes || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].atividade_social || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].atividade_fisica || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].saude || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].problema_memoria || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].int_cotidiano || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].mora || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].escolaridade || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].renda_mensal || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].demencia_diagnotic || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].dominancia || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].religiao || ''), atualizacao];
											arrAtributosParticipantes[atributos_participantes[keysAtributosAcompanhante[aa]].id] = {'id' : atributos_participantes[keysAtributosAcompanhante[aa]].id ,'id_participante' : atributos_participantes[keysAtributosAcompanhante[aa]].id_participante ,'cursos' : atributos_participantes[keysAtributosAcompanhante[aa]].cursos ,'conveniencia' : atributos_participantes[keysAtributosAcompanhante[aa]].conveniencia ,'terapias' : atributos_participantes[keysAtributosAcompanhante[aa]].terapias ,'habito_leitura' : atributos_participantes[keysAtributosAcompanhante[aa]].habito_leitura ,'habito_escrita' : atributos_participantes[keysAtributosAcompanhante[aa]].habito_escrita ,'participacoes' : atributos_participantes[keysAtributosAcompanhante[aa]].participacoes ,'atividade_social' : atributos_participantes[keysAtributosAcompanhante[aa]].atividade_social ,'atividade_fisica' : atributos_participantes[keysAtributosAcompanhante[aa]].atividade_fisica ,'saude' : atributos_participantes[keysAtributosAcompanhante[aa]].saude ,'problema_memoria' : atributos_participantes[keysAtributosAcompanhante[aa]].problema_memoria ,'int_cotidiano' : atributos_participantes[keysAtributosAcompanhante[aa]].int_cotidiano ,'mora' : atributos_participantes[keysAtributosAcompanhante[aa]].mora ,'escolaridade' : atributos_participantes[keysAtributosAcompanhante[aa]].escolaridade ,'renda_mensal' : atributos_participantes[keysAtributosAcompanhante[aa]].renda_mensal ,'demencia_diagnotic' : atributos_participantes[keysAtributosAcompanhante[aa]].demencia_diagnotic ,'dominancia' : atributos_participantes[keysAtributosAcompanhante[aa]].dominancia ,'religiao' : atributos_participantes[keysAtributosAcompanhante[aa]].religiao};
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);
									endereco_participante = participantes[participantesKeys[i]].endereco_participante;
									keysAtributosAcompanhante = Object.keys(endereco_participante);
									qtdAtributosAcompanhante = keysAtributosAcompanhante.length;
									if(endereco_participante.length > 0){
										for (var aa = 0; aa < qtdAtributosAcompanhante; aa++) {
											query = 'INSERT INTO endereco ( id, id_participante, cep, rua, numero, complemento, bairro, cidade, estado, pais, atualizacao) VALUES (?,?,?,?,?,?,?,?,?,?,?)';
											data_Insert = [(endereco_participante[keysAtributosAcompanhante[aa]].id || ''), (endereco_participante[keysAtributosAcompanhante[aa]].id_participante || ''), (endereco_participante[keysAtributosAcompanhante[aa]].cep || ''), (endereco_participante[keysAtributosAcompanhante[aa]].rua || ''), (endereco_participante[keysAtributosAcompanhante[aa]].numero || ''), (endereco_participante[keysAtributosAcompanhante[aa]].complemento || ''), (endereco_participante[keysAtributosAcompanhante[aa]].bairro || ''), (endereco_participante[keysAtributosAcompanhante[aa]].cidade || ''), (endereco_participante[keysAtributosAcompanhante[aa]].estado || ''), (endereco_participante[keysAtributosAcompanhante[aa]].pais || ''), atualizacao];
											arrEndereco[endereco_participante[keysAtributosAcompanhante[aa]].id] = {'id': endereco_participante[keysAtributosAcompanhante[aa]].id , 'id_participante': endereco_participante[keysAtributosAcompanhante[aa]].id_participante , 'cep': endereco_participante[keysAtributosAcompanhante[aa]].cep , 'rua': endereco_participante[keysAtributosAcompanhante[aa]].rua , 'numero': endereco_participante[keysAtributosAcompanhante[aa]].numero , 'complemento': endereco_participante[keysAtributosAcompanhante[aa]].complemento , 'bairro': endereco_participante[keysAtributosAcompanhante[aa]].bairro , 'cidade': endereco_participante[keysAtributosAcompanhante[aa]].cidade , 'estado': endereco_participante[keysAtributosAcompanhante[aa]].estado , 'pais': endereco_participante[keysAtributosAcompanhante[aa]].pais };
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);
									mini_exames = participantes[participantesKeys[i]].mini_exames;
									keysMiniExames = Object.keys(mini_exames);
									qtdMiniExames = keysMiniExames.length;
									if(qtdMiniExames > 0){
										for (var me = 0; me < qtdMiniExames; me++) {
											query = 'INSERT INTO mini_exame (id, id_participante, codigo, data, orientacao_temporal, orientacao_espacial, memoria_imediata, atencao_calculo, memoria_evocacao, linguagem, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(mini_exames[keysMiniExames[me]].id || ''), (mini_exames[keysMiniExames[me]].id_participante || ''), (mini_exames[keysMiniExames[me]].codigo || ''), (mini_exames[keysMiniExames[me]].data || ''), (mini_exames[keysMiniExames[me]].orientacao_temporal || ''), (mini_exames[keysMiniExames[me]].orientacao_espacial || ''), (mini_exames[keysMiniExames[me]].memoria_imediata || ''), (mini_exames[keysMiniExames[me]].atencao_calculo || ''), (mini_exames[keysMiniExames[me]].memoria_evocacao || ''), (mini_exames[keysMiniExames[me]].linguagem || ''), (mini_exames[keysMiniExames[me]].total || ''), (mini_exames[keysMiniExames[me]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);
									reconhecimento_proverbios = participantes[participantesKeys[i]].reconhecimento_proverbios;
									keysReconhecimentoProverbios = Object.keys(reconhecimento_proverbios);
									qtdReconhecimentoProverbios = keysReconhecimentoProverbios.length;
									if(qtdReconhecimentoProverbios > 0){
										for (var rp = 0; rp < qtdReconhecimentoProverbios; rp++) {
											query = 'INSERT INTO reconhecimento_proverbios (id, id_participante, codigo, reconhecimento1, reconhecimento2, reconhecimento3, reconhecimento4, reconhecimento5, reconhecimento6, data, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].id || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].id_participante || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].codigo || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto1 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto2 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto3 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto4 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto5 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto6 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].data || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].total || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);
									resultado_trdap = participantes[participantesKeys[i]].resultado_trdap;
									keysResultadoTrdap = Object.keys(resultado_trdap);
									qtdResultadoTrdap = keysResultadoTrdap.length;
									if(qtdResultadoTrdap > 0){
										for (var rt = 0; rt < qtdResultadoTrdap; rt++) {
											query = 'INSERT INTO resultado_trdap (id, id_participante, data_inicio, data_fim, codigo, status, total, edita, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)',
											data_Insert = [(resultado_trdap[keysResultadoTrdap[rt]].id || ''), (resultado_trdap[keysResultadoTrdap[rt]].id_participante || ''), (resultado_trdap[keysResultadoTrdap[rt]].data_inicio || ''), (resultado_trdap[keysResultadoTrdap[rt]].data_fim || ''), (resultado_trdap[keysResultadoTrdap[rt]].codigo || ''), (resultado_trdap[keysResultadoTrdap[rt]].status || ''), (resultado_trdap[keysResultadoTrdap[rt]].total || ''), (resultado_trdap[keysResultadoTrdap[rt]].edita || ''), atualizacao];
											var id_participante = participantes[participantesKeys[i]].id;
											arrResultado[resultado_trdap[keysResultadoTrdap[rt]].id] = {'id': resultado_trdap[keysResultadoTrdap[rt]].id, 'id_participante': resultado_trdap[keysResultadoTrdap[rt]].id_participante, 'data_inicio': resultado_trdap[keysResultadoTrdap[rt]].data_inicio, 'data_fim': resultado_trdap[keysResultadoTrdap[rt]].data_fim, 'codigo': resultado_trdap[keysResultadoTrdap[rt]].codigo, 'status': resultado_trdap[keysResultadoTrdap[rt]].status, 'total': resultado_trdap[keysResultadoTrdap[rt]].total, 'tempo': Data.dateDiff(resultado_trdap[keysResultadoTrdap[rt]].data_fim, resultado_trdap[keysResultadoTrdap[rt]].data_inicio)};
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);

									trdap_teste_a = participantes[participantesKeys[i]].trdap_teste_a;
									keysTrdapTesteA = Object.keys(trdap_teste_a);
									qtdTrdapTesteA = keysTrdapTesteA.length;
									if(keysTrdapTesteA > 0){
										for (var tta = 0; tta < qtdTrdapTesteA; tta++) {
											query = 'INSERT INTO trdap_teste_a (id, id_participante, obs, data, codigo, a_ordem1, a_ordem2, a_ordem3, b_ordem1, b_ordem2, b_ordem3, c_ordem1, c_ordem2, c_ordem3, a_ponto1, a_ponto2, a_ponto3, b_ponto1, b_ponto2, b_ponto3, c_ponto1, c_ponto2, c_ponto3, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(trdap_teste_a[keysTrdapTesteA[tta]].id || ''), (trdap_teste_a[keysTrdapTesteA[tta]].id_participante || ''), (trdap_teste_a[keysTrdapTesteA[tta]].obs || ''), (trdap_teste_a[keysTrdapTesteA[tta]].data || ''), (trdap_teste_a[keysTrdapTesteA[tta]].codigo || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ordem1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ordem2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ordem3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ordem1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ordem2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ordem3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ordem1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ordem2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ordem3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ponto1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ponto2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ponto3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ponto1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ponto2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ponto3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ponto1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ponto2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ponto3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].total || ''), (trdap_teste_a[keysTrdapTesteA[tta]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);
									trdap_teste_b = participantes[participantesKeys[i]].trdap_teste_b;
									keysTrdapTesteB = Object.keys(trdap_teste_b);
									qtdTrdapTesteB = keysTrdapTesteB.length;
									if(qtdTrdapTesteB > 0){
										for (var ttb = 0; ttb < qtdTrdapTesteB; ttb++) {
											query = 'INSERT INTO trdap_teste_b (id, id_participante, codigo, data, obs1, obs2, obs3, ponto1, ponto2, ponto3, total, obs4, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(trdap_teste_b[keysTrdapTesteB[ttb]].id || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].id_participante || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].codigo || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].data || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].obs1 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].obs2 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].obs3 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].ponto1 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].ponto2 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].ponto3 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].total || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].obs4 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);
									trdap_teste_c = participantes[participantesKeys[i]].trdap_teste_c;
									keysTrdapTesteC = Object.keys(trdap_teste_c);
									qtdTrdapTesteC = keysTrdapTesteC.length;
									if(qtdTrdapTesteC > 0){
										for (var ttc = 0; ttc < qtdTrdapTesteC; ttc++) {
											query = 'INSERT INTO trdap_teste_c (id, id_participante, codigo, data, ordem1, ordem2, ordem3, ponto1, ponto2, ponto3, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(trdap_teste_c[keysTrdapTesteC[ttc]].id || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].id_participante || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].codigo || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].data || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ordem1 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ordem2 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ordem3 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ponto1 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ponto2 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ponto3 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].total || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									$cordovaSQLite.execute(db, query);
									endereco_participante = participantes[participantesKeys[i]].endereco_participante;
									keysEnderecos = Object.keys(endereco_participante);
									qtdEnderecos = keysEnderecos.length;
									if(qtdEnderecos > 0){
										for (var end = 0; end < qtdEnderecos; end++) {
											query = 'INSERT INTO endereco (id, id_participante, cep, rua, numero, complemento, bairro, cidade, estado, pais, atualizacao) VALUES (?,?,?,?,?,?,?,?,?,?,?)';
											if(endereco_participante[keysEnderecos[end]] != null){
												data_Insert = [(endereco_participante[keysEnderecos[end]].id || ''), (endereco_participante[keysEnderecos[end]].id_participante || ''), (endereco_participante[keysEnderecos[end]].cep || ''), (endereco_participante[keysEnderecos[end]].rua || ''), (endereco_participante[keysEnderecos[end]].numero || ''), (endereco_participante[keysEnderecos[end]].complemento || ''), (endereco_participante[keysEnderecos[end]].bairro || ''), (endereco_participante[keysEnderecos[end]].cidade || ''), (endereco_participante[keysEnderecos[end]].estado || ''), (endereco_participante[keysEnderecos[end]].pais || ''), atualizacao];
												$cordovaSQLite.execute(db, query, data_Insert)
												.then(function(result) {
												}, function(error) {
												});
											}
										}
									}
								}
								$participantes = Data.getParticipantes();
								localStorage.setItem('participantes', JSON.stringify($participantes));
								localStorage.setItem('arrParticipantes', JSON.stringify(arrParticipantes));
								localStorage.setItem('arrResultado', JSON.stringify(arrResultado));
								localStorage.setItem('arrAcompanhante', JSON.stringify(arrAcompanhante));
								localStorage.setItem('arrAtributosParticipantes', JSON.stringify(arrAtributosParticipantes));
								localStorage.setItem('arrEndereco', JSON.stringify(arrEndereco));

							});
							$ionicPopup.alert({
					          title: 'Sincronização',
					          content: "Dados sincronizados com sucesso."
					        })
					        .then(function(result) {
					          if(result) {
					            $state.go('tabsController.participantesCtrl');
					          }
					        });
						}, function(error) {
						}, function() {
						});

					} else {
						$ionicPopup.alert({
				          title: 'Atenção',
				          content: data
				        })
				        .then(function(result) {
				          if(!result) {
				            // ionic.Platform.exitApp();
				          }
				        });
					}
					$ionicLoading.hide();
				}).error(function(data){
					$ionicPopup.alert({
			          title: 'Atenção',
			          content: "Falha na sincronização. Tente novamente mais tarde."
			        })
			        .then(function(result) {
			          if(!result) {
			            // ionic.Platform.exitApp();
			          }
			        });
					$ionicLoading.hide();
				});
			// $ionicLoading.hide();
		}, 1000);

	}

}]);
