var login = angular.module('login', ['ngCordova', 'ngMask']);
  
login.controller('loginCtrl', ['$scope', '$stateParams', '$state', '$cordovaSQLite', 'Data', '$ionicLoading', '$timeout', '$ionicHistory', '$ionicPopup', // The following is the constructor function for this page's controller. See https://docs.angularjs.org/guide/controller
// You can include any angular dependencies as parameters for this function
// TIP: Access Route Parameters for your page via $stateParams.parameterName
function ($scope, $stateParams, $state, $cordovaSQLite, Data, $ionicLoading, $timeout, $ionicHistory, $ionicPopup) {

	$scope.$root.tabsHidden = "";
	var id = localStorage.getItem('id');
	if(id != undefined){
		localStorage.clear();
	}

	$scope.loginUser = function(user)
	{
		if(user != undefined){
			if(user.login == undefined){
				$ionicPopup.alert({
		          title: 'Atenção',
		          content: "Informe o login."
		        })
		        .then(function(result) {
		        });
				$scope.focusElement = 'login';
			} else if (user.password == undefined){
				$ionicPopup.alert({
		          title: 'Atenção',
		          content: "Informe a senha."
		        })
		        .then(function(result) {
		        });
				$scope.focusElement = 'password';
			} else {
				if(!navigator.onLine){
					$ionicPopup.alert({
			          title: 'Sem conexão com a internet',
			          content: 'Desculpe, nenhuma conexão com a Internet foi detectada. Reconecte-se e tente novamente.'
			        });
					return false;
				}

				$ionicLoading.show({
					template: '<ion-spinner icon="bubbles"></ion-spinner><br />Aguarde, estamos reunindo informações.<br />Isso pode demorar um pouco',
				});
				Data.loginData(user).success(function(data)
				{
					if(!data.permission){
						$ionicPopup.alert({
				          title: 'Atenção',
				          content: data.error
				        })
				        .then(function(result) {
				        });
						$ionicLoading.hide();
					} else {
						localStorage.setItem('id', JSON.stringify(data.user.id));
						user.id = data.user.id;
						db = Data.getDatabase();

						var query = "DROP TABLE IF EXISTS acompanhante;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS atributos_participantes;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS endereco;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS mini_exame;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS participantes;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS reconhecimento_proverbios;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS resultado_trdap;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS trdap_teste_a;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS trdap_teste_b;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS trdap_teste_c;"
						$cordovaSQLite.execute(db, query);
						var query = "DROP TABLE IF EXISTS usuario";
						$cordovaSQLite.execute(db, query);
						
						var query = "CREATE TABLE IF NOT EXISTS acompanhante (id integer primary key, nome text, telefone text, id_participante integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS atributos_participantes (id integer primary key, id_participante integer, cursos integer, conveniencia integer, terapias integer, habito_leitura integer, habito_escrita integer, participacoes text, atividade_social integer, atividade_fisica integer, saude text, problema_memoria integer, int_cotidiano integer, mora text, escolaridade text, renda_mensal integer, demencia_diagnotic integer, dominancia text, religiao text, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS endereco (id integer primary key, id_participante integer, cep text, rua text, numero text, complemento text, bairro text, cidade text, estado text, pais text, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS mini_exame (id integer primary key, id_participante integer, codigo text, data date, orientacao_temporal integer, orientacao_espacial integer, memoria_imediata integer, atencao_calculo integer, memoria_evocacao integer, linguagem integer, total REAL, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS participantes (id integer primary key, id_usuario integer , id_pesquisador integer , nome text , data_nascimento date , idade integer , estado_civil text , profissao text , fone_fixo text , fone_celular text , email text , local_atend text , status integer , data_cadastro date, atualizacao date );"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS reconhecimento_proverbios (id integer primary key, id_participante integer, codigo text, reconhecimento1 integer, reconhecimento2 integer, reconhecimento3 integer, reconhecimento4 integer, reconhecimento5 integer, reconhecimento6 integer, data date, total REAL, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS resultado_trdap (id integer primary key, id_participante integer, data_inicio datetime, data_fim datetime, codigo text, status integer, total REAL, edita integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS trdap_teste_a (id integer primary key, id_participante integer, obs text, data date, codigo text, a_ordem1 integer, a_ordem2 integer, a_ordem3 integer, b_ordem1 integer, b_ordem2 integer, b_ordem3 integer, c_ordem1 integer, c_ordem2 integer, c_ordem3 integer, a_ponto1 integer, a_ponto2 integer, a_ponto3 integer, b_ponto1 integer, b_ponto2 integer, b_ponto3 integer, c_ponto1 integer, c_ponto2 integer, c_ponto3 integer, total REAL, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS trdap_teste_b (id integer primary key, id_participante integer, codigo text, data date, obs1 text, obs2 text, obs3 text, ponto1 integer, ponto2 integer, ponto3 integer, total REAL, obs4 text, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS trdap_teste_c (id integer primary key, id_participante integer, codigo text, data date, ordem1 integer, ordem2 integer, ordem3 integer, ponto1 integer, ponto2 integer, ponto3 integer, total REAL, status integer, atualizacao date);"
						$cordovaSQLite.execute(db, query);
						var query = "CREATE TABLE IF NOT EXISTS usuario (id integer primary key, data datetime , nome text , login text , senha text , email text , fone text , rua text , bairro text , cidade text , estado text , pais text , cep text , numero text , complemento text , profissao text , status integer , id_usuario integer , nivel integer , num_testes integer , atualizacao date);";
						$cordovaSQLite.execute(db, query);
						
						arrParticipantes = [];
						arrResultado = [];
						arrAcompanhante = [];
						arrAtributosParticipantes = [];
						arrEndereco = [];
						db.transaction(function(tx)
						{
							dataPupulate = Data.getData(user).success(function(info)
							{
								var atualizacao = getToday();
								localStorage.setItem('info', JSON.stringify(info));
								localStorage.setItem('total', info.total);
								localStorage.setItem('concluidos', info.concluidos);
								localStorage.setItem('cancelados', info.cancelados);
								var query = "DELETE FROM usuario";
								$cordovaSQLite.execute(db, query);
								var query = 'INSERT INTO usuario ( id, data, nome, login, senha, email, fone, rua, bairro, cidade, estado, pais, cep, numero, complemento, profissao, status, id_usuario, nivel, num_testes, atualizacao ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
									data_Insert = [(info.user[0].id || ''), (info.user[0].data || ''), (info.user[0].nome || ''), (info.user[0].login || ''), (info.user[0].senha || ''), (info.user[0].email || ''), (info.user[0].fone || ''), (info.user[0].rua || ''), (info.user[0].bairro || ''), (info.user[0].cidade || ''), (info.user[0].estado || ''), (info.user[0].pais || ''), (info.user[0].cep || ''), (info.user[0].numero || ''), (info.user[0].complemento || ''), (info.user[0].profissao || ''), (info.user[0].status || ''), (info.user[0].id_usuario || ''), (info.user[0].nivel || ''), (info.user[0].num_testes || ''), atualizacao];
								$cordovaSQLite.execute(db, query, data_Insert)
								.then(function(result) {
								}, function(error) {
								}); 
								participantes = info.participantes;
								participantesKeys = Object.keys(participantes),
								qtdParticipantes = participantesKeys.length;
								var query = "DELETE FROM participantes";
								$cordovaSQLite.execute(db, query);
								for (var i = 0; i < qtdParticipantes; i++) {
									query = 'INSERT INTO participantes ( id, id_usuario, id_pesquisador, nome, data_nascimento, idade, estado_civil, profissao, fone_fixo, fone_celular, email, local_atend, status, data_cadastro, atualizacao)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ';
									dataInsertParticipante = [participantes[participantesKeys[i]].id, (participantes[participantesKeys[i]].id_usuario || ''), (participantes[participantesKeys[i]].id_pesquisador || ''), (participantes[participantesKeys[i]].nome || ''), (participantes[participantesKeys[i]].data_nascimento || ''), (participantes[participantesKeys[i]].idade || ''), (participantes[participantesKeys[i]].estado_civil || ''), (participantes[participantesKeys[i]].profissao || ''), (participantes[participantesKeys[i]].fone_fixo || ''), (participantes[participantesKeys[i]].fone_celular || ''), (participantes[participantesKeys[i]].email || ''), (participantes[participantesKeys[i]].local_atend || ''), (participantes[participantesKeys[i]].status || ''), (participantes[participantesKeys[i]].data_cadastro || ''), atualizacao];
									$cordovaSQLite.execute(db, query, dataInsertParticipante); 
									arrParticipantes.push({'id': participantes[participantesKeys[i]].id, 'nome' : participantes[participantesKeys[i]].nome});
									acompanhante = participantes[participantesKeys[i]].acompanhante;
									acompanhanteKeys = Object.keys(acompanhante),
									qtdAcompanhante = acompanhanteKeys.length;
									$cordovaSQLite.execute(db, query);
									if(qtdAcompanhante > 0){
										for (var ac = 0; ac < qtdAcompanhante; ac++) {
											query = 'INSERT INTO acompanhante (id , nome , telefone , id_participante, atualizacao) VALUES(? ,? ,? ,?, ?)';
											data_Insert = [(acompanhante[acompanhanteKeys[ac]].id || ''), (acompanhante[acompanhanteKeys[ac]].nome || ''), (acompanhante[acompanhanteKeys[ac]].telefone || ''), (acompanhante[acompanhanteKeys[ac]].id_participante || ''), atualizacao];
											arrAcompanhante[acompanhante[acompanhanteKeys[ac]].id] = {'id' : acompanhante[acompanhanteKeys[ac]].id , 'nome' : acompanhante[acompanhanteKeys[ac]].nome , 'telefone' : acompanhante[acompanhanteKeys[ac]].telefone , 'id_participante' : acompanhante[acompanhanteKeys[ac]].id_participante};
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}
									
									atributos_participantes = participantes[participantesKeys[i]].atributos_participantes;
									keysAtributosAcompanhante = Object.keys(atributos_participantes);
									qtdAtributosAcompanhante = keysAtributosAcompanhante.length;
									if(qtdAtributosAcompanhante > 0){
										for (var aa = 0; aa < qtdAtributosAcompanhante; aa++) {
											query = 'INSERT INTO atributos_participantes ( id, id_participante, cursos, conveniencia, terapias, habito_leitura, habito_escrita, participacoes, atividade_social, atividade_fisica, saude, problema_memoria, int_cotidiano, mora, escolaridade, renda_mensal, demencia_diagnotic, dominancia, religiao, atualizacao) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
											data_Insert = [(atributos_participantes[keysAtributosAcompanhante[aa]].id || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].id_participante || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].cursos || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].conveniencia || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].terapias || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].habito_leitura || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].habito_escrita || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].participacoes || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].atividade_social || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].atividade_fisica || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].saude || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].problema_memoria || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].int_cotidiano || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].mora || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].escolaridade || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].renda_mensal || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].demencia_diagnotic || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].dominancia || ''),(atributos_participantes[keysAtributosAcompanhante[aa]].religiao || ''), atualizacao];
											arrAtributosParticipantes[atributos_participantes[keysAtributosAcompanhante[aa]].id] = {'id' : atributos_participantes[keysAtributosAcompanhante[aa]].id ,'id_participante' : atributos_participantes[keysAtributosAcompanhante[aa]].id_participante ,'cursos' : atributos_participantes[keysAtributosAcompanhante[aa]].cursos ,'conveniencia' : atributos_participantes[keysAtributosAcompanhante[aa]].conveniencia ,'terapias' : atributos_participantes[keysAtributosAcompanhante[aa]].terapias ,'habito_leitura' : atributos_participantes[keysAtributosAcompanhante[aa]].habito_leitura ,'habito_escrita' : atributos_participantes[keysAtributosAcompanhante[aa]].habito_escrita ,'participacoes' : atributos_participantes[keysAtributosAcompanhante[aa]].participacoes ,'atividade_social' : atributos_participantes[keysAtributosAcompanhante[aa]].atividade_social ,'atividade_fisica' : atributos_participantes[keysAtributosAcompanhante[aa]].atividade_fisica ,'saude' : atributos_participantes[keysAtributosAcompanhante[aa]].saude ,'problema_memoria' : atributos_participantes[keysAtributosAcompanhante[aa]].problema_memoria ,'int_cotidiano' : atributos_participantes[keysAtributosAcompanhante[aa]].int_cotidiano ,'mora' : atributos_participantes[keysAtributosAcompanhante[aa]].mora ,'escolaridade' : atributos_participantes[keysAtributosAcompanhante[aa]].escolaridade ,'renda_mensal' : atributos_participantes[keysAtributosAcompanhante[aa]].renda_mensal ,'demencia_diagnotic' : atributos_participantes[keysAtributosAcompanhante[aa]].demencia_diagnotic ,'dominancia' : atributos_participantes[keysAtributosAcompanhante[aa]].dominancia ,'religiao' : atributos_participantes[keysAtributosAcompanhante[aa]].religiao};
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}
									
									endereco_participante = participantes[participantesKeys[i]].endereco_participante;
									keysAtributosAcompanhante = Object.keys(endereco_participante);
									qtdAtributosAcompanhante = keysAtributosAcompanhante.length;
									if(endereco_participante.length > 0){
										for (var aa = 0; aa < qtdAtributosAcompanhante; aa++) {
											query = 'INSERT INTO endereco ( id, id_participante, cep, rua, numero, complemento, bairro, cidade, estado, pais, atualizacao) VALUES (?,?,?,?,?,?,?,?,?,?,?)';
											data_Insert = [(endereco_participante[keysAtributosAcompanhante[aa]].id || ''), (endereco_participante[keysAtributosAcompanhante[aa]].id_participante || ''), (endereco_participante[keysAtributosAcompanhante[aa]].cep || ''), (endereco_participante[keysAtributosAcompanhante[aa]].rua || ''), (endereco_participante[keysAtributosAcompanhante[aa]].numero || ''), (endereco_participante[keysAtributosAcompanhante[aa]].complemento || ''), (endereco_participante[keysAtributosAcompanhante[aa]].bairro || ''), (endereco_participante[keysAtributosAcompanhante[aa]].cidade || ''), (endereco_participante[keysAtributosAcompanhante[aa]].estado || ''), (endereco_participante[keysAtributosAcompanhante[aa]].pais || ''), atualizacao];
											arrEndereco[endereco_participante[keysAtributosAcompanhante[aa]].id] = {'id': endereco_participante[keysAtributosAcompanhante[aa]].id , 'id_participante': endereco_participante[keysAtributosAcompanhante[aa]].id_participante , 'cep': endereco_participante[keysAtributosAcompanhante[aa]].cep , 'rua': endereco_participante[keysAtributosAcompanhante[aa]].rua , 'numero': endereco_participante[keysAtributosAcompanhante[aa]].numero , 'complemento': endereco_participante[keysAtributosAcompanhante[aa]].complemento , 'bairro': endereco_participante[keysAtributosAcompanhante[aa]].bairro , 'cidade': endereco_participante[keysAtributosAcompanhante[aa]].cidade , 'estado': endereco_participante[keysAtributosAcompanhante[aa]].estado , 'pais': endereco_participante[keysAtributosAcompanhante[aa]].pais };
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}
									
									mini_exames = participantes[participantesKeys[i]].mini_exames;
									keysMiniExames = Object.keys(mini_exames);
									qtdMiniExames = keysMiniExames.length;
									if(qtdMiniExames > 0){
										for (var me = 0; me < qtdMiniExames; me++) {
											query = 'INSERT INTO mini_exame (id, id_participante, codigo, data, orientacao_temporal, orientacao_espacial, memoria_imediata, atencao_calculo, memoria_evocacao, linguagem, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(mini_exames[keysMiniExames[me]].id || ''), (mini_exames[keysMiniExames[me]].id_participante || ''), (mini_exames[keysMiniExames[me]].codigo || ''), (mini_exames[keysMiniExames[me]].data || ''), (mini_exames[keysMiniExames[me]].orientacao_temporal || ''), (mini_exames[keysMiniExames[me]].orientacao_espacial || ''), (mini_exames[keysMiniExames[me]].memoria_imediata || ''), (mini_exames[keysMiniExames[me]].atencao_calculo || ''), (mini_exames[keysMiniExames[me]].memoria_evocacao || ''), (mini_exames[keysMiniExames[me]].linguagem || ''), (mini_exames[keysMiniExames[me]].total || ''), (mini_exames[keysMiniExames[me]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									reconhecimento_proverbios = participantes[participantesKeys[i]].reconhecimento_proverbios;
									keysReconhecimentoProverbios = Object.keys(reconhecimento_proverbios);
									qtdReconhecimentoProverbios = keysReconhecimentoProverbios.length;
									if(qtdReconhecimentoProverbios > 0){
										for (var rp = 0; rp < qtdReconhecimentoProverbios; rp++) {
											query = 'INSERT INTO reconhecimento_proverbios (id, id_participante, codigo, reconhecimento1, reconhecimento2, reconhecimento3, reconhecimento4, reconhecimento5, reconhecimento6, data, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].id || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].id_participante || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].codigo || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto1 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto2 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto3 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto4 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto5 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].reconhecirpnto6 || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].data || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].total || ''), (reconhecimento_proverbios[keysReconhecimentoProverbios[rp]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									resultado_trdap = participantes[participantesKeys[i]].resultado_trdap;
									keysResultadoTrdap = Object.keys(resultado_trdap);
									qtdResultadoTrdap = keysResultadoTrdap.length;
									if(qtdResultadoTrdap > 0){
										for (var rt = 0; rt < qtdResultadoTrdap; rt++) {
											query = 'INSERT INTO resultado_trdap (id, id_participante, data_inicio, data_fim, codigo, status, total, edita, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)',
											data_Insert = [(resultado_trdap[keysResultadoTrdap[rt]].id || ''), (resultado_trdap[keysResultadoTrdap[rt]].id_participante || ''), (resultado_trdap[keysResultadoTrdap[rt]].data_inicio || ''), (resultado_trdap[keysResultadoTrdap[rt]].data_fim || ''), (resultado_trdap[keysResultadoTrdap[rt]].codigo || ''), (resultado_trdap[keysResultadoTrdap[rt]].status || ''), (resultado_trdap[keysResultadoTrdap[rt]].total || ''), (resultado_trdap[keysResultadoTrdap[rt]].edita || ''), atualizacao];
											var id_participante = participantes[participantesKeys[i]].id;
											arrResultado[resultado_trdap[keysResultadoTrdap[rt]].id] = {'id': resultado_trdap[keysResultadoTrdap[rt]].id, 'id_participante': resultado_trdap[keysResultadoTrdap[rt]].id_participante, 'data_inicio': resultado_trdap[keysResultadoTrdap[rt]].data_inicio, 'data_fim': resultado_trdap[keysResultadoTrdap[rt]].data_fim, 'codigo': resultado_trdap[keysResultadoTrdap[rt]].codigo, 'status': resultado_trdap[keysResultadoTrdap[rt]].status, 'total': resultado_trdap[keysResultadoTrdap[rt]].total, 'tempo': Data.dateDiff(resultado_trdap[keysResultadoTrdap[rt]].data_fim, resultado_trdap[keysResultadoTrdap[rt]].data_inicio)};
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}

									trdap_teste_a = participantes[participantesKeys[i]].trdap_teste_a;
									keysTrdapTesteA = Object.keys(trdap_teste_a);
									qtdTrdapTesteA = keysTrdapTesteA.length;
									if(qtdTrdapTesteA > 0){
										for (var tta = 0; tta < qtdTrdapTesteA; tta++) {
											query = 'INSERT INTO trdap_teste_a (id, id_participante, obs, data, codigo, a_ordem1, a_ordem2, a_ordem3, b_ordem1, b_ordem2, b_ordem3, c_ordem1, c_ordem2, c_ordem3, a_ponto1, a_ponto2, a_ponto3, b_ponto1, b_ponto2, b_ponto3, c_ponto1, c_ponto2, c_ponto3, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(trdap_teste_a[keysTrdapTesteA[tta]].id || ''), (trdap_teste_a[keysTrdapTesteA[tta]].id_participante || ''), (trdap_teste_a[keysTrdapTesteA[tta]].obs || ''), (trdap_teste_a[keysTrdapTesteA[tta]].data || ''), (trdap_teste_a[keysTrdapTesteA[tta]].codigo || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ordem1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ordem2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ordem3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ordem1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ordem2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ordem3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ordem1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ordem2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ordem3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ponto1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ponto2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].a_ponto3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ponto1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ponto2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].b_ponto3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ponto1 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ponto2 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].c_ponto3 || ''), (trdap_teste_a[keysTrdapTesteA[tta]].total || ''), (trdap_teste_a[keysTrdapTesteA[tta]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}
									
									trdap_teste_b = participantes[participantesKeys[i]].trdap_teste_b;
									keysTrdapTesteB = Object.keys(trdap_teste_b);
									qtdTrdapTesteB = keysTrdapTesteB.length;
									if(qtdTrdapTesteB > 0){
										for (var ttb = 0; ttb < qtdTrdapTesteB; ttb++) {
											query = 'INSERT INTO trdap_teste_b (id, id_participante, codigo, data, obs1, obs2, obs3, ponto1, ponto2, ponto3, total, obs4, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(trdap_teste_b[keysTrdapTesteB[ttb]].id || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].id_participante || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].codigo || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].data || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].obs1 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].obs2 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].obs3 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].ponto1 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].ponto2 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].ponto3 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].total || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].obs4 || ''), (trdap_teste_b[keysTrdapTesteB[ttb]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}
									
									trdap_teste_c = participantes[participantesKeys[i]].trdap_teste_c;
									keysTrdapTesteC = Object.keys(trdap_teste_c);
									qtdTrdapTesteC = keysTrdapTesteC.length;
									if(qtdTrdapTesteC > 0){
										for (var ttc = 0; ttc < qtdTrdapTesteC; ttc++) {
											query = 'INSERT INTO trdap_teste_c (id, id_participante, codigo, data, ordem1, ordem2, ordem3, ponto1, ponto2, ponto3, total, status, atualizacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
											data_Insert = [(trdap_teste_c[keysTrdapTesteC[ttc]].id || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].id_participante || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].codigo || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].data || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ordem1 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ordem2 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ordem3 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ponto1 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ponto2 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].ponto3 || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].total || ''), (trdap_teste_c[keysTrdapTesteC[ttc]].status || ''), atualizacao];
											$cordovaSQLite.execute(db, query, data_Insert)
											.then(function(result) {
											}, function(error) {
											}); 
										}
									}
									
									endereco_participante = participantes[participantesKeys[i]].endereco_participante;
									keysEnderecos = Object.keys(endereco_participante);
									qtdEnderecos = keysEnderecos.length;
									if(qtdEnderecos > 0){
										for (var end = 0; end < qtdEnderecos; end++) {
											query = 'INSERT INTO endereco (id, id_participante, cep, rua, numero, complemento, bairro, cidade, estado, pais, atualizacao) VALUES (?,?,?,?,?,?,?,?,?,?,?)';
											if(endereco_participante[keysEnderecos[end]] != null){
												data_Insert = [(endereco_participante[keysEnderecos[end]].id || ''), (endereco_participante[keysEnderecos[end]].id_participante || ''), (endereco_participante[keysEnderecos[end]].cep || ''), (endereco_participante[keysEnderecos[end]].rua || ''), (endereco_participante[keysEnderecos[end]].numero || ''), (endereco_participante[keysEnderecos[end]].complemento || ''), (endereco_participante[keysEnderecos[end]].bairro || ''), (endereco_participante[keysEnderecos[end]].cidade || ''), (endereco_participante[keysEnderecos[end]].estado || ''), (endereco_participante[keysEnderecos[end]].pais || ''), atualizacao];
												$cordovaSQLite.execute(db, query, data_Insert)
												.then(function(result) {
												}, function(error) {
												});
											}
										}
									}
								}

							});
						}, function(error) {
						}, function() {
						});

						redir = $timeout(function() {
							$ionicLoading.hide();
							var today = getToday();
							localStorage.setItem('sync', addSencondForToday(today));
							localStorage.setItem('arrParticipantes', JSON.stringify(arrParticipantes));
							$state.transitionTo('tabsController.participantes', null, {reload: true, notify:true});
							$state.go('tabsController.adicionarParticipante');
						}, 9000);
					}
				}).error(function(error){
					if(!navigator.onLine){
						$ionicPopup.alert({
				          title: 'Atenção',
				          content: error
				        })
				        .then(function(result) {
				        });
						return false;
					}
					$ionicLoading.hide();
				});
			}
		} else {
			if(!navigator.onLine){
				$ionicPopup.alert({
		          title: 'Atenção',
		          content: "Informe o login e senha."
		        })
		        .then(function(result) {
		        });
				return false;
			}
			$scope.focusElement = 'login';
		}
	}

}])
 