<?php

require_once('RsCorreios.php');

// Instancia a classe
$frete = new RsCorreios();

// Percorre todos as variáveis $_POST para setar os atributos necessários
// Se você achar melhor pode fazer 1 a 1.
// Ex.: $frete->setValue('sCepOrigem', $_POST['sCepOrigem']);
// Aqui estou usando um foreach para economizar código
foreach ($_POST as $key => $value) {
    $frete->setValue($key, $value);
}

// Diâmetro
$frete->getDiametro();

// Chamado ao método getFrete, que irá se comunicar com os correios
// e nos trazer o resultado
$result = $frete->getFrete();


// Retornamos a mensagem de erro caso haja alguma falha
if ($result['erro'] != 0) {
    $resultadoFrete = $result['msg_erro'];
}
// Caso não haja erros mostramos o resultado de cada variável retornada pelos correios.
// Use apenas as que forem de seu interesse
else {
	
	$resultadoFrete = "Código do Serviço: " . $result['servico_codigo'] . "<br />";
	$resultadoFrete .= "Valor do Frete: R$ " . $result['valor'] . "<br />";
	$resultadoFrete .= "Prazo de Entrega: " . $result['prazo_entrega'] . " dias <br />";
	$resultadoFrete .= "Valor p/ Mão Própria: R$ " . $result['mao_propria'] . "<br />";
	$resultadoFrete .= "Valor Aviso de Recebimento: R$ " . $result['aviso_recebimento'] . "<br />";
	$resultadoFrete .= "Valor Declarado: R$ " . $result['valor_declarado'] . "<br />";
	$resultadoFrete .= "Entrega Domiciliar: " . $result['en_domiciliar'] . "<br />";
	$resultadoFrete .= "Entrega Sábado: " . $result['en_sabado'] . "<br />";
}


?>

<div id="executaCompra" style="width:700px; height: 200px; border: 0px solid; float: left; margin: 15px 0 0 0;">

           
	<div class="boxTituloFrete">        
	    <div class="titleIntGer"><h1>COMPRA TESTE</h1></div>
	</div>


<div class="textoFinalPac"><b>Plano:</b> Pacote de <?=$_REQUEST['pacote']?> testes</div>
<div class="textoFinalPac"><b>Valor do Pacote de Testes:</b> R$ <?=$_REQUEST['valor']?></div>
<div class="textoFinalPac"><b>Valor do frete:</b> R$ <?=$result['valor']?></div>
<div class="textoFinalPac"><b>Total a pagar:</b> R$ <?=number_format($result['valor']+$_REQUEST['valor'],2,'.',',')?></div>
<div class="textoFinalPac"><b>Prazo de entrega:</b> <?=$result['prazo_entrega']?> dias </div>
<div class="textoFinalPac"><b>Atenção: Após a confirmação do pagamento, seu Pacote de Testes será liberado em até 24h.</b></div>
</div>

<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">
	<input type="hidden" name="cmd" value="_xclick">
	<input type="hidden" name="business" value="497YQMNN4RXXU">
	<input type="hidden" name="lc" value="BR">
	<input type="hidden" name="item_name" value="Pacote de <?=$_REQUEST['pacote']?> testes"> <!-- nome do produto -->
	<input type="hidden" name="item_number" value="<?=$_REQUEST['codigo']?>"> <!-- codigo do produto -->
	<input type="hidden" name="amount" value="<?=$result['valor']+$_REQUEST['valor']?>"> <!-- valor do produto -->
	<input type="hidden" name="currency_code" value="BRL">
	<input type="hidden" name="button_subtype" value="services">							
	<input type="hidden" name="no_note" value="0">
	<input type="hidden" name="cn" value="Adicionar instruções especiais para o vendedor:">
	<input type="hidden" name="no_shipping" value="2">
	<input type="hidden" name="undefined_quantity" value="1">
	<input type="hidden" name="bn" value="PP-BuyNowBF:btn_buynowCC_LG.gif:NonHosted">	
	 <input type="submit" class="linkIn c-verde botaoCalFrete" src="https://www.paypalobjects.com/pt_BR/BR/i/btn/btn_buynowCC_LG.gif" border="0" value="Comprar" name="submit" alt="PayPal - A maneira mais fácil e segura de efetuar pagamentos online!">	
</form>
