<?php
/**
 * AUTOLOADER SIMPLES PARA PHP 5.3
 * Substitui o Composer para bibliotecas básicas
 */

// Verificar versão PHP
if (version_compare(PHP_VERSION, '5.3.0', '<')) {
    die('PHP 5.3+ é necessário');
}

// Função para autoload simplificada
function simple_autoload($class) {
    // Converter namespace para caminho
    $file = str_replace('\\', '/', $class) . '.php';
    
    // Procurar em diretórios possíveis
    $paths = array(
        'vendor/', 
        'libs/',
        'classes/',
        ''
    );
    
    foreach ($paths as $path) {
        $full_path = $path . $file;
        if (file_exists($full_path)) {
            require_once $full_path;
            return true;
        }
    }
    
    return false;
}

// Registrar autoloader
spl_autoload_register('simple_autoload');

// Carregar bibliotecas essenciais se existirem
$essential_libs = array(
    'vendor/autoload.php',  // Se existir
    'FPDF/fpdf.php',       // FPDF
    'libs/classe_querys.php', // Classes principais
);

foreach ($essential_libs as $lib) {
    if (file_exists($lib) && $lib !== 'vendor/autoload.php') {
        require_once $lib;
    }
}

?>
