<?php
/**
 * VERIFICAÇÃO PHP 8 - DEPLOY CONFIRMATION
 */

echo "<h1>🎉 VERIFICAÇÃO PHP 8 - TRDAP DEPLOY</h1>";

// Informações básicas
echo "<h2>📊 Informações do Servidor:</h2>";
echo "<p><strong>Versão PHP:</strong> " . PHP_VERSION . "</p>";
echo "<p><strong>Data/Hora:</strong> " . date('Y-m-d H:i:s T') . "</p>";
echo "<p><strong>Sistema Operacional:</strong> " . PHP_OS . "</p>";
echo "<p><strong>Servidor:</strong> " . $_SERVER['SERVER_SOFTWARE'] . "</p>";

// Status das extensões importantes
echo "<h2>🔧 Extensões PHP 8:</h2>";
$extensions = array(
    'session' => 'Sessões',
    'json' => 'JSON',
    'mbstring' => 'Multibyte String',
    'curl' => 'cURL',
    'mysqli' => 'MySQLi',
    'zip' => 'ZIP',
    'gd' => 'GD Library',
    'phar' => 'PHAR',
    'fileinfo' => 'Fileinfo'
);

foreach ($extensions as $ext => $desc) {
    if (extension_loaded($ext)) {
        echo "<p>✅ <strong>$desc ($ext):</strong> Disponível</p>";
    } else {
        echo "<p>❌ <strong>$desc ($ext):</strong> Não disponível</p>";
    }
}

// Verificar Composer
echo "<h2>📦 Status do Composer:</h2>";
if (file_exists('vendor/autoload.php')) {
    try {
        require_once 'vendor/autoload.php';
        echo "<p>✅ <strong>Composer:</strong> Funcionando perfeitamente!</p>";
        
        // Testar bibliotecas principais
        if (class_exists('PhpOffice\PhpSpreadsheet\Spreadsheet')) {
            echo "<p>✅ <strong>PhpSpreadsheet:</strong> Disponível</p>";
        }
        
        if (class_exists('Dompdf\Dompdf')) {
            echo "<p>✅ <strong>DomPDF:</strong> Disponível</p>";
        }
        
    } catch (Exception $e) {
        echo "<p>⚠️ <strong>Composer:</strong> Erro: " . htmlspecialchars($e->getMessage()) . "</p>";
    }
} else {
    echo "<p>❌ <strong>Composer:</strong> Pasta vendor/ não encontrada</p>";
}

// Testes de funcionalidade
echo "<h2>🧪 Testes de Funcionalidade:</h2>";

// Teste 1: Sessões
session_start();
$_SESSION['test'] = 'PHP 8 funcionando!';
if (isset($_SESSION['test']) && $_SESSION['test'] === 'PHP 8 funcionando!') {
    echo "<p>✅ <strong>Sessões:</strong> Funcionando</p>";
} else {
    echo "<p>❌ <strong>Sessões:</strong> Problema</p>";
}

// Teste 2: JSON
$test_data = array('test' => 'PHP 8', 'status' => 'OK');
$json = json_encode($test_data);
$decoded = json_decode($json, true);
if ($decoded['test'] === 'PHP 8') {
    echo "<p>✅ <strong>JSON:</strong> Funcionando</p>";
} else {
    echo "<p>❌ <strong>JSON:</strong> Problema</p>";
}

// Teste 3: Includes do projeto
echo "<h2>📁 Arquivos do Projeto:</h2>";
$arquivos_teste = array(
    'index.php' => 'Página Principal',
    'contato.php' => 'Página de Contato',
    'cadastroSite.php' => 'Página de Cadastro',
    'includes/header.php' => 'Header',
    'libs/classe_querys.php' => 'Classes Principais'
);

foreach ($arquivos_teste as $arquivo => $desc) {
    if (file_exists($arquivo)) {
        echo "<p>✅ <strong>$desc:</strong> Disponível</p>";
    } else {
        echo "<p>❌ <strong>$desc:</strong> Não encontrado</p>";
    }
}

echo "<h2>🎯 PRÓXIMOS PASSOS:</h2>";
echo "<p>✅ <a href='index.php'>Teste o Site Principal</a></p>";
echo "<p>✅ <a href='contato.php'>Teste Página de Contato</a></p>";
echo "<p>✅ <a href='cadastroSite.php'>Teste Página de Cadastro</a></p>";

echo "<hr>";
echo "<p><small>Verificação executada em: " . date('Y-m-d H:i:s') . "</small></p>";

?>
