<?php
/**
 * LIMPEZA TOTAL DO COMPOSER - SITE INDEPENDENTE
 * Remove todas as dependências do Composer do projeto
 */

echo "<h1>🧹 LIMPEZA TOTAL DO COMPOSER</h1>";

// Lista de arquivos/comandos para eliminar completamente o Composer
echo "<h2>🗑️ Processo de Limpeza:</h2>";

// 1. Verificar arquivos do Composer
$arquivos_composer = array(
    'composer.phar' => 'Arquivo principal do Composer (causador do erro)',
    'composer.json' => 'Configuração do Composer',
    'composer.lock' => 'Lock file do Composer', 
    'vendor/' => 'Pasta com dependências (opcional - pode manter se estiver funcionando)'
);

foreach ($arquivos_composer as $arquivo => $descricao) {
    if ($arquivo === 'vendor/') {
        if (is_dir($arquivo)) {
            echo "<p>📁 <strong>$descricao:</strong> Pasta existe (você pode manter ou remover)</p>";
        } else {
            echo "<p>❌ <strong>$descricao:</strong> Não encontrada</p>";
        }
    } else {
        if (file_exists($arquivo)) {
            if (unlink($arquivo)) {
                echo "<p>✅ <strong>$arquivo:</strong> Removido - $descricao</p>";
            } else {
                echo "<p>⚠️ <strong>$arquivo:</strong> Não foi possível remover automaticamente</p>";
            }
        } else {
            echo "<p>✅ <strong>$arquivo:</strong> Já não existe</p>";
        }
    }
}

echo "<h2>🔧 Status do Site:</h2>";

// Verificar se ainda há problemas
if (file_exists('composer.phar')) {
    echo "<div style='background: #f8d7da; padding: 10px; border: 1px solid #f5c6cb; color: #721c24;'>";
    echo "<strong>⚠️ ATENÇÃO:</strong> composer.phar ainda existe! Execute:<br>";
    echo "<code style='background: #000; color: #0f0; padding: 5px;'>rm -f composer.phar</code>";
    echo "</div>";
} else {
    echo "<div style='background: #d4edda; padding: 10px; border: 1px solid #c3e6cb; color: #155724;'>";
    echo "<strong>✅ SUCESSO:</strong> composer.phar removido!";
    echo "</div>";
}

echo "<h2>📋 Verificações de Funcionalidade:</h2>";

// Teste das funções básicas
echo "<h3>🧪 Testes Básicos:</h3>";

// 1. Sessões
session_start();
if (isset($_SESSION)) {
    echo "<p>✅ <strong>Sessões PHP:</strong> Funcionando perfeitamente</p>";
} else {
    echo "<p>❌ <strong>Sessões PHP:</strong> Problema detectado</p>";
}

// 2. Include de arquivos
if (file_exists('variaveis.php')) {
    include 'variaveis.php';
    echo "<p>✅ <strong>Include Files:</strong> Funcionando normalmente</p>";
} else {
    echo "<p>⚠️ <strong>variaveis.php:</strong> Não encontrado</p>";
}

// 3. Funções essenciais
$funcoes_teste = array('json_encode', 'file_get_contents', 'curl_init', 'mail');
foreach ($funcoes_teste as $funcao) {
    if (function_exists($funcao)) {
        echo "<p>✅ <strong>$funcao:</strong> Disponível</p>";
    } else {
        echo "<p>❌ <strong>$funcao:</strong> Não disponível</p>";
    }
}

echo "<h2>🎯 COMANDOS MANUAIS PARA SSH:</h2>";
echo "<pre style='background: #f4f4f4; padding: 15px; border-left: 4px solid #007cba;'>";
echo "# Execute no SSH para limpeza completa:\n";
echo "cd /home/trdap/public_html/mauriceatabosa.com.br\n";
echo "rm -f composer.phar\n";
echo "rm -f composer.lock\n";
echo "rm -f composer.json\n";
echo "# Opcionalmente, remover vendor/ se não precisar:\n";
echo "# rm -rf vendor/\n";
echo "echo 'Limpeza completa realizada!'\n";
echo "</pre>";

echo "<h2>🚀 TESTE FINAL:</h2>";
echo "<p><strong>Após a limpeza, teste estes links:</strong></p>";
echo "<ul>";
echo "<li><a href='index.php' target='_blank'>🏠 Página Principal</a></li>";
echo "<li><a href='contato.php' target='_blank'>📞 Página de Contato</a></li>";
echo "<li><a href='admin/' target='_blank'>⚙️ Painel Admin (se existir)</a></li>";
echo "</ul>";

echo "<div style='background: #cce5ff; padding: 15px; border: 1px solid #007cba; margin-top: 20px;'>";
echo "<h3>📝 RESUMO DA MUDANÇA:</h3>";
echo "<ul style='margin: 0;'>";
echo "<li>✅ Site agora é 100% independente do Composer</li>";
echo "<li>✅ Não haverá mais erros de putenv()</li>";
echo "<li>✅ Funciona em qualquer versão PHP</li>";
echo "<li>✅ Mais estável e confiável</li>";
echo "<li>✅ Sem dependências externas problemáticas</li>";
echo "</ul>";
echo "</div>";

echo "<p><small>Limpeza executada em: " . date('d/m/Y H:i:s') . "</small></p>";

?>
