<?php
// include_once($_SERVER['DOCUMENT_ROOT'].'/error/handleError.php'); // Arquivo não existe
class Query{
	
	private $conecta;
	private $conexao;
	

	function logar(){
		// Usar banco local com backup importado
		$configs = [
			// Configuração local (prioridade)
			['host' => '127.0.0.1', 'db' => 'trdap_local', 'user' => 'root', 'pass' => ''],
			// Configuração de produção (fallback)
			['host' => '216.245.196.214', 'db' => 'trdap_pix3', 'user' => 'trdap_pix3', 'pass' => 'mud4rs3nh4']
		];
		
		$connected = false;
		foreach ($configs as $config) {
			try {
				$this->conexao = 'mysql:host='.$config['host'].';dbname='.$config['db'];
				$this->conecta = new PDO($this->conexao, $config['user'], $config['pass']);
				$this->conecta->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
				$connected = true;
				
				// Se for banco local, criar estrutura básica
				if ($config['host'] === '127.0.0.1') {
					$this->criarEstruturaLocal();
				}
				
				break;
			} catch (PDOexception $error_conecta) {
				continue; // Tentar próxima configuração
			}
		}
		
		if (!$connected) {
			echo htmlentities('Erro ao conectar com qualquer banco de dados');
			die("Erro ao conectar com o Banco!");
		}
	}
	
	private function criarEstruturaLocal() {
		try {
			// Criar banco se não existir
			$this->conecta->exec("CREATE DATABASE IF NOT EXISTS trdap_local CHARACTER SET utf8 COLLATE utf8_general_ci");
			$this->conecta->exec("USE trdap_local");
			
			// Criar tabela de usuários básica
			$sql = "CREATE TABLE IF NOT EXISTS usuario (
				id INT AUTO_INCREMENT PRIMARY KEY,
				nome VARCHAR(100),
				login VARCHAR(50),
				senha VARCHAR(100),
				email VARCHAR(100),
				nivel INT DEFAULT 1,
				status INT DEFAULT 1,
				data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP
			)";
			$this->conecta->exec($sql);
			
			// Inserir usuário de teste
			$stmt = $this->conecta->prepare("SELECT COUNT(*) FROM usuario WHERE login = 'admin'");
			$stmt->execute();
			if ($stmt->fetchColumn() == 0) {
				$stmt = $this->conecta->prepare("INSERT INTO usuario (nome, login, senha, email, nivel) VALUES (?, ?, ?, ?, ?)");
				$stmt->execute(['Administrador', 'admin', 'admin123', 'admin@teste.com', 1]);
			}
			
		} catch (Exception $e) {
			// Ignorar erros na criação da estrutura local
		}
	}

	
	function procurarAdmin($tabela,$login,$senha){		
	
		$sql_select = 'SELECT * FROM '.$tabela.' where login = "'.$login.'" and senha = "'.$senha.'"';
		//die($sql_select);			
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$resultado_query = $query_select->fetchAll(PDO::FETCH_ASSOC);
			$count = $query_select->rowCount();	
			if($count == '0'){
			// echo '<h2 class="f28"><strong class="cinza1">OPS!!&nbsp;</strong> <strong class="vermelho">NADA FOI ENCONTRADO.</strong></h2>';
			}	
		} catch (PDOexception $error_select){
			echo 'Erro ao selecionar'.$error_select->getMessage();
		}

		return($resultado_query);
	}

	function procurar($tabela,$nivel=null,$id_usuario=null){		
	
		$sql_select = 'SELECT * FROM '.$tabela.' ';

		if($nivel != null && $id_usuario != null){
			$sql_select .= 'WHERE nivel="'.$nivel.'" AND id_usuario="'.$id_usuario.'" ';	
		}			
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$resultado_query = $query_select->fetchAll(PDO::FETCH_ASSOC);
			$count = $query_select->rowCount();	
			return($resultado_query);	
		} catch (PDOexception $error_select){
			die('Erro ao selecionar'.$error_select->getMessage());
		}		

	}

	function procurarOutros($tabela,$id){		
	
		$sql_select = 'SELECT * FROM '.$tabela.' ';
		$sql_select .= 'WHERE id !="'.$id.'" ';	
					
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$resultado_query = $query_select->fetchAll(PDO::FETCH_ASSOC);
			$count = $query_select->rowCount();	
			return($resultado_query);	
		} catch (PDOexception $error_select){
			die('Erro ao selecionar'.$error_select->getMessage());
		}		

	}

	function procurarEmail($tabela,$email,$senha){		
	
		$sql_select = 'SELECT * FROM '.$tabela.' where email = "'.$email.'"';
		//die($sql_select);			
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$resultado_query = $query_select->fetchAll(PDO::FETCH_ASSOC);
			$count = $query_select->rowCount();
			return($resultado_query);

		} catch (PDOexception $error_select){
			echo 'Erro ao selecionar'.$error_select->getMessage();
		}

		
	}



	function inserir($tabela, $dados){

		// pega campos da array
		$arrCampo = array_keys($dados);		
		// pega valores da array
		$arrValores = array_values($dados);
		// conta campos da array
		$numCampo = count($dados);
		//conta valores array
		$numValores = count($dados);

		if ($numCampo == $numValores){
			$sql_inserir = "INSERT INTO ".$tabela." (";
			foreach($arrCampo as $campo){
				$sql_inserir.="$campo,";	
			}
			$sql_inserir = substr_replace($sql_inserir, ")", -1, 1);
			$sql_inserir.= "VALUES (";
			foreach($arrValores as $valores){
				$sql_inserir.="'".$valores."',";	
			}
			$sql_inserir = substr_replace($sql_inserir, ")", -1, 1);
			
			//die($sql_inserir)	;

		}
				
		try{
			$query_inserir = $this->conecta->prepare($sql_inserir);
			for($cont = 0;$cont < $numCampo; $cont++ ){				
				$query_inserir->bindValue("'".$arrCampo[$cont]."'",$arrValores[$cont],PDO::PARAM_STR);
			}
			$query_inserir->execute();
			$erro = "00";			
			return($erro);		
		} catch (PDOexception $error_insert){

			die('Erro ao Cadastrar'.$error_insert->getMessage());
			
		}
	
		

	}

	function inserirComReturn($tabela, $dados){		
		// pega campos da array
		$arrCampo = array_keys($dados);		
		// pega valores da array
		$arrValores = array_values($dados);
		// conta campos da array
		$numCampo = count($dados);
		//conta valores array
		$numValores = count($dados);

		if ($numCampo == $numValores){
			$sql_inserir = "INSERT INTO ".$tabela." (";
			foreach($arrCampo as $campo){
				$sql_inserir.="$campo,";	
			}
			$sql_inserir = substr_replace($sql_inserir, ")", -1, 1);
			$sql_inserir.= "VALUES (";
			foreach($arrValores as $valores){
				$sql_inserir.="'".$valores."',";	
			}
			$sql_inserir = substr_replace($sql_inserir, ")", -1, 1);			
			//die($sql_inserir)	;
		}
				
		try{

			$query_inserir = $this->conecta->prepare($sql_inserir);
			for($cont = 0;$cont < $numCampo; $cont++ ){				
				$query_inserir->bindValue($arrCampo[$cont],$arrValores[$cont],PDO::PARAM_STR);
			}
			
			$query_inserir->execute();
			$id = $this->conecta->lastInsertId();						
			return($id);	

		} catch (PDOexception $error_insert){			
			die('Erro ao Cadastrar: '.$error_insert->getMessage());
			
		}

	}

	function editar($tabela,$dados,$id){
		// pega campos da array
		$arrCampo = array_keys($dados);		
		// pega valores da array
		$arrValores = array_values($dados);
		// conta campos da array
		$numCampo = count($dados);
		//conta valores array
		$numValores = count($dados);

		if ($numCampo == $numValores){
			$sql_editar = "update ".$tabela." set ";
			for($cont = 0;$cont < $numCampo; $cont++ ){				
				$sql_editar.= " ".$arrCampo[$cont]."= '".$arrValores[$cont]."',";
			}
				$sql_editar = substr_replace($sql_editar, " ", -1, 1);
				$sql_editar.= "where id = ".$id;					

			}

			//die($sql_editar);
								
		try{
			$query_editar = $this->conecta->prepare($sql_editar);
			for($cont = 0;$cont < $numCampo; $cont++ ){				
				$query_editar->bindValue("'".$arrValores[$cont]."'",$arrCampo[$cont],PDO::PARAM_STR);
			}
			$query_editar->execute();
			$erro = "00";			
			return($erro);
		} catch (PDOexception $error_insert){
			$erro ='Erro ao Editar'.$error_insert->getMessage();
			return($erro);
		}
	

	}

	function editarEspecifica($tabela,$dados,$campo,$id){
		// pega campos da array
		$arrCampo = array_keys($dados);		
		// pega valores da array
		$arrValores = array_values($dados);
		// conta campos da array
		$numCampo = count($dados);
		//conta valores array
		$numValores = count($dados);

		if ($numCampo == $numValores){
			$sql_editar = "update ".$tabela." set ";
			for($cont = 0;$cont < $numCampo; $cont++ ){				
				$sql_editar.= " ".$arrCampo[$cont]."= '".$arrValores[$cont]."',";
			}
				$sql_editar = substr_replace($sql_editar, " ", -1, 1);
				$sql_editar.= "where ".$campo." = ".$id;					

			}
			//die($sql_editar);
								
		try{
			$query_editar = $this->conecta->prepare($sql_editar);
			for($cont = 0;$cont < $numCampo; $cont++ ){				
				$query_editar->bindValue("'".$arrValores[$cont]."'",$arrCampo[$cont],PDO::PARAM_STR);
			}
			$query_editar->execute();
			$erro = "00";			
			return($erro);
		} catch (PDOexception $error_insert){
			$erro ='Erro ao Editar'.$error_insert->getMessage();
			return($erro);
		}
	

	}

	function excluir($tabela,$id){

		$sql_excluir = 'DELETE FROM '.$tabela.' WHERE id = '.$id;
		// die($sql_excluir);
						
		try{
			$query_excluir= $this->conecta->prepare($sql_excluir);
			$query_excluir->bindValue('id',$id,PDO::PARAM_INT);			
			$query_excluir->execute();
			$erro = "00";			
			return($erro);
		} catch (PDOexception $error_insert){
			$erro ='Erro ao Editar'.$error_insert->getMessage();
			return($erro);
		}	

	}

	function procurarUsuario($login,$senha){		
	
		$sql_select = 'SELECT * FROM usuario where login = "'.$login.'" and senha = "'.$senha.'"';
		//die($sql_select);			
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$resultado_query = $query_select->fetchAll(PDO::FETCH_ASSOC);
			$count = $query_select->rowCount();	
			if($count == '0'){
				return($count);
			}else{
				return($resultado_query);
			}

		} catch (PDOexception $error_select){
			die('Erro:'.$error_select->getMessage());
		}

		
}

	function recuperaSenha($email){		
	
		$sql_select = 'SELECT * FROM usuario where email = "'.$email.'";';
		//die($sql_select);			
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$resultado_query = $query_select->fetchAll(PDO::FETCH_ASSOC);
			$count = $query_select->rowCount();	
			if($count == '0'){
				return($count);
			}else{
				return($resultado_query);
			}

		} catch (PDOexception $error_select){
			die('Erro:'.$error_select->getMessage());
		}

		
	}

	function addCodConfimacao($codigoCompra,$idUsu){

		$data = date('Y-m-d');
		$aux = $data.time();
	    $codigo = substr(md5($aux),0,20);		
	
		$sql_select = 'INSERT INTO confirmacao (codigo,data,codigo_compra,codigo_usu) VALUES ("'.$codigo.'","'.$data.'","'.$codigoCompra.'","'.$idUsu.'")';
		//die($sql_select);			
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$id = $this->conecta->lastInsertId();

			return($codigo);

		} catch (PDOexception $error_select){
			die('Erro:'.$error_select->getMessage());
		}

		
	}


	function liberarUsuario($idUsu){		
	
		$sql_select = 'UPDATE usuario set nivel=0 WHERE id='.$idUsu.';';
		//die($sql_select);			
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$id = $this->conecta->lastInsertId();

			return($codigo);

		} catch (PDOexception $error_select){
			die('Erro:'.$error_select->getMessage());
		}

		
	}

	function buscarPacoteUsuario($id){		
	
		$sql_select = 'SELECT codigo_compra,codigo FROM confirmacao WHERE codigo_usu="'.$id.'" ORDER BY data DESC limit 1';
				
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$resultado_query = $query_select->fetchAll(PDO::FETCH_ASSOC);
			$count = $query_select->rowCount();	
			if($count != '0'){
				return($resultado_query);
			}else{
				return false;
			}

		} catch (PDOexception $error_select){
			die('Erro ao selecionar'.$error_select->getMessage());
		}		
	}


	function procurarEspecifica($tabela,$campo,$valor){		
	
		$sql_select = 'SELECT * FROM '.$tabela.' WHERE '.$campo.'="'.$valor.'"';
		echo "<div style='display: none'>".$sql_select."</div>";
					
		try{
			$query_select = $this->conecta->prepare($sql_select);
			$query_select->execute();
			$resultado_query = $query_select->fetchAll(PDO::FETCH_ASSOC);
			$count = $query_select->rowCount();	
			return($resultado_query);	
		} catch (PDOexception $error_select){
			die('Erro ao selecionar'.$error_select->getMessage());
		}		

	}


}






/*
		EXEMPLOS DE COMO CHAMAR AS FUNÇÕES

<!---- INSERINDO DADOS    ---->

	include 'includes/classes/classe_querys.php';
	$teste = new Query();
	$teste->logar();
	$tabela = "menus";
	$dados = array('menu'=>'MENU','link'=>'LINK','class'=>'CLASS','titulo'=>'TITULO');
	$teste->inserir($tabela,$dados);

<!---- EDITANDO DADOS    ---->

	include 'includes/classes/classe_querys.php';
	$teste = new Query();
	$teste->logar();
	$tabela = "menus";
	$id = 9;
	$dados = array('menu'=>'CONTATOS','link'=>'index.php','class'=>'CLASS','titulo'=>'CONTATOS');
	$teste->editar($tabela,$dados,$id);

<!---- EXCLUINDO DADOS    ---->

include 'includes/classes/classe_querys.php';
	$teste = new Query();
	$teste->logar();
	$tabela = "menus";
	$id = 4;	
	$teste->excluir($tabela,$id);

	

*/

?>