<?php 
// Configuração otimizada para PHP 8
error_reporting(E_ERROR | E_WARNING | E_PARSE);
ini_set('display_errors', 0);

// CÓDIGO 100% INDEPENDENTE DO COMPOSER
// Carregar apenas se explicitamente solicitado
if (file_exists('simple-autoloader.php')) {
    // Usar apenas nosso autoloader personalizado
    require_once 'simple-autoloader.php';
}
// Não carregar vendor/autoload.php para evitar qualquer problema do Composer

session_start();

// Definir variáveis necessárias para evitar undefined
if (!isset($_POST)) $_POST = array();
if (!isset($_GET)) $_GET = array();
if (!isset($_REQUEST)) $_REQUEST = array();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>TRDAP</title>	
<?php 
if (file_exists("includes/header.php")) {
    include "includes/header.php"; 
} else {
    echo '<meta charset="utf-8" /><link rel="shortcut icon" href="favicon.ico" />';
}
?>



</head>

<body>
<div id="tudo">

	<?php if (file_exists("includes/topo.php")) include "includes/topo.php"; ?>
	
	<?php if (file_exists("includes/banner.php")) include "includes/banner.php"; ?>

	

	<div id="geral">
		
		<div class="geralConteudo">

		<?php if (file_exists("includes/barraLogin.php")) include "includes/barraLogin.php"; ?>
		
		<div id="gBox">
		
			<div class="boxIndex">

				<div class="boxSup">
					<!-- <div class="titBoxIn"></div> -->
					<div class="imagemBoxIn"><img src="imagens/imgQuemSou.jpg" /></div>
				</div>
				
				<div class="subBoxTitIn">Quem Sou?</div>

				<div class="textBoxIn">
					<a href="quem-sou.php" class="linkInSub c-cinzaEs">
						Graduada em Terapia Ocupacional pela Universidade Federal de Pernambuco (1985), com

						aperfeiçoamento em Saúde Pública na 3ª Idade (EPM -1989), Especialização em Saúde do

						Idoso (ENSP - 1994), título de Gerontóloga (SBGG - 1997)...
					</a>
				</div>

				<div class="btSaibaMais"><a href="quem-sou.php" class="linkIn c-branca"> Saiba +</a></div>

			</div><!--end boxIndex-->

			<div class="boxIndex">

				<div class="boxSup">
					<!-- <div class="titBoxIn"></div> -->
					<div class="imagemBoxIn"><img src="imagens/imgServicos2.jpg" /></div>
				</div>
				
				<div class="subBoxTitIn">Serviços</div>

				<div class="textBoxIn">
					<a href="servicos.php" class="linkInSub c-cinzaEs">
						<p>- Informações sobre Estimulação Cognitiva Preventiva</p>
						<p>- Orientações sobre Oficinas de Memória</p>
						<p>- Avaliação de adultos e idosos (rastreio de déficits cognitivos) e orientação para organização de Projetos de Vida...</p>
					</a>
				</div>

				<div class="btSaibaMais"><a href="servicos.php" class="linkIn c-branca"> Saiba +</a></div>

			</div><!--end boxIndex-->

			<div class="boxIndex">

				<div class="boxSup">
					<!-- <div class="titBoxInM"></div> -->
					<div class="imagemBoxIn"><img src="imagens/imgContato.jpg" /></div>
				</div>
				
				<div class="subBoxTitIn">Problemas de memória?</div>

				<div class="textBoxIn">
					<a href="memoria.php" class="linkInSub c-cinzaEs">
						Se você reside na cidade de Recife e tem queixa de memória no dia a dia ou preocupa-se com 
						seu parente, seu amigo… poderá passar por um teste de rastreio para déficit cognitivo com um

Terapeuta Ocupacional.
					</a>
				</div>

				<div class="btSaibaMais"><a href="memoria.php" class="linkIn c-branca"> Saiba +</a></div>

			</div><!--end boxIndex-->
		
		</div><!--end gBox-->
		<div class="clear"></div>

		</div><!--end geralConteudo-->

		<?php //include 'includes/planos.php'; ?>
		
		<?php if (file_exists('includes/sobreTeste.php')) include 'includes/sobreTeste.php'; ?>

	</div><!--end geral-->

	<?php if (file_exists('includes/rodape.php')) include 'includes/rodape.php'; ?>

</div><!--end tudo-->



<?php if(isset($_GET['status'])){ ?>
	<script type="text/javascript">					
		$("body").append("<div id='alert'></div>");
		$("#alert").append("<div class='mensagemErroPesq'><p>Você já é cadastrado como pesquisador!<br/> Contate o seu responsavel para acessar o nosso sistema!</p><button id='alertFechar'>Fechar</button></div>");
	    $("#alert").fadeIn(800, function(){
	    	$("#alertFechar").click(function(){		    		
		    	$("#alert").remove();
		    	return false;
	    	});

	    });    

	</script>
 <?php } ?>

 <?php if(isset($_GET['inativo'])){ ?>
	<script type="text/javascript">					
		$("body").append("<div id='alert'></div>");
		$("#alert").append("<div class='mensagemErroPesq'><p>Foi enviado um e-mail para liberaçao de seu cadastro! <br/> </p><button id='alertFechar'>Fechar</button></div>");
	    $("#alert").fadeIn(800, function(){
	    	$("#alertFechar").click(function(){		    		
		    	$("#alert").remove();
		    	return false;
	    	});

	    });    

	</script>
 <?php } ?>

 <?php if(isset($_GET['invalido'])){ ?>
	<script type="text/javascript">					
		$("body").append("<div id='alert'></div>");
		$("#alert").append("<div class='mensagemErroPesq'><p>Login ou senha incorreta!</p><button id='alertFechar'>Fechar</button></div>");
	    $("#alert").fadeIn(800, function(){
	    	$("#alertFechar").click(function(){		    		
		    	$("#alert").remove();
		    	return false;
	    	});

	    });    

	</script>
 <?php } ?>

  <?php if(isset($_GET['pendente'])){ ?>
	<script type="text/javascript">					
		$("body").append("<div id='alert'></div>");
		$("#alert").append("<div class='mensagemErroPesq'><p>Você ainda não confirmou seu cadastro em nosso site, favor verificar sua caixa de e-mail(lixeira, spam) e clicar no link de confirmação.</p><button id='alertFechar'>Fechar</button></div>");
	    $("#alert").fadeIn(800, function(){
	    	$("#alertFechar").click(function(){		    		
		    	$("#alert").remove();
		    	return false;
	    	});

	    });    

	</script>
 <?php } ?>


</body>
</html>

