<?php
/**
 * SCRIPT PARA CORRIGIR PROBLEMAS DO COMPOSER NO SERVIDOR
 * Execute este arquivo no servidor para resolver o problema fatal
 */

echo "<h1>🔧 CORREÇÃO DE PROBLEMAS DO COMPOSER</h1>";

// 1. Verificar versão PHP
echo "<p><strong>Versão PHP:</strong> " . PHP_VERSION . "</p>";

// 2. Verificar se putenv() existe
if (function_exists('putenv')) {
    echo "<p>✅ <strong>putenv():</strong> Disponível</p>";
} else {
    echo "<p>❌ <strong>putenv():</strong> NÃO disponível - CAUSA DO PROBLEMA!</p>";
}

// 3. Verificar arquivos do Composer
$composer_files = array(
    'composer.phar',
    'composer.json', 
    'composer.lock',
    'vendor/'
);

echo "<h2>📁 Arquivos do Composer encontrados:</h2>";
foreach ($composer_files as $file) {
    if (file_exists($file)) {
        echo "<p>⚠️ <strong>$file</strong> - ENCONTRADO (pode causar problemas)</p>";
    } else {
        echo "<p>✅ <strong>$file</strong> - Não encontrado</p>";
    }
}

// 4. Solução recomendada
echo "<h2>🚀 SOLUÇÃO RECOMENDADA:</h2>";
echo "<p>Para resolver o problema Fatal, o servidor precisa:</p>";
echo "<ul>";
echo "<li>1. Remover arquivos do Composer (composer.phar, composer.lock)</li>";
echo "<li>2. Usar apenas as bibliotecas PHP essenciais</li>";
echo "<li>3. Pasta vendor/ pode ficar se não causar erro</li>";
echo "</ul>";

echo "<h2>📋 COMANDOS PARA EXECUTAR NO SERVIDOR SSH:</h2>";
echo "<pre>";
echo "cd public_html/mauriceatabosa.com.br\n";
echo "ls -la composer.* composer.phar 2>/dev/null || echo 'Arquivos não encontrados'\n";
echo "rm -f composer.phar composer.lock 2>/dev/null\n";
echo "echo 'Arquivos removidos com sucesso!'\n";
echo "</pre>";

echo "<h2>✅ TESTE DEPOIS:</h2>";
echo "<p>Acesse <a href='index.php'>index.php</a> - deve funcionar sem erros!</p>";

?>
