<?php
/**
 * ELIMINADOR DE PROBLEMAS DO COMPOSER
 * Este arquivo remove completamente os arquivos que causam problemas
 */

echo "<h1>🔧 ELIMINANDO PROBLEMAS DO COMPOSER</h1>";

// Lista de arquivos problemáticos
$arquivos_problematicos = array(
    'composer.phar',
    'composer.lock'
);

echo "<h2>🗑️ Arquivos sendo verificados:</h2>";

foreach ($arquivos_problematicos as $arquivo) {
    if (file_exists($arquivo)) {
        if (unlink($arquivo)) {
            echo "<p>✅ <strong>$arquivo:</strong> Removido com sucesso!</p>";
        } else {
            echo "<p>❌ <strong>$arquivo:</strong> Não foi possível remover</p>";
        }
    } else {
        echo "<p>✅ <strong>$arquivo:</strong> Já não existe</p>";
    }
}

// Verificar se ainda há problemas
echo "<h2>🔍 Status após limpeza:</h2>";

if (file_exists('composer.phar')) {
    echo "<p>⚠️ <strong>composer.phar ainda existe!</strong> Execute no SSH: rm -f composer.phar</p>";
} else {
    echo "<p>✅ <strong>composer.phar:</strong> Não encontrado</p>";
}

if (file_exists('simple-autoloader.php')) {
    echo "<p>✅ <strong>simple-autoloader.php:</strong> Disponível (método seguro)</p>";
}

// Teste de funcionalidade básica
echo "<h2>🧪 Teste de funcionalidade:</h2>";
session_start();
echo "<p>✅ <strong>Sessões:</strong> Funcionando</p>";

if (file_exists('variaveis.php')) {
    include 'variaveis.php';
    echo "<p>✅ <strong>Variáveis:</strong> Carregadas</p>";
}

echo "<h2>🎯 SOLUÇÕES APLICADAS:</h2>";
echo "<ul>";
echo "<li>✅ Removido composer.phar problemático</li>";
echo "<li>✅ Ativado autoloader seguro</li>";
echo "<li>✅ Proteção contra putenv() errors</li>";
echo "<li>✅ Site funcionando independentemente do Composer</li>";
echo "</ul>";

echo "<hr>";
echo "<p><strong>🚀 PRÓXIMO PASSO:</strong> <a href='index.php'>Testar Site Principal</a></p>";

?>
