<?php
header("Access-Control-Allow-Origin: *");
header('Content-Type: text/html; charset=utf-8');

$data = file_get_contents("php://input");
$objData = json_decode($data);

include('classes/classe_querys.php');
$id = $objData->id;
$conexao = new Query();
$conexao->logar();
$user = $conexao->buscarPesquisadorId($id);
$participantes = $conexao->procurarVinculosPesquisador($id);
if(count($participantes) > 0):
	foreach ($participantes as $participante):
		$arr_participante[$participante['id']] = $participante;
		
		$atributos_participantes = $conexao->getAtributosParticipantes($participante['id']);
		$arr_atributos_participantes = [];
		if(count($atributos_participantes) > 0):
			foreach ($atributos_participantes as $atributos_participante):
				$arr_atributos_participantes[$atributos_participante['id']] = $atributos_participante;
			endforeach;
		endif;
		$arr_participante[$participante['id']]['atributos_participantes'] = $arr_atributos_participantes;
		
		$endereco_participante = $conexao->getEnderecoParticipante($participante['id']);
		$arr_endereco_participante = [];
		if(count($endereco_participante) > 0):
			// foreach ($endereco_participante as $endereco_participante):
				$arr_endereco_participante[$endereco_participante[0]['id']] = $endereco_participante[0];
			// endforeach;
		endif;
		$arr_participante[$participante['id']]['endereco_participante'] = $arr_endereco_participante;

		$mini_exames = $conexao->BuscarMiniExamePorParticipante($participante['id']);
		$arr_mini_exame = [];
		if(count($mini_exames) > 0):
			foreach ($mini_exames as $mini_exame):
				$arr_mini_exame[$mini_exame['id']] = $mini_exame;
			endforeach;
		endif;
		$arr_participante[$participante['id']]['mini_exames'] = $arr_mini_exame;
		
		$reconhecimento_proverbios = $conexao->BuscarReconhecimentoporParticipante($participante['id']);
		$arr_reconhecimento_proverbios = [];
		if(count($reconhecimento_proverbios) > 0):
			foreach ($reconhecimento_proverbios as $reconhecimento_proverbio):
				$arr_reconhecimento_proverbios[$reconhecimento_proverbio['id']] = $reconhecimento_proverbio;
			endforeach;
		endif;
		$arr_participante[$participante['id']]['reconhecimento_proverbios'] = $arr_reconhecimento_proverbios;
		
		$resultados_trdap = $conexao->BuscarResultadoTrdapPorParticipante($participante['id']);
		$arr_resultado_trdap = [];
		if(count($resultados_trdap) > 0):
			foreach ($resultados_trdap as $resultado_trdap):
				// $resultado_trdap['tempo'] = $conexao->calcularTempo($resultado_trdap['data_inicio'], $resultado_trdap['data_fim']);
				// $resultado_trdap['data_inicio'] = $conexao->formaData($resultado_trdap['data_inicio']).' -- '.$conexao->formaHora($resultado_trdap['data_inicio']).'h';
				$arr_resultado_trdap[$resultado_trdap['id']] = $resultado_trdap;
			endforeach;
		endif;
		$arr_participante[$participante['id']]['resultado_trdap'] = $arr_resultado_trdap;
		
		$trdap_teste_a = $conexao->BuscarAnalizeTesteA($participante['id']);
		$arr_trdap_teste_a = [];
		if(count($trdap_teste_a) > 0):
			foreach ($trdap_teste_a as $trdap_teste_a):
				$trdap_teste_a['obs'] = utf8_encode($trdap_teste_a['obs']);
				$arr_trdap_teste_a[$trdap_teste_a['id']] = $trdap_teste_a;
			endforeach;
		endif;
		$arr_participante[$participante['id']]['trdap_teste_a'] = $arr_trdap_teste_a;
		
		$trdap_teste_b = $conexao->BuscarAnalizeTesteB($participante['id']);
		$arr_trdap_teste_b = array();
		if (count($trdap_teste_b) > 0):
			foreach ($trdap_teste_b as $trdap_teste_b) {
				$trdap_teste_b['obs1'] = utf8_encode($trdap_teste_b['obs1']);
				$trdap_teste_b['obs2'] = utf8_encode($trdap_teste_b['obs2']);
				$trdap_teste_b['obs3'] = utf8_encode($trdap_teste_b['obs3']);
				$arr_trdap_teste_b[$trdap_teste_b['id']] = $trdap_teste_b;
			}
		endif;
		$arr_participante[$participante['id']]['trdap_teste_b'] = $arr_trdap_teste_b;
		
		$trdap_teste_c = $conexao->BuscarAnalizeTesteC($participante['id']);
		$arr_trdap_teste_c = [];
		if (count($trdap_teste_c) > 0):
			foreach ($trdap_teste_c as $trdap_teste_c) {
				$arr_trdap_teste_c[$trdap_teste_c['id']] = $trdap_teste_c;
			}
		endif;
		$arr_participante[$participante['id']]['trdap_teste_c'] = $arr_trdap_teste_c;

		$acompanhante = $conexao->getAcompanhantePorParticipante($participante['id']);;
		$arr_acompanhante = [];
		if(count($acompanhante) > 0):
			foreach ($acompanhante as $acompanhante):
				$arr_acompanhante[$acompanhante['id']] = $acompanhante;
			endforeach;
		endif;
		
		$arr_participante[$participante['id']]['acompanhante'] = $arr_acompanhante;
	endforeach;
endif;

$num_testesConc = $conexao->trdapConclu($id);
$num_testesCanc = $conexao->trdapCancelados($id);
$procuraNumTeste = $conexao->procurarId('usuario',$id);


$data = array('user' => $user, 'participantes' => $arr_participante, 'concluidos' => $num_testesConc, 'cancelados' => $num_testesCanc, 'total' => $procuraNumTeste[0]['num_testes']);
echo json_encode($data);