﻿<?php
// Configurar codificação UTF-8
header('Content-Type: text/html; charset=UTF-8');
mb_internal_encoding('UTF-8');
mb_http_output('UTF-8');

// Evitar qualquer output antes dos headers
ob_start();

require_once '../../vendor/autoload.php';
include "../classes/classe_querys.php";

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\IOFactory;

$con = new Query();
$con->logar();

// Função para corrigir caracteres corrompidos - versão específica para o problema
function ensureUtf8($string) {
    if (empty($string)) {
        return $string;
    }
    
    // Mapeamento específico dos caracteres corrompidos mais comuns
    $correcoes = [
        // Caracteres corrompidos -> corretos
        'Ã¡' => 'á', 'Ã ' => 'à', 'Ã¢' => 'â', 'Ã£' => 'ã', 'Ã¤' => 'ä',
        'Ã©' => 'é', 'Ã¨' => 'è', 'Ãª' => 'ê', 'Ã«' => 'ë',
        'Ã-' => 'í', 'Ã¬' => 'ì', 'Ã®' => 'î', 'Ã¯' => 'ï',
        'Ã³' => 'ó', 'Ã²' => 'ò', 'Ã´' => 'ô', 'Ãµ' => 'õ', 'Ã¶' => 'ö',
        'Ãº' => 'ú', 'Ã¹' => 'ù', 'Ã»' => 'û', 'Ã¼' => 'ü',
        'Ã§' => 'ç', 'Ã‡' => 'Ç',
        'Ã€' => 'À', 'Ã' => 'Á', 'Ã‚' => 'Â', 'Ãƒ' => 'Ã', 'Ã„' => 'Ä',
        'Ãˆ' => 'È', 'Ã‰' => 'É', 'ÃŠ' => 'Ê', 'Ã‹' => 'Ë',
        'Ã-' => 'Í', 'ÃŒ' => 'Ì', 'ÃŽ' => 'Î', 'Ã' => 'Ï',
        'Ã"' => 'Ò', 'Ã"' => 'Ó', 'Ã"' => 'Ô', 'Ã"' => 'Õ', 'Ã"' => 'Ö',
        'Ã™' => 'Ù', 'Ãš' => 'Ú', 'Ã›' => 'Û', 'Ãœ' => 'Ü',
        'Ã±' => 'ñ', 'Ã' => 'Ñ',
        // Caracteres específicos do português
        'Ã§Ã£o' => 'ção', 'Ã§Ãµes' => 'ções',
        'Ã£o' => 'ão', 'Ãµes' => 'ões',
        'Ã©' => 'é', 'Ã©s' => 'és',
        'Ã¡' => 'á', 'Ã¡s' => 'ás',
        'Ã³' => 'ó', 'Ã³s' => 'ós',
        'Ãº' => 'ú', 'Ãºs' => 'ús',
        'Ã-' => 'í', 'Ã-s' => 'ís',
        // Casos específicos encontrados
        'CÃ¢ndida' => 'Cândida',
        'JosÃ©' => 'José',
        'AucÃ©lia' => 'Aucélia',
        'HortÃªncia' => 'Hortência',
        'GraÃ§as' => 'Graças',
        'MendonÃ§a' => 'Mendonça',
        'MÃ©dico' => 'Médico',
        'EmpresÃ¡ria' => 'Empresária',
        'SociÃ³loga' => 'Socióloga',
        'CatÃ³lica' => 'Católica',
        'CatÃ³lico' => 'Católico',
        'EspÃ-rita' => 'Espírita',
        'EvangÃ©lica' => 'Evangélica',
        'ConfederaÃ§Ã£o' => 'Confederação',
        'VirgÃ-lio' => 'Virgílio',
        'AntÃ´nio' => 'Antônio',
        'SÃ£o' => 'São',
        'NaÃ§Ãµes' => 'Nações',
        'JoÃ£o' => 'João'
    ];
    
    // Aplicar correções específicas
    $string = str_replace(array_keys($correcoes), array_values($correcoes), $string);
    
    // Se ainda há caracteres corrompidos, tentar conversão automática
    if (strpos($string, 'Ã') !== false) {
        // Tentar converter de ISO-8859-1 para UTF-8
        $converted = mb_convert_encoding($string, 'UTF-8', 'ISO-8859-1');
        if ($converted !== false && !mb_check_encoding($converted, 'UTF-8')) {
            $string = $converted;
        }
    }
    
    return $string;
}

if(isset($_REQUEST['tipo'])){

try {
$result = $con->buscarDadosBanco($_REQUEST['idParticipante'],$_REQUEST['tipo']);

    // Criar nova planilha
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setTitle('Planilha de Dados');
    
    // Configurar codificação UTF-8 para o PhpSpreadsheet
    $sheet->getParent()->getProperties()
        ->setCreator('Sistema TRDAP')
        ->setLastModifiedBy('Sistema TRDAP')
        ->setTitle('Planilha de Dados - TRDAP')
        ->setSubject('Dados dos Participantes')
        ->setDescription('Planilha com dados dos participantes do teste TRDAP')
        ->setKeywords('TRDAP, teste, participantes')
        ->setCategory('Relatório');
    
    // Configurar estilo padrão para UTF-8 (compatível com versão atual)
    // $sheet->getDefaultStyle()->getFont()->setName('Arial');
    // $sheet->getDefaultStyle()->getFont()->setSize(10);

$totalPart = 0;
    $currentRow = 1;

    // Verificar escolaridade dos participantes
foreach ($result as $dir){
	 if(!is_numeric($dir['escolaridade'])){
        $res = true;
            // Limpar buffer e mostrar erro
            ob_end_clean();
        echo "<div>Participante : <strong>".$dir['nomePaticipante']. "</strong> não esta com escolaridade definida para obter um gráfico</div>";
            exit;
        }
    }

    // Definir cabeçalhos das colunas
    $headers = [
        'Código', 'Data Nascimento', 'Idade', 'Acompanhante', 'Telefone Acompanhante', 'Escolaridade', 'Profissão', 'Religião', 'País', 'CEP',
        'Endereço', 'Estado', 'Cidade', 'Telefone', 'Dominância', 'Estado Civil', 'Moradia', 'Cursos', 'Convivência', 'Terapias',
        'Participação', 'Renda Mensal', 'Leitura', 'Escrita', 'Atividades Sociais', 'Atividades Físicas', 'Saúde', 'Memória',
        'Interferência Cotidiana', 'Local de Atendimento', '', 'DATA DO TESTE', 'Total TRDAP A', 'Total TRDAP B', 'Total TRDAP C',
        'Total GERAL TRDAP', 'Orientação Temporal', 'Orientação Espacial', 'Memória Imediata', 'Atenção Cálculo', 'Memória / Evocação',
        'Linguagem', 'total Brasil', 'total Portugal', 'Reconhecimentos', 'Intrusões', 'Tempo de reação', 'Demência Diagnosticada'
    ];

    $totalColumns = count($headers);

     // Adicionar título principal
     $sheet->mergeCells('A1:' . \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($totalColumns) . '1');
     $sheet->setCellValue('A1', 'Planilha de Dados');
     $sheet->getStyle('A1')->getFont()->setBold(true)->setSize(16);
     $sheet->getStyle('A1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);

    $currentRow = 3;

    // Adicionar cabeçalhos das colunas
    $colIndex = 1;
    foreach($headers as $header) {
        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex);
        $sheet->setCellValue($colLetter . $currentRow, $header);
        $sheet->getStyle($colLetter . $currentRow)->getFont()->setBold(true);
        $colIndex++;
    }
    $currentRow++;

foreach ($result as $dir){
	$resultFinal = $con->BuscarAnalizeTesteFinal($dir['idPaticipante']);
	$titulo = 0;
	$corpo = 0;

	if(is_array($resultFinal) && count($resultFinal) > 0){
		$totalPart++;
		$cont = 0;
	 	foreach ($resultFinal as $dir2) {

			if($cont == 0){
				$resultA = $con->BuscarAnalizeTesteA($dir['idPaticipante'],$dir2['codigo']);
				$resultB = $con->BuscarAnalizeTesteB($dir['idPaticipante'],$dir2['codigo']);
				$resultC = $con->BuscarAnalizeTesteC($dir['idPaticipante'],$dir2['codigo']);
				$mini = $con->BuscarMiniExame($dir['idPaticipante'],$dir2['codigo']);
				$recProv = $con->BuscarReconhecimento($dir['idPaticipante'],$dir2['codigo']);

				if($titulo == 0){
                        // Adicionar nome do participante como cabeçalho de seção
                        $sheet->mergeCells('A' . $currentRow . ':' . \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex(31) . $currentRow);
                        $sheet->setCellValue('A' . $currentRow, ensureUtf8($dir['nomePaticipante']));
                        $sheet->getStyle('A' . $currentRow)->getFont()->setBold(true)->setSize(12);
                        $sheet->getStyle('A' . $currentRow)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('CCCCCC');
                         $currentRow++;
					$titulo++;
				}

                    // Adicionar dados do participante
				if($corpo == 0){
                        $colIndex = 1;
                        
                        // Dados pessoais - verificar se existem antes de adicionar
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['idPaticipante']) ? $dir['idPaticipante'] : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['dataNascimento']) ? $dir['dataNascimento'] : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['idade']) ? $dir['idade'] : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['nomeAcompanhante']) ? ensureUtf8($dir['nomeAcompanhante']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['telefoneAcmpanhante']) ? $dir['telefoneAcmpanhante'] : '');
                        
                        $escolaridade = isset($dir['escolaridade']) ? ensureUtf8(str_replace('-', ' a ', $dir['escolaridade'])) : '';
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, $escolaridade);
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['profissao']) ? ensureUtf8($dir['profissao']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['religiao']) ? ensureUtf8($dir['religiao']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['pais']) ? ensureUtf8($dir['pais']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['cep']) ? $dir['cep'] : '');
                        
                        $endereco = (isset($dir['rua']) ? ensureUtf8($dir['rua']) : '') . ',' . 
                                    (isset($dir['numero']) ? $dir['numero'] : '') . ',' . 
                                    (isset($dir['complemento']) ? ensureUtf8($dir['complemento']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, $endereco);
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['estado']) ? ensureUtf8($dir['estado']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['cidade']) ? ensureUtf8($dir['cidade']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['foneFixo']) ? $dir['foneFixo'] : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['dominancia']) ? $dir['dominancia'] : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['estadoCivil']) ? ensureUtf8($dir['estadoCivil']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['mora']) ? ensureUtf8($dir['mora']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['cursos']) ? ensureUtf8($dir['cursos']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['convivencia']) ? ensureUtf8($dir['convivencia']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['terapias']) ? ensureUtf8($dir['terapias']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['participacoes']) ? ensureUtf8($dir['participacoes']) : '');
                        
                        // Renda mensal
                        $rendaText = '';
                        if(isset($dir['rendaMensal'])){
					if($dir['rendaMensal'] == 1){
                                $rendaText = 'Menor que 1 salário mínimo';
					}else if($dir['rendaMensal'] == 2){
                                $rendaText = '1 salário mínimo';
					}else if($dir['rendaMensal'] == 3){
                                $rendaText = '2-3 salários mínimos';
					}else if($dir['rendaMensal'] == 4){
                                $rendaText = 'Mais de 3 salários mínimos';
                            }
                        }
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, ensureUtf8($rendaText));
                        
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['habitoLeitura']) ? ensureUtf8($dir['habitoLeitura']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['habitoEscrita']) ? ensureUtf8($dir['habitoEscrita']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['atividadeSocial']) ? ensureUtf8($dir['atividadeSocial']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['atividadeFisica']) ? ensureUtf8($dir['atividadeFisica']) : '');
                        
                        // Saúde
                        $saudeText = '';
                        if(isset($dir['saude'])){
					if($dir['saude'] == 1){
                                $saudeText = 'Boa';
					}else if($dir['saude'] == 2){
                                $saudeText = 'Regular';
					}else if($dir['saude'] == 3){
                                $saudeText = 'Ruim';
                            }
                        }
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, ensureUtf8($saudeText));
                        
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['problemaMemoria']) ? ensureUtf8($dir['problemaMemoria']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['intCotidiano']) ? ensureUtf8($dir['intCotidiano']) : '');
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['local_atend']) ? ensureUtf8($dir['local_atend']) : '');
                        $colIndex++; // Coluna vazia
                        
					$corpo++;
				}else{
                        // Pular colunas para participantes subsequentes
                        $colIndex = 32; // Pular para coluna AF (dados do teste)
				}


                    // Adicionar dados dos testes
				if(is_array($resultFinal)){
                        // Data do teste
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir2['data']) ? $dir2['data'] : '');
                        
                        // Dados TRDAP
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($resultA) && isset($resultA[0]['total']) ? $resultA[0]['total'] : '0'));
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($resultB) && isset($resultB[0]['total']) ? $resultB[0]['total'] : '0'));
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($resultC) && isset($resultC[0]['total']) ? $resultC[0]['total'] : '0'));

                        $totalValue = isset($dir2['total']) ? $dir2['total'] : 0;
                        $resultTrda = $con->resultTrdapComDefit($dir['escolaridade'], $totalValue);
                        $totalTrdapCol = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex);
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, $totalValue);
					if($resultTrda){
                            $sheet->getStyle($totalTrdapCol . $currentRow)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('993333');
					}else{
                            $sheet->getStyle($totalTrdapCol . $currentRow)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('99CC66');
                        }

                        // Dados Mini Exame
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($mini) && isset($mini[0]['orien_temp']) ? $mini[0]['orien_temp'] : '0'));
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($mini) && isset($mini[0]['orien_espa']) ? $mini[0]['orien_espa'] : '0'));
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($mini) && isset($mini[0]['memor_imed']) ? $mini[0]['memor_imed'] : '0'));
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($mini) && isset($mini[0]['atenc_cal']) ? $mini[0]['atenc_cal'] : '0'));
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($mini) && isset($mini[0]['memor_evoc']) ? $mini[0]['memor_evoc'] : '0'));
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, (is_array($mini) && isset($mini[0]['lingu']) ? $mini[0]['lingu'] : '0'));

                        $miniTotal = (is_array($mini) && isset($mini[0]['total']) ? $mini[0]['total'] : '0');
                        $resultMin = $con->resulMinComDefit($dir['escolaridade'], $miniTotal);
                        
                        $totalBrasilCol = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex);
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, $miniTotal);
                        if(isset($resultMin['brasil']) && $resultMin['brasil']){
                            $sheet->getStyle($totalBrasilCol . $currentRow)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('993333');
					}else{
                            $sheet->getStyle($totalBrasilCol . $currentRow)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('99CC66');
                        }
                        
                        $totalPortugalCol = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex);
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, $miniTotal);
                        if(isset($resultMin['portugal']) && $resultMin['portugal']){
                            $sheet->getStyle($totalPortugalCol . $currentRow)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('993333');
					}else{
                            $sheet->getStyle($totalPortugalCol . $currentRow)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('99CC66');
					}

                        // Reconhecimento Provérbios
					$rec1 = 0;
					$intr = 0;
					if(is_array($recProv) && isset($recProv[0]['rec1']) && $recProv[0]['rec1']){  $intr++; }
					if(is_array($recProv) && isset($recProv[0]['rec2']) && $recProv[0]['rec2']){  $intr++; }
					if(is_array($recProv) && isset($recProv[0]['rec3']) && $recProv[0]['rec3']){  $rec1++; }
					if(is_array($recProv) && isset($recProv[0]['rec4']) && $recProv[0]['rec4']){  $intr++; }
					if(is_array($recProv) && isset($recProv[0]['rec5']) && $recProv[0]['rec5']){  $rec1++; }
					if(is_array($recProv) && isset($recProv[0]['rec6']) && $recProv[0]['rec6']){  $rec1++; }

                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, $rec1);
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, $intr);
                        
                        $tempoReacao = '';
                        if(isset($dir2['data']) && isset($dir2['datafim'])){
                            $tempoReacao = $con->calcularTempo($dir2['data'], $dir2['datafim']);
                        }
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, $tempoReacao);
                        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex++);
                        $sheet->setCellValue($colLetter . $currentRow, isset($dir['demencia']) ? ensureUtf8($dir['demencia']) : '');
                    }
                    $currentRow++;
			  $cont++;
	  		}// fim if = 0

            } // fim foreache

	} // fim if

	if(is_array($resultFinal) && count($resultFinal) == 1){
            $currentRow++; // Linha em branco
	}

} // fim foreache

    // Adicionar total de participantes
    $sheet->setCellValue('A2', 'Total Participantes: ' . $totalPart);
    $sheet->getStyle('A2')->getFont()->setBold(true)->setSize(12);

    // Aplicar bordas a todas as células com dados
    $lastRow = $currentRow - 1;
    if($lastRow >= 1){
        $lastColumnLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($totalColumns);
        $sheet->getStyle('A1:' . $lastColumnLetter . $lastRow)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
    }

    // Auto-ajustar largura das colunas
    for($col = 1; $col <= $totalColumns; $col++) {
        $colLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($col);
        $sheet->getColumnDimension($colLetter)->setAutoSize(true);
    }

    // Limpar qualquer output anterior
    while (ob_get_level()) {
        ob_end_clean();
    }

    // Criar o writer e salvar em memória
    $writer = new Xlsx($spreadsheet);
    
    // Configurar o writer para UTF-8
    $writer->setOffice2003Compatibility(false);
    
    // Salvar em arquivo temporário
    $tempFile = tempnam(sys_get_temp_dir(), 'excel_');
    if ($tempFile === false) {
        throw new Exception("Não foi possível criar arquivo temporário");
    }
    
    $writer->save($tempFile);
    
    // Verificar se o arquivo foi criado
    if (!file_exists($tempFile) || filesize($tempFile) == 0) {
        throw new Exception("Arquivo Excel não foi gerado corretamente");
    }

// Configurações header para forçar o download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="planilha_dados.xlsx"');
    header('Content-Length: ' . filesize($tempFile));
    header('Cache-Control: max-age=0');
    header('Cache-Control: no-cache, must-revalidate');
    header('Expires: 0');
    header('Pragma: public');

    // Enviar arquivo e limpar
    readfile($tempFile);
    unlink($tempFile);
    
    // Liberar memória
    $spreadsheet->disconnectWorksheets();
    unset($spreadsheet);
    
} catch (Exception $e) {
    // Em caso de erro, limpar buffer e mostrar mensagem
    while (ob_get_level()) {
        ob_end_clean();
    }
    echo "<div>Erro ao gerar planilha: " . $e->getMessage() . "</div>";
    error_log("Erro ao gerar Excel: " . $e->getMessage());
}

exit;
}
$con = null;
?>