<?php
// Script para instalar FPDF automaticamente
echo "<h2>Instalação da Biblioteca FPDF</h2>";

// Verificar se FPDF já existe
$fpdfPath = __DIR__ . '/fpdf/fpdf.php';
if (file_exists($fpdfPath)) {
    echo "<p style='color: green;'>✅ FPDF já está instalado!</p>";
    echo "<p>Caminho: " . $fpdfPath . "</p>";
    exit;
}

// Criar diretório fpdf
$fpdfDir = __DIR__ . '/fpdf';
if (!is_dir($fpdfDir)) {
    if (mkdir($fpdfDir, 0755, true)) {
        echo "<p style='color: green;'>✅ Diretório fpdf criado com sucesso!</p>";
    } else {
        echo "<p style='color: red;'>❌ Erro ao criar diretório fpdf</p>";
        exit;
    }
}

// URL do FPDF
$fpdfUrl = 'https://github.com/setasign/fpdf/archive/refs/heads/main.zip';
$zipFile = $fpdfDir . '/fpdf.zip';

echo "<p>📥 Baixando FPDF...</p>";

// Baixar FPDF
$context = stream_context_create([
    'http' => [
        'timeout' => 30,
        'user_agent' => 'PHP FPDF Downloader'
    ]
]);

$content = file_get_contents($fpdfUrl, false, $context);
if ($content === false) {
    echo "<p style='color: red;'>❌ Erro ao baixar FPDF. Tentando método alternativo...</p>";
    
    // Método alternativo - criar FPDF básico
    $fpdfContent = '<?php
// FPDF Básico - Versão Simplificada
class FPDF {
    protected $pageWidth = 210;
    protected $pageHeight = 297;
    protected $currentX = 10;
    protected $currentY = 10;
    protected $fontSize = 12;
    protected $fontFamily = "Arial";
    protected $fontStyle = "";
    protected $pages = [];
    protected $currentPage = 0;
    protected $orientation = "P";
    
    public function __construct($orientation = "P") {
        $this->orientation = $orientation;
        if ($orientation == "L") {
            $this->pageWidth = 297;
            $this->pageHeight = 210;
        }
        $this->AddPage();
    }
    
    public function AddPage() {
        $this->pages[] = [];
        $this->currentPage = count($this->pages) - 1;
        $this->currentY = 10;
        $this->currentX = 10;
    }
    
    public function SetFont($family, $style = "", $size = 12) {
        $this->fontFamily = $family;
        $this->fontStyle = $style;
        $this->fontSize = $size;
    }
    
    public function Cell($w, $h, $txt, $border = 0, $ln = 0, $align = "", $fill = false) {
        // Implementação básica - em produção usar FPDF completo
        if ($ln == 1) {
            $this->currentY += $h;
            $this->currentX = 10;
        } else {
            $this->currentX += $w;
        }
    }
    
    public function Ln($h = null) {
        if ($h === null) $h = $this->fontSize + 2;
        $this->currentY += $h;
        $this->currentX = 10;
    }
    
    public function SetFillColor($r, $g, $b) {
        // Implementação básica
    }
    
    public function SetTextColor($r, $g, $b) {
        // Implementação básica
    }
    
    public function GetY() {
        return $this->currentY;
    }
    
    public function SetY($y) {
        $this->currentY = $y;
    }
    
    public function Output($dest = "", $name = "", $isUTF8 = false) {
        // Para esta versão básica, vamos gerar HTML
        header("Content-Type: text/html; charset=utf-8");
        echo "<h2>Relatório PDF (Versão HTML)</h2>";
        echo "<p>Esta é uma versão simplificada. Para funcionalidade completa, instale FPDF.</p>";
        echo "<p>Download: <a href=\"https://github.com/setasign/fpdf\" target=\"_blank\">FPDF no GitHub</a></p>";
    }
}
?>';
    
    file_put_contents($fpdfDir . '/fpdf.php', $fpdfContent);
    echo "<p style='color: orange;'>⚠️ FPDF básico criado. Para funcionalidade completa, baixe manualmente.</p>";
    echo "<p><a href='https://github.com/setasign/fpdf' target='_blank'>📥 Baixar FPDF Completo</a></p>";
    exit;
}

// Salvar arquivo ZIP
if (file_put_contents($zipFile, $content)) {
    echo "<p style='color: green;'>✅ FPDF baixado com sucesso!</p>";
} else {
    echo "<p style='color: red;'>❌ Erro ao salvar arquivo ZIP</p>";
    exit;
}

// Verificar se ZIP é válido
$zip = new ZipArchive();
if ($zip->open($zipFile) === TRUE) {
    echo "<p>📦 Extraindo FPDF...</p>";
    
    // Extrair apenas o arquivo fpdf.php
    for ($i = 0; $i < $zip->numFiles; $i++) {
        $filename = $zip->getNameIndex($i);
        if (strpos($filename, 'fpdf.php') !== false) {
            $content = $zip->getFromIndex($i);
            file_put_contents($fpdfDir . '/fpdf.php', $content);
            echo "<p style='color: green;'>✅ FPDF extraído com sucesso!</p>";
            break;
        }
    }
    
    $zip->close();
    
    // Remover arquivo ZIP
    unlink($zipFile);
    
    echo "<p style='color: green;'>🎉 Instalação concluída!</p>";
    echo "<p><a href='test_pdf_generation.php'>🧪 Testar Geração de PDF</a></p>";
    
} else {
    echo "<p style='color: red;'>❌ Erro ao extrair arquivo ZIP</p>";
}
?>
