<?php
// Configurações alternativas para conexão com MySQL
// Use este arquivo se houver problemas de autenticação

function getDbConfig() {
    return [
        'host' => 'localhost',
        'dbname' => 'trdap_pix3',
        'username' => 'trdap_pix3',
        'password' => 'mud4rs3nh4',
        'charset' => 'utf8mb4',
        'options' => [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci",
            PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT => false,
        ]
    ];
}

function createDbConnection() {
    $config = getDbConfig();
    
    // Tentar diferentes DSNs
    $dsnOptions = [
        "mysql:host={$config['host']};dbname={$config['dbname']};charset={$config['charset']}",
        "mysql:host={$config['host']};dbname={$config['dbname']}",
        "mysql:host={$config['host']};dbname={$config['dbname']};port=3306"
    ];
    
    foreach($dsnOptions as $dsn) {
        try {
            $pdo = new PDO($dsn, $config['username'], $config['password'], $config['options']);
            return $pdo;
        } catch (PDOException $e) {
            if(strpos($e->getMessage(), 'auth_gssapi_client') !== false) {
                continue;
            }
            error_log("Erro de conexão: " . $e->getMessage());
        }
    }
    
    throw new Exception("Não foi possível conectar ao banco de dados");
}
?>
