<?php

class Participante{

	private $nome = null;
	private $data = null;
	private $idade = null;
	private $estadoCivil = null;
	private $profissao = null;
	private $foneFixo = null;
	private $foneCelular = null;
	private $email = null;
	private $localAtend = null;
	private $status = null;
	private $idParticipante = null;

	function __construct($post){

		$this->setNome($post);
		$this->setData($post);
		$this->setIdade($post);
		$this->setEstadoCivil($post);
		$this->setProfissao($post);
		$this->setFoneFixo($post);
		$this->setFoneCelular($post);
		$this->setIdUsuario($post);
		$this->setEmail($post);
		$this->setLocalAtend($post);
		$this->setStatus($post);
		$this->setIdParticipante($post);

	}

	public function getNome(){
		return $this->nome;
	}

	public function setNome($post){
		if(isset($post['nome'])){
			$this->nome = trim($post['nome']);
		}else{
			$this->nome = "";
		}
	}

	public function getData(){
		return $this->data;
	}

	public function setData($post){

		if(isset($post['dataNasc'])){

			$data = str_replace("/", "-", $post['dataNasc']);

			if($data == ""){
				$data = date("Y-m-d");
			}else{			
				if($this->validateDate($data)){									
					$d = new DateTime($data);
					$data = $d->format('Y-m-d');
				}else{				
					$data = date("Y-m-d");
				}
			}
		}else{
			$data = date("Y-m-d");
		}

		$this->data = $data;
	}

	public function getIdade(){
		return $this->idade;
	}

	public function setIdade($post){

		if(isset($post['idade']) && is_numeric($post['idade'])){
			$this->idade = $post['idade'];
		}else{
			$this->idade = $this->verIdade($this->data);
		}		
		
	}

	public function getEstadoCivil(){
		return $this->estadoCivil;
	}

	public function setEstadoCivil($post){
		if(isset($post['EstadoCivil'])){
			$this->estadoCivil = trim($post['EstadoCivil']);
		}else{
			$this->estadoCivil = null;
		}
		
	}

	public function getProfissao(){
		return $this->profissao;
	}

	public function setProfissao($post){
		if(isset($post['profissao'])){
			$this->profissao = trim($post['profissao']);
		}else{
			$this->profissao = null;
		}
	}

	public function getFoneFixo(){
		return $this->foneFixo;
	}

	public function setFoneFixo($post){
		if(isset($post['telefone'])){
			$foneFixo = preg_replace("/[^0-9]/", "", trim($post['telefone']));
			$this->foneFixo = $foneFixo;
		}else{
			$this->foneFixo = null;
		}
	}

	public function getFoneCelular(){
		return $this->foneCelular;
	}

	public function setFoneCelular($post){
		if(isset($post['celular'])){
			$foneCelular = preg_replace("/[^0-9]/", "", trim($post['celular']));
			$this->foneCelular = $foneCelular;
		}else{
			$this->foneCelular = null;
		}
	}

	public function getIdUsuario(){
		return $this->idUsuario;
	}

	public function setIdUsuario($post){
		if(isset($post['idUsuario']) && is_numeric($post['idUsuario'])){
			$this->idUsuario = trim($post['idUsuario']);
		}else{
			$this->idUsuario = null;
		}
		
	}

	public function getIdParticipante(){
		return $this->idParticipante;
	}

	public function setIdParticipante($post){
		
		if(isset($post['idParticipante']) && is_numeric($post['idParticipante'])){
			$this->idParticipante = trim($post['idParticipante']);
		}else{
			$this->idParticipante = null;
		}
	}

	public function getEmail(){
		return $this->email;
	}

	public function setEmail($post){
		if(isset($post['email'])){
			$this->email = trim($post['email']);
		}else{
			$this->email = null;
		}
	}

	public function getLocalAtend(){
		return $this->localAtend;
	}

	public function setLocalAtend($post){
		if(isset($post['localAtend'])){
			$this->localAtend = trim($post['localAtend']);
		}else{
			$this->localAtend = null;
		}
	}

	public function getStatus(){
		return $this->status;
	}

	public function setStatus($post){
		if(isset($post['status'])){
			$this->status = trim($post['status']);
		}else{
			$this->status = 1;
		}
	}

	function validateDate($date){

	    $data = explode("-",$date); // fatia a string $dat em pedados, usando / como referência
	    $d = $data[0];
	    $m = $data[1];
	    $y = $data[2];	 
	   
	    $res = checkdate($m,$d,$y);
	    if ($res == 1){
	       return(true);
	    } else {
	       return(false);
	    }
	}
	

	function verIdade($data){
		// Declara a data! :P	    	    
	    // Separa em dia, mês e ano
	    list($ano, $mes, $dia) = explode('-', $data);	    
	    // Descobre que dia é hoje e retorna a unix timestamp
	    $hoje = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
	    // Descobre a unix timestamp da data de nascimento do fulano
	    $nascimento = mktime( 0, 0, 0, $mes, $dia, $ano);	    
	    // Depois apenas fazemos o cálculo já citado :)
	    $idade = floor((((($hoje - $nascimento) / 60) / 60) / 24) / 365.25);
	 
	    return $idade;

	}

}



?>

