<?php
/**
 * Visualizador de Logs de Erro
 * 
 * ATENÇÃO: Este arquivo deve ser protegido por senha em produção!
 * Nunca deixe logs de erro públicos!
 */

// Senha de proteção (ALTERE ISSO EM PRODUÇÃO!)
define('LOG_PASSWORD', 'admin123'); // ALTERE ESTA SENHA!

session_start();

// Verificar autenticação
if (!isset($_SESSION['log_authenticated'])) {
    if (isset($_POST['password'])) {
        if ($_POST['password'] === LOG_PASSWORD) {
            $_SESSION['log_authenticated'] = true;
        } else {
            $error = 'Senha incorreta!';
        }
    }
    
    if (!isset($_SESSION['log_authenticated'])) {
        ?>
        <!DOCTYPE html>
        <html lang="pt-BR">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Login - Visualizador de Logs</title>
            <style>
                body {
                    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    min-height: 100vh;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    margin: 0;
                }
                .login-box {
                    background: white;
                    padding: 40px;
                    border-radius: 12px;
                    box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                    max-width: 400px;
                    width: 100%;
                }
                h1 {
                    margin: 0 0 30px;
                    color: #333;
                    text-align: center;
                }
                input[type="password"] {
                    width: 100%;
                    padding: 12px;
                    border: 2px solid #ddd;
                    border-radius: 6px;
                    font-size: 16px;
                    box-sizing: border-box;
                }
                button {
                    width: 100%;
                    padding: 12px;
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    color: white;
                    border: none;
                    border-radius: 6px;
                    font-size: 16px;
                    font-weight: 600;
                    cursor: pointer;
                    margin-top: 15px;
                }
                .error {
                    color: #e74c3c;
                    text-align: center;
                    margin-top: 15px;
                }
            </style>
        </head>
        <body>
            <div class="login-box">
                <h1>🔒 Visualizador de Logs</h1>
                <form method="post">
                    <input type="password" name="password" placeholder="Digite a senha" required>
                    <button type="submit">Acessar</button>
                </form>
                <?php if (isset($error)): ?>
                    <div class="error"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: view_logs.php');
    exit;
}

$logFile = __DIR__ . '/error.log';
$lines = isset($_GET['lines']) ? intval($_GET['lines']) : 500;
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Ler arquivo de log
$logContent = '';
$logExists = file_exists($logFile);

if ($logExists) {
    $fileSize = filesize($logFile);
    $logContent = file_get_contents($logFile);
    
    // Filtrar por busca
    if (!empty($search)) {
        $allLines = explode("\n", $logContent);
        $filteredLines = array_filter($allLines, function($line) use ($search) {
            return stripos($line, $search) !== false;
        });
        $logContent = implode("\n", $filteredLines);
    }
    
    // Limitar número de linhas
    $allLines = explode("\n", $logContent);
    $allLines = array_reverse($allLines); // Mostrar mais recentes primeiro
    $allLines = array_slice($allLines, 0, $lines);
    $logContent = implode("\n", $allLines);
}

// Listar logs arquivados
$archivedLogs = glob(__DIR__ . '/error_*.log');
rsort($archivedLogs);

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visualizador de Logs de Erro</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f7fa;
            padding: 20px;
        }
        .header {
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .header h1 {
            color: #333;
            margin-bottom: 10px;
        }
        .controls {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            align-items: center;
        }
        .controls input,
        .controls select,
        .controls button {
            padding: 10px 15px;
            border: 2px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
        }
        .controls button {
            background: #667eea;
            color: white;
            border: none;
            cursor: pointer;
            font-weight: 600;
        }
        .controls button:hover {
            background: #5568d3;
        }
        .controls .danger {
            background: #e74c3c;
        }
        .controls .danger:hover {
            background: #c0392b;
        }
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }
        .stat-card {
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .stat-card h3 {
            color: #666;
            font-size: 14px;
            margin-bottom: 10px;
        }
        .stat-card .value {
            font-size: 28px;
            font-weight: 700;
            color: #333;
        }
        .log-container {
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow-x: auto;
        }
        .log-content {
            font-family: 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.6;
            white-space: pre-wrap;
            word-wrap: break-word;
        }
        .error-line {
            color: #f48771;
        }
        .warning-line {
            color: #dcdcaa;
        }
        .fatal-line {
            color: #f48771;
            font-weight: bold;
        }
        .exception-line {
            color: #ce9178;
        }
        .date-line {
            color: #4fc1ff;
        }
        .archived-logs {
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .archived-logs h2 {
            color: #333;
            margin-bottom: 15px;
        }
        .archived-logs ul {
            list-style: none;
        }
        .archived-logs li {
            padding: 10px;
            border-bottom: 1px solid #eee;
        }
        .archived-logs a {
            color: #667eea;
            text-decoration: none;
        }
        .archived-logs a:hover {
            text-decoration: underline;
        }
        .logout {
            float: right;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>📊 Visualizador de Logs de Erro</h1>
        <form class="controls" method="get">
            <input type="text" name="search" placeholder="Buscar..." value="<?php echo htmlspecialchars($search); ?>">
            <select name="lines">
                <option value="100" <?php echo $lines == 100 ? 'selected' : ''; ?>>100 linhas</option>
                <option value="500" <?php echo $lines == 500 ? 'selected' : ''; ?>>500 linhas</option>
                <option value="1000" <?php echo $lines == 1000 ? 'selected' : ''; ?>>1000 linhas</option>
                <option value="5000" <?php echo $lines == 5000 ? 'selected' : ''; ?>>5000 linhas</option>
            </select>
            <button type="submit">Filtrar</button>
            <button type="button" onclick="location.href='view_logs.php'">Limpar</button>
            <button type="button" onclick="location.reload()">Atualizar</button>
            <button type="button" class="logout" onclick="location.href='?logout=1'">Sair</button>
        </form>
    </div>

    <div class="stats">
        <div class="stat-card">
            <h3>Status do Log</h3>
            <div class="value"><?php echo $logExists ? '✓ Ativo' : '✗ Vazio'; ?></div>
        </div>
        <div class="stat-card">
            <h3>Tamanho do Arquivo</h3>
            <div class="value"><?php echo $logExists ? round($fileSize / 1024, 2) . ' KB' : '0 KB'; ?></div>
        </div>
        <div class="stat-card">
            <h3>Linhas Exibidas</h3>
            <div class="value"><?php echo substr_count($logContent, "\n"); ?></div>
        </div>
        <div class="stat-card">
            <h3>Última Atualização</h3>
            <div class="value" style="font-size: 16px;">
                <?php echo $logExists ? date('d/m/Y H:i:s', filemtime($logFile)) : 'N/A'; ?>
            </div>
        </div>
    </div>

    <?php if (!empty($archivedLogs)): ?>
    <div class="archived-logs">
        <h2>📦 Logs Arquivados</h2>
        <ul>
            <?php foreach ($archivedLogs as $archivedLog): ?>
                <li>
                    <a href="<?php echo basename($archivedLog); ?>" target="_blank">
                        <?php echo basename($archivedLog); ?>
                    </a>
                    (<?php echo round(filesize($archivedLog) / 1024, 2); ?> KB)
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php endif; ?>

    <div class="log-container">
        <div class="log-content">
<?php 
if ($logExists && !empty($logContent)) {
    $lines = explode("\n", $logContent);
    foreach ($lines as $line) {
        $class = '';
        if (stripos($line, '[ERROR]') !== false || stripos($line, 'ERROR') !== false) {
            $class = 'error-line';
        } elseif (stripos($line, '[WARNING]') !== false) {
            $class = 'warning-line';
        } elseif (stripos($line, '[FATAL]') !== false) {
            $class = 'fatal-line';
        } elseif (stripos($line, '[EXCEPTION]') !== false) {
            $class = 'exception-line';
        } elseif (preg_match('/\[\d{4}-\d{2}-\d{2}/', $line)) {
            $class = 'date-line';
        }
        
        echo '<span class="' . $class . '">' . htmlspecialchars($line) . '</span>' . "\n";
    }
} else {
    echo "Nenhum erro registrado ainda.\n";
}
?>
        </div>
    </div>
</body>
</html>

