<?php
/**
 * Arquivo de Teste do Sistema de Log de Erros
 * 
 * ATENÇÃO: Este arquivo é apenas para testes!
 * Execute-o uma vez para verificar se o sistema está funcionando.
 * Depois, remova ou renomeie este arquivo.
 */

require_once __DIR__ . '/error_handler.php';
ErrorHandler::init();

echo "<h1>Teste do Sistema de Log de Erros</h1>";
echo "<p>Este arquivo vai gerar diferentes tipos de erros para testar o sistema de log.</p>";
echo "<hr>";

// Teste 1: Notice
echo "<h2>Teste 1: Notice (variável não definida)</h2>";
try {
    echo $variavel_nao_definida;
    echo "<p style='color: green;'>✓ Notice foi gerado e logado</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Erro: " . $e->getMessage() . "</p>";
}
echo "<hr>";

// Teste 2: Warning
echo "<h2>Teste 2: Warning (divisão por zero)</h2>";
try {
    $resultado = 10 / 0;
    echo "<p style='color: green;'>✓ Warning foi gerado e logado</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Erro: " . $e->getMessage() . "</p>";
}
echo "<hr>";

// Teste 3: Exception
echo "<h2>Teste 3: Exception (exceção capturada)</h2>";
try {
    throw new Exception("Esta é uma exceção de teste!");
} catch (Exception $e) {
    ErrorHandler::customLog("Exceção capturada manualmente", [
        'message' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
    echo "<p style='color: green;'>✓ Exception foi gerada e logada manualmente</p>";
}
echo "<hr>";

// Teste 4: Log Personalizado
echo "<h2>Teste 4: Log Personalizado</h2>";
ErrorHandler::customLog("Teste de log personalizado", [
    'tipo' => 'teste',
    'usuario' => 'admin',
    'timestamp' => date('Y-m-d H:i:s')
]);
echo "<p style='color: green;'>✓ Log personalizado foi criado</p>";
echo "<hr>";

// Teste 5: Informações sobre o arquivo de log
echo "<h2>Informações do Sistema de Log</h2>";
$logFile = __DIR__ . '/error.log';
if (file_exists($logFile)) {
    echo "<p><strong>Arquivo de log:</strong> " . $logFile . "</p>";
    echo "<p><strong>Tamanho:</strong> " . round(filesize($logFile) / 1024, 2) . " KB</p>";
    echo "<p><strong>Última modificação:</strong> " . date('d/m/Y H:i:s', filemtime($logFile)) . "</p>";
    echo "<p style='color: green;'>✓ Arquivo de log existe e está funcionando!</p>";
} else {
    echo "<p style='color: orange;'>⚠ Arquivo de log ainda não foi criado. Execute este teste novamente.</p>";
}
echo "<hr>";

// Link para visualizador
echo "<h2>Próximos Passos</h2>";
echo "<ol>";
echo "<li><a href='view_logs.php' target='_blank'>Abrir Visualizador de Logs</a> (Senha padrão: admin123)</li>";
echo "<li>Verifique se todos os erros de teste foram registrados</li>";
echo "<li>Após verificar, <strong>remova ou renomeie este arquivo</strong> (test_error_log.php)</li>";
echo "</ol>";

echo "<hr>";
echo "<p><em>Sistema desenvolvido para TRDAP - " . date('Y') . "</em></p>";

// Descomentar a linha abaixo para testar erro fatal (vai interromper a execução)
// echo "<h2>Teste 5: Erro Fatal (descomentar para testar)</h2>";
// funcao_que_nao_existe();
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teste de Log de Erros</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background: #f5f7fa;
        }
        h1 {
            color: #333;
            border-bottom: 3px solid #667eea;
            padding-bottom: 10px;
        }
        h2 {
            color: #667eea;
            margin-top: 20px;
        }
        a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        a:hover {
            text-decoration: underline;
        }
        hr {
            border: none;
            border-top: 1px solid #ddd;
            margin: 20px 0;
        }
    </style>
</head>
</html>

