# Sistema de Log de Erros - TRDAP

## 📋 Visão Geral

Este sistema captura e registra automaticamente todos os erros PHP, incluindo erros 500 (Internal Server Error), fornecendo logs detalhados para facilitar o debug e manutenção da aplicação.

## 🚀 Como Funciona

O sistema intercepta todos os tipos de erros PHP:
- **Erros Fatais** (E_ERROR, E_PARSE, E_CORE_ERROR)
- **Warnings** (E_WARNING)
- **Notices** (E_NOTICE)
- **Exceções não capturadas**
- **Erros de shutdown** (que causam erro 500)

## 📁 Arquivos do Sistema

```
error/
├── error_handler.php    # Classe principal de manipulação de erros
├── error.log            # Arquivo de log principal (gerado automaticamente)
├── view_logs.php        # Interface web para visualizar logs
└── README.md            # Esta documentação
```

## 💻 Como Usar

### Integração Automática

Os arquivos principais já estão configurados:
- `index.php` (mauriceatabosa.com.br)
- `index.php` (siteoriginal)

### Integração Manual em Outros Arquivos

Para adicionar o sistema de log em outros arquivos PHP:

```php
<?php
// No início do seu arquivo PHP
require_once __DIR__ . '/init_error_handler.php';

// Seu código continua aqui...
```

### Log Personalizado

Você pode adicionar logs personalizados no seu código:

```php
<?php
// Log simples
ErrorHandler::customLog('Descrição do evento');

// Log com contexto adicional
ErrorHandler::customLog('Usuário realizou login', [
    'user_id' => 123,
    'ip' => $_SERVER['REMOTE_ADDR'],
    'timestamp' => time()
]);
```

## 🔍 Visualizando os Logs

### Via Interface Web

1. Acesse: `http://seusite.com/error/view_logs.php`
2. Entre com a senha: `admin123` (padrão - **ALTERE ISSO!**)
3. Use os filtros para buscar erros específicos

### Via Arquivo Direto

Os logs são salvos em: `error/error.log`

Você pode visualizá-los diretamente via FTP/SSH ou editor de texto.

## 📊 Formato do Log

Cada entrada de erro contém:

```
[2025-10-09 14:30:45] [FATAL] Call to undefined function teste() in /path/file.php on line 10
Context:
Array
(
    [URL] => /index.php
    [Method] => GET
    [IP] => 192.168.1.1
    [User Agent] => Mozilla/5.0...
    [POST Data] => Empty
    [GET Data] => {"page":"home"}
    [Session Data] => {"user_id":"123"}
)
================================================================================
--------------------------------------------------------------------------------
```

## 🔒 Segurança

### IMPORTANTE - Altere a Senha Padrão!

**Antes de usar em produção**, altere a senha em `error/view_logs.php`:

```php
// Linha 10
define('LOG_PASSWORD', 'SUA_SENHA_FORTE_AQUI');
```

### Proteção do Diretório

Adicione as seguintes regras no `.htaccess` do diretório `error/`:

```apache
# Bloquear acesso direto aos arquivos de log
<Files "*.log">
    Order allow,deny
    Deny from all
</Files>

# Permitir apenas view_logs.php
<FilesMatch "^(view_logs\.php)$">
    Order allow,deny
    Allow from all
</FilesMatch>
```

### Proteção Adicional por IP

Para restringir acesso apenas a IPs específicos, adicione no `.htaccess`:

```apache
<Files "view_logs.php">
    Order deny,allow
    Deny from all
    Allow from 192.168.1.100  # Seu IP
</Files>
```

## 🔧 Configurações Avançadas

### Rotação de Logs

Os logs são automaticamente rotacionados quando atingem 10MB. Os arquivos antigos são salvos como:
- `error_2025-10-09_14-30-45.log`
- `error_2025-10-08_10-15-30.log`

### Personalizar Tamanho Máximo

Edite `error_handler.php`, linha ~152:

```php
// Altere 10485760 (10MB) para o valor desejado em bytes
if (file_exists(self::$logFile) && filesize(self::$logFile) > 10485760) {
```

### Desabilitar Logs em Produção

Se necessário desabilitar temporariamente:

```php
// No início do arquivo
// ErrorHandler::init(); // Comentar esta linha
```

## 🐛 Troubleshooting

### Logs não estão sendo gerados

1. Verifique permissões da pasta `error/`:
   ```bash
   chmod 755 error/
   ```

2. Verifique se o PHP pode escrever:
   ```bash
   touch error/error.log
   chmod 666 error/error.log
   ```

### Erro 500 ao acessar view_logs.php

1. Verifique se o arquivo existe
2. Verifique permissões de execução
3. Verifique logs do servidor Apache

### Logs muito grandes

1. Acesse o visualizador e baixe os logs antigos
2. Delete manualmente arquivos `.log` antigos
3. Considere reduzir o limite de rotação

## 📞 Suporte

Para problemas ou dúvidas:
- Verifique primeiro os logs em `error/error.log`
- Consulte a documentação PHP oficial
- Entre em contato com o desenvolvedor do sistema

## 📝 Changelog

### Versão 1.0.0 (09/10/2025)
- Sistema inicial de log de erros
- Captura de erros fatais e exceções
- Interface web para visualização
- Sistema de rotação automática de logs
- Proteção por senha

## 📄 Licença

Este sistema foi desenvolvido para uso exclusivo do projeto TRDAP.

---

**⚠️ LEMBRE-SE:** Sempre altere a senha padrão antes de usar em produção!

