<!doctype html>
<html lang="en">
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">

	<title>Calcular Frete</title>
</head>
<body style="padding: 30px;">
	<h1>Calcular Frete</h1>
	<div class="content">
		<form method="post" action="">
			<div class="form-group">
				<label for="sCepDestino">CEP</label>
				<input type="text" class="form-control" name="sCepDestino" id="sCepDestino" placeholder="00000-000" required="">
			</div>
			<div class="form-group">
				<label for="endereco">Endereço</label>
				<input type="text" class="form-control" id="endereco" name="endereco" placeholder="Endereço" >
			</div>
			<div class="form-group">
				<label for="numero">Número</label>
				<input type="text" class="form-control" id="numero" name="numero" placeholder="Número" required>
			</div>
			<div class="form-group">
				<label for="bairro">Bairro</label>
				<input type="text" class="form-control" id="bairro" name="bairro" placeholder="Bairro" >
			</div>
			<div class="form-group">
				<label for="cidade">Cidade / Estado</label>
				<input type="text" class="form-control" id="cidade" name="cidade" placeholder="Cidade" >
			</div>
			<div class="form-group">
				<label for="estado">Cidade / Estado</label>
				<input type="text" class="form-control" id="estado" name="estado" placeholder="Estado" >
			</div>
			<div class="form-check">
				<input type="radio" name="pacote" id="pacote_001A" codigo="001A" valor="135.00" value="1" checked="">
				<label class="form-check-label" for="exampleRadios1">
					Pacote de 20 testes COM Jogo
				</label>
			</div>
			<input type="hidden" name="valor" id="valor" value="50">
			<input type="hidden" name="codigo" id="codigo" value="001A">
			<input type="hidden" name="sCepOrigem" value="53407030"/>
			<input type="hidden" name="nVlPeso" value="1"/>
			<input type="hidden" name="nVlComprimento" value="27"/>
			<input type="hidden" name="nVlAltura" value="9"/>
			<input type="hidden" name="nVlLargura" value="18"/>
			<input type="hidden" name="nCdServico" value="41106"/>

			<div class="form-check">
				<input type="radio" name="pacote" id="pacote_002A" codigo="002A" valor="450.00" value="1">
				<label class="form-check-label" for="exampleRadios2">
					Pacote de 80 testes COM Jogo
				</label>
			</div>
			<div class="form-check">
				<input type="radio" name="pacote" id="pacote_002A" codigo="002A" valor="450.00" value="1">
				<label class="form-check-label" for="exampleRadios2">
					Pacote de 80 testes COM Jogo
				</label>
			</div>
			<div class="form-check">
				<input type="radio" name="pacote" id="pacote_003A" codigo="003A" valor="900.00" value="1">
				<label class="form-check-label" for="exampleRadios3">
					Pacote de 200 testes COM Jogo
				</label>
			</div>
			<div class="form-check">
				<input type="radio" name="pacote" id="pacote_004A" codigo="004A" valor="50.00" value="1">
				<label class="form-check-label" for="exampleRadios3">
					Dominó
				</label>
			</div>
			<div class="form-group qtd " style="display: none">
				<label for="qtd">Quantidade</label>
				<select name="qtdJogoDomino" class="form-control" id="qtdJogoId">
					<option value="1">1</option>
					<option value="2">2</option>
					<option value="3">3</option>
					<option value="4">4</option>
					<option value="5">5</option>
					<option value="6">6</option>
				</select>
			</div>

			<div class="form-group">
				<label for="qtd">Quantidade</label>
				<select name="nCdServico" class="form-control" id="nCdServico">
                    <option value="41106" selected="">PAC </option>
                    <option value="40010">SEDEX </option>
                </select>
			</div>


			<button class="btn btn-primary">Calcular</button>
		</form>
	</div>

	<br />

	<div id="result"></div>
	<!-- Optional JavaScript -->
	<!-- jQuery first, then Popper.js, then Bootstrap JS -->
	<!-- <script src="//code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script> -->
	<script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
	<!-- <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script> -->
</body>
</html>
<script type="text/javascript">
	$(
		function()
		{
			$('input[name=pacote]').on('click', function()
			{
				if($(this).attr('id') == 'pacote_004A') {
					$('.qtd').show();
				} else {
					$('.qtd').hide();
				}
				$('#valor').val(parseInt($(this).val()) * $(this).attr('valor'));
				console.log($(this).attr('codigo'));
				$('#codigo').val($(this).attr('codigo'));
			})
			$('form').on('submit', function(e)
			{
				$('#result').html('<img src="Spinner.gif" />');
				e.preventDefault();
				let data = $(this).serialize();
				$.ajax({
				  method: "POST",
				  url: '/paypal/frete2.php',
				  data: data,
				  success: function(res)
				  {
				  	$('#result').html(res);
				  }
				});
			})
			$('#qtdJogoId').on('change', function()
			{
				let base = 50.00
				$('#pacote_004A').val($(this).val()).attr('valor', parseInt($(this).val()) * base);
				$('#valor').val(parseInt($(this).val()) * base);
			})

			$("#sCepDestino").blur(function() {
		        //Nova variável "cep" somente com dígitos.
		        var cep = $(this).val().replace(/\D/g, '');
		        console.log(cep);
		        //Verifica se campo cep possui valor informado.
		        if (cep != "") {

		            //Expressão regular para validar o CEP.
		            var validacep = /^[0-9]{8}$/;

		            //Valida o formato do CEP.
		            if(validacep.test(cep)) {

		                //Preenche os campos com "..." enquanto consulta webservice.
		                // $("#shippingAddressStreet").val("...");
		                // $("#shippingAddressDistrict").val("...");
		                // $("#shippingAddressCity").val("...");
		                // $("#shippingAddressState").val("...");
		                // $("#ibge").val("...");

		                //Consulta o webservice viacep.com.br/
		                calcularCep(cep)
		            } //end if.
		            else {
		                //cep é inválido.
		                // limpa_formulário_cep();
		                alert("Formato de CEP inválido.");
		            }
		        } //end if.
		        else {
		            //cep sem valor, limpa formulário.
		            // limpa_formulário_cep();
		        }
		    });

		}
		)
		function calcularCep(cep)
		{
			$.getJSON("//viacep.com.br/ws/"+ cep +"/json/?callback=?", function(dados) {

            	if (!("erro" in dados)) {
            		$('#endereco').val(dados.logradouro)
                    //Atualiza os campos com os valores da consulta.
                    // $("#shippingAddressStreet").val(dados.logradouro);
                    $("#bairro").val(dados.bairro);
                    $("#cidade").val(dados.localidade);
                    $("#estado").val(dados.uf);
                    // $("#shippingAddressState").val(dados.uf);
                    // $("#ibge").val(dados.ibge);
                } //end if.
                else {
                    //CEP pesquisado não foi encontrado.
                    // limpa_formulário_cep();
                    alert("CEP não encontrado.");
                }
            });
		}
	</script>

<?php /*
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Pix3 Maneger 2.0</title>
		<?php include"../includes/header.php"; ?>

		<?php
		include '../classes/classe_querys.php';

		if(isset($_GET["pagina"])) {
			$pagina = $_GET["pagina"];
		}

	?>
	<style type="text/css">
		.valoresListagemUser .titulo2,
		.tituloListagemUser .titulo2 {
		    float: left;
		    padding: 7px 0 0 10px;
		    height: 28px;
		    width: 25%;
		    font-size: 12px;
		    font-family: verdana;
		    color: #4F4F4E;
		    border-right: 1px solid #CCCCCC;
		}
		.item {
		    float: left;
		    padding: 7px 0 0 10px;
		    height: 28px;
		    width: 50%;
		    font-size: 12px;
		    font-family: verdana;
		    color: #4F4F4E;
		    border-right: 1px solid #CCCCCC;
		}
		.valoresListagemUser .datCad,
		.tituloListagemUser .datCad {
		    width: 13% !important;
		}
	</style>
</head>

<div id="boxOpcoes">

</div>

<div class="tituloSecao">
	<div class="titulo">Calcular Frete</div>
</div>


<form id="box-form-editarCadastro">
	<fieldset>
		<label for="cep">CEP:<br />
			<input type="text" name="cep" id="cep" value="" class="required estilo-input-text-form-contato" required />
		</label>
		<label for="endereco">Endereço<br />
			<input type="text" name="endereco" id="endereco" style="width: 600px" />
		</label>
		<label for="numero">Número<br />
			<input type="text" name="numero" id="numero" required/>
		</label>
	</fieldset>
</form>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
*/?>
